/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataframe;

import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.dataframe.ColumnType;

public class ColumnMeta
implements Writeable,
ToXContentObject {
    private static final String NAME_FIELD = "name";
    private static final String COLUMN_TYPE_FIELD = "column_type";
    private final String name;
    private final ColumnType columnType;

    ColumnMeta(StreamInput in) throws IOException {
        this.name = in.readOptionalString();
        this.columnType = (ColumnType)in.readEnum(ColumnType.class);
    }

    public static ColumnMeta parse(XContentParser parser) throws IOException {
        String name = null;
        ColumnType columnType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block8;
                }
                case "column_type": {
                    columnType = ColumnType.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new ColumnMeta(name, columnType);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        out.writeEnum((Enum)this.columnType);
    }

    public void toXContent(XContentBuilder builder) throws IOException {
        this.toXContent(builder, EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD, this.name);
        builder.field(COLUMN_TYPE_FIELD, (Object)this.columnType);
        builder.endObject();
        return builder;
    }

    @Generated
    public static ColumnMetaBuilder builder() {
        return new ColumnMetaBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @Generated
    public ColumnMeta(String name, ColumnType columnType) {
        this.name = name;
        this.columnType = columnType;
    }

    @Generated
    public String toString() {
        return "ColumnMeta(name=" + this.getName() + ", columnType=" + this.getColumnType() + ")";
    }

    @Generated
    public static class ColumnMetaBuilder {
        @Generated
        private String name;
        @Generated
        private ColumnType columnType;

        @Generated
        ColumnMetaBuilder() {
        }

        @Generated
        public ColumnMetaBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ColumnMetaBuilder columnType(ColumnType columnType) {
            this.columnType = columnType;
            return this;
        }

        @Generated
        public ColumnMeta build() {
            return new ColumnMeta(this.name, this.columnType);
        }

        @Generated
        public String toString() {
            return "ColumnMeta.ColumnMetaBuilder(name=" + this.name + ", columnType=" + this.columnType + ")";
        }
    }
}

