/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.ad.annotation.Generated;
import org.opensearch.ad.common.exception.ADValidationException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.constant.CommonValue;
import org.opensearch.ad.model.AnomalyDetectorType;
import org.opensearch.ad.model.DetectionDateRange;
import org.opensearch.ad.model.DetectorValidationIssueType;
import org.opensearch.ad.model.Feature;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.model.TimeConfiguration;
import org.opensearch.ad.model.ValidationAspect;
import org.opensearch.ad.settings.NumericSetting;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public class AnomalyDetector
implements Writeable,
ToXContentObject {
    public static final String PARSE_FIELD_NAME = "AnomalyDetector";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(AnomalyDetector.class, new ParseField("AnomalyDetector", new String[0]), it -> AnomalyDetector.parse(it));
    public static final String NO_ID = "";
    public static final String ANOMALY_DETECTORS_INDEX = ".opendistro-anomaly-detectors";
    public static final String TYPE = "_doc";
    public static final String QUERY_PARAM_PERIOD_START = "period_start";
    public static final String QUERY_PARAM_PERIOD_END = "period_end";
    public static final String GENERAL_SETTINGS = "general_settings";
    public static final String NAME_FIELD = "name";
    private static final String DESCRIPTION_FIELD = "description";
    public static final String TIMEFIELD_FIELD = "time_field";
    public static final String INDICES_FIELD = "indices";
    public static final String FILTER_QUERY_FIELD = "filter_query";
    public static final String FEATURE_ATTRIBUTES_FIELD = "feature_attributes";
    public static final String DETECTION_INTERVAL_FIELD = "detection_interval";
    public static final String WINDOW_DELAY_FIELD = "window_delay";
    public static final String SHINGLE_SIZE_FIELD = "shingle_size";
    private static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String UI_METADATA_FIELD = "ui_metadata";
    public static final String CATEGORY_FIELD = "category_field";
    public static final String USER_FIELD = "user";
    public static final String DETECTOR_TYPE_FIELD = "detector_type";
    public static final String RESULT_INDEX_FIELD = "result_index";
    public static final String AGGREGATION = "aggregation_issue";
    public static final String TIMEOUT = "timeout";
    @Deprecated
    public static final String DETECTION_DATE_RANGE_FIELD = "detection_date_range";
    private final String detectorId;
    private final Long version;
    private final String name;
    private final String description;
    private final String timeField;
    private final List<String> indices;
    private final List<Feature> featureAttributes;
    private final QueryBuilder filterQuery;
    private final TimeConfiguration detectionInterval;
    private final TimeConfiguration windowDelay;
    private final Integer shingleSize;
    private final Map<String, Object> uiMetadata;
    private final Integer schemaVersion;
    private final Instant lastUpdateTime;
    private final List<String> categoryFields;
    private User user;
    private String detectorType;
    private String resultIndex;
    @Deprecated
    private DetectionDateRange detectionDateRange;
    public static final int MAX_RESULT_INDEX_NAME_SIZE = 255;
    public static final String RESULT_INDEX_NAME_PATTERN = "[a-z0-9_-]+";

    public AnomalyDetector(String detectorId, Long version, String name, String description, String timeField, List<String> indices, List<Feature> features, QueryBuilder filterQuery, TimeConfiguration detectionInterval, TimeConfiguration windowDelay, Integer shingleSize, Map<String, Object> uiMetadata, Integer schemaVersion, Instant lastUpdateTime, List<String> categoryFields, User user, String resultIndex) {
        if (Strings.isBlank((String)name)) {
            throw new ADValidationException(CommonErrorMessages.EMPTY_DETECTOR_NAME, DetectorValidationIssueType.NAME, ValidationAspect.DETECTOR);
        }
        if (Strings.isBlank((String)timeField)) {
            throw new ADValidationException(CommonErrorMessages.NULL_TIME_FIELD, DetectorValidationIssueType.TIMEFIELD_FIELD, ValidationAspect.DETECTOR);
        }
        if (indices == null || indices.isEmpty()) {
            throw new ADValidationException(CommonErrorMessages.EMPTY_INDICES, DetectorValidationIssueType.INDICES, ValidationAspect.DETECTOR);
        }
        if (detectionInterval == null) {
            throw new ADValidationException(CommonErrorMessages.NULL_DETECTION_INTERVAL, DetectorValidationIssueType.DETECTION_INTERVAL, ValidationAspect.DETECTOR);
        }
        if (this.invalidShingleSizeRange(shingleSize)) {
            throw new ADValidationException("Shingle size must be a positive integer no larger than 60. Got " + shingleSize, DetectorValidationIssueType.SHINGLE_SIZE_FIELD, ValidationAspect.DETECTOR);
        }
        int maxCategoryFields = NumericSetting.maxCategoricalFields();
        if (categoryFields != null && categoryFields.size() > maxCategoryFields) {
            throw new ADValidationException(CommonErrorMessages.getTooManyCategoricalFieldErr(maxCategoryFields), DetectorValidationIssueType.CATEGORY, ValidationAspect.DETECTOR);
        }
        if (((IntervalTimeConfiguration)detectionInterval).getInterval() <= 0L) {
            throw new ADValidationException(CommonErrorMessages.INVALID_DETECTION_INTERVAL, DetectorValidationIssueType.DETECTION_INTERVAL, ValidationAspect.DETECTOR);
        }
        this.detectorId = detectorId;
        this.version = version;
        this.name = name;
        this.description = description;
        this.timeField = timeField;
        this.indices = indices;
        this.featureAttributes = features == null ? ImmutableList.of() : ImmutableList.copyOf(features);
        this.filterQuery = filterQuery;
        this.detectionInterval = detectionInterval;
        this.windowDelay = windowDelay;
        this.shingleSize = AnomalyDetector.getShingleSize(shingleSize);
        this.uiMetadata = uiMetadata;
        this.schemaVersion = schemaVersion;
        this.lastUpdateTime = lastUpdateTime;
        this.categoryFields = categoryFields;
        this.user = user;
        this.detectorType = AnomalyDetector.isMultientityDetector(categoryFields) ? AnomalyDetectorType.MULTI_ENTITY.name() : AnomalyDetectorType.SINGLE_ENTITY.name();
        this.resultIndex = Strings.trimToNull((String)resultIndex);
        String errorMessage = AnomalyDetector.validateResultIndex(this.resultIndex);
        if (errorMessage != null) {
            throw new ADValidationException(errorMessage, DetectorValidationIssueType.RESULT_INDEX, ValidationAspect.DETECTOR);
        }
    }

    public static String validateResultIndex(String resultIndex) {
        if (resultIndex == null) {
            return null;
        }
        if (!resultIndex.startsWith("opensearch-ad-plugin-result-")) {
            return CommonErrorMessages.INVALID_RESULT_INDEX_PREFIX;
        }
        if (resultIndex.length() > 255) {
            return CommonErrorMessages.INVALID_RESULT_INDEX_NAME_SIZE;
        }
        if (!resultIndex.matches(RESULT_INDEX_NAME_PATTERN)) {
            return CommonErrorMessages.INVALID_CHAR_IN_RESULT_INDEX_NAME;
        }
        return null;
    }

    public AnomalyDetector(StreamInput input) throws IOException {
        this.detectorId = input.readOptionalString();
        this.version = input.readOptionalLong();
        this.name = input.readString();
        this.description = input.readOptionalString();
        this.timeField = input.readString();
        this.indices = input.readStringList();
        this.featureAttributes = input.readList(Feature::new);
        this.filterQuery = (QueryBuilder)input.readNamedWriteable(QueryBuilder.class);
        this.detectionInterval = IntervalTimeConfiguration.readFrom(input);
        this.windowDelay = IntervalTimeConfiguration.readFrom(input);
        this.shingleSize = input.readInt();
        this.schemaVersion = input.readInt();
        this.categoryFields = input.readOptionalStringList();
        this.lastUpdateTime = input.readInstant();
        this.user = input.readBoolean() ? new User(input) : null;
        this.detectionDateRange = input.readBoolean() ? new DetectionDateRange(input) : null;
        this.detectorType = input.readOptionalString();
        this.uiMetadata = input.readBoolean() ? input.readMap() : null;
        this.resultIndex = input.readOptionalString();
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeOptionalString(this.detectorId);
        output.writeOptionalLong(this.version);
        output.writeString(this.name);
        output.writeOptionalString(this.description);
        output.writeString(this.timeField);
        output.writeStringCollection(this.indices);
        output.writeList(this.featureAttributes);
        output.writeNamedWriteable((NamedWriteable)this.filterQuery);
        this.detectionInterval.writeTo(output);
        this.windowDelay.writeTo(output);
        output.writeInt(this.shingleSize.intValue());
        output.writeInt(this.schemaVersion.intValue());
        output.writeOptionalStringCollection(this.categoryFields);
        output.writeInstant(this.lastUpdateTime);
        if (this.user != null) {
            output.writeBoolean(true);
            this.user.writeTo(output);
        } else {
            output.writeBoolean(false);
        }
        if (this.detectionDateRange != null) {
            output.writeBoolean(true);
            this.detectionDateRange.writeTo(output);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalString(this.detectorType);
        if (this.uiMetadata != null) {
            output.writeBoolean(true);
            output.writeMap(this.uiMetadata);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalString(this.resultIndex);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(NAME_FIELD, this.name).field(DESCRIPTION_FIELD, this.description).field(TIMEFIELD_FIELD, this.timeField).field(INDICES_FIELD, (Object)this.indices.toArray()).field(FILTER_QUERY_FIELD, (ToXContent)this.filterQuery).field(DETECTION_INTERVAL_FIELD, (ToXContent)this.detectionInterval).field(WINDOW_DELAY_FIELD, (ToXContent)this.windowDelay).field(SHINGLE_SIZE_FIELD, this.shingleSize).field("schema_version", this.schemaVersion).field(FEATURE_ATTRIBUTES_FIELD, (Object)this.featureAttributes.toArray());
        if (this.uiMetadata != null && !this.uiMetadata.isEmpty()) {
            xContentBuilder.field(UI_METADATA_FIELD, this.uiMetadata);
        }
        if (this.lastUpdateTime != null) {
            xContentBuilder.field(LAST_UPDATE_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.categoryFields != null) {
            xContentBuilder.field(CATEGORY_FIELD, (Object)this.categoryFields.toArray());
        }
        if (this.user != null) {
            xContentBuilder.field(USER_FIELD, (ToXContent)this.user);
        }
        if (this.detectorType != null) {
            xContentBuilder.field(DETECTOR_TYPE_FIELD, this.detectorType);
        }
        if (this.detectionDateRange != null) {
            xContentBuilder.field(DETECTION_DATE_RANGE_FIELD, (ToXContent)this.detectionDateRange);
        }
        if (this.resultIndex != null) {
            xContentBuilder.field(RESULT_INDEX_FIELD, this.resultIndex);
        }
        return xContentBuilder.endObject();
    }

    public static AnomalyDetector parse(XContentParser parser) throws IOException {
        return AnomalyDetector.parse(parser, null);
    }

    public static AnomalyDetector parse(XContentParser parser, String detectorId) throws IOException {
        return AnomalyDetector.parse(parser, detectorId, null);
    }

    public static AnomalyDetector parse(XContentParser parser, String detectorId, Long version) throws IOException {
        return AnomalyDetector.parse(parser, detectorId, version, null, null);
    }

    public static AnomalyDetector parse(XContentParser parser, String detectorId, Long version, TimeValue defaultDetectionInterval, TimeValue defaultDetectionWindowDelay) throws IOException {
        String name = null;
        String description = NO_ID;
        String timeField = null;
        ArrayList<String> indices = new ArrayList<String>();
        MatchAllQueryBuilder filterQuery = QueryBuilders.matchAllQuery();
        TimeConfiguration detectionInterval = defaultDetectionInterval == null ? null : new IntervalTimeConfiguration(defaultDetectionInterval.getMinutes(), ChronoUnit.MINUTES);
        TimeConfiguration windowDelay = defaultDetectionWindowDelay == null ? null : new IntervalTimeConfiguration(defaultDetectionWindowDelay.getSeconds(), ChronoUnit.SECONDS);
        Integer shingleSize = null;
        ArrayList<Feature> features = new ArrayList<Feature>();
        Integer schemaVersion = CommonValue.NO_SCHEMA_VERSION;
        Map uiMetadata = null;
        Instant lastUpdateTime = null;
        User user = null;
        DetectionDateRange detectionDateRange = null;
        String resultIndex = null;
        List categoryField = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block45: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    break;
                }
                case "description": {
                    description = parser.text();
                    break;
                }
                case "time_field": {
                    timeField = parser.text();
                    break;
                }
                case "indices": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        indices.add(parser.text());
                    }
                    continue block45;
                }
                case "ui_metadata": {
                    uiMetadata = parser.map();
                    break;
                }
                case "schema_version": {
                    schemaVersion = parser.intValue();
                    break;
                }
                case "filter_query": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    try {
                        filterQuery = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                        break;
                    }
                    catch (ParsingException | XContentParseException e) {
                        throw new ADValidationException("Custom query error in data filter: " + e.getMessage(), DetectorValidationIssueType.FILTER_QUERY, ValidationAspect.DETECTOR);
                    }
                    catch (IllegalArgumentException e) {
                        if (e.getMessage().contains("empty clause")) continue block45;
                        throw e;
                    }
                }
                case "detection_interval": {
                    try {
                        detectionInterval = TimeConfiguration.parse(parser);
                        break;
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalArgumentException && e.getMessage().contains(CommonErrorMessages.NEGATIVE_TIME_CONFIGURATION)) {
                            throw new ADValidationException("Detection interval must be a positive integer", DetectorValidationIssueType.DETECTION_INTERVAL, ValidationAspect.DETECTOR);
                        }
                        throw e;
                    }
                }
                case "feature_attributes": {
                    try {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            features.add(Feature.parse(parser));
                        }
                        continue block45;
                    }
                    catch (Exception e) {
                        if (e instanceof ParsingException || e instanceof XContentParseException) {
                            throw new ADValidationException("Custom query error: " + e.getMessage(), DetectorValidationIssueType.FEATURE_ATTRIBUTES, ValidationAspect.DETECTOR);
                        }
                        throw e;
                    }
                }
                case "window_delay": {
                    try {
                        windowDelay = TimeConfiguration.parse(parser);
                        break;
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalArgumentException && e.getMessage().contains(CommonErrorMessages.NEGATIVE_TIME_CONFIGURATION)) {
                            throw new ADValidationException("Window delay interval must be a positive integer", DetectorValidationIssueType.WINDOW_DELAY, ValidationAspect.DETECTOR);
                        }
                        throw e;
                    }
                }
                case "shingle_size": {
                    shingleSize = parser.intValue();
                    break;
                }
                case "last_update_time": {
                    lastUpdateTime = ParseUtils.toInstant(parser);
                    break;
                }
                case "category_field": {
                    categoryField = parser.list();
                    break;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    break;
                }
                case "detection_date_range": {
                    detectionDateRange = DetectionDateRange.parse(parser);
                    break;
                }
                case "result_index": {
                    resultIndex = parser.text();
                    break;
                }
                default: {
                    parser.skipChildren();
                }
            }
        }
        AnomalyDetector detector = new AnomalyDetector(detectorId, version, name, description, timeField, indices, features, (QueryBuilder)filterQuery, detectionInterval, windowDelay, AnomalyDetector.getShingleSize(shingleSize), uiMetadata, schemaVersion, lastUpdateTime, categoryField, user, resultIndex);
        detector.setDetectionDateRange(detectionDateRange);
        return detector;
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnomalyDetector detector = (AnomalyDetector)o;
        return Objects.equal((Object)this.getName(), (Object)detector.getName()) && Objects.equal((Object)this.getDescription(), (Object)detector.getDescription()) && Objects.equal((Object)this.getTimeField(), (Object)detector.getTimeField()) && Objects.equal(this.getIndices(), detector.getIndices()) && Objects.equal(this.getFeatureAttributes(), detector.getFeatureAttributes()) && Objects.equal((Object)this.getFilterQuery(), (Object)detector.getFilterQuery()) && Objects.equal((Object)this.getDetectionInterval(), (Object)detector.getDetectionInterval()) && Objects.equal((Object)this.getWindowDelay(), (Object)detector.getWindowDelay()) && Objects.equal((Object)this.getShingleSize(), (Object)detector.getShingleSize()) && Objects.equal(this.getCategoryField(), detector.getCategoryField()) && Objects.equal((Object)this.getUser(), (Object)detector.getUser()) && Objects.equal((Object)this.getResultIndex(), (Object)detector.getResultIndex());
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.detectorId, this.name, this.description, this.timeField, this.indices, this.featureAttributes, this.detectionInterval, this.windowDelay, this.shingleSize, this.uiMetadata, this.schemaVersion, this.lastUpdateTime, this.user, this.detectorType, this.resultIndex});
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTimeField() {
        return this.timeField;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public List<Feature> getFeatureAttributes() {
        return this.featureAttributes;
    }

    public QueryBuilder getFilterQuery() {
        return this.filterQuery;
    }

    public List<String> getEnabledFeatureIds() {
        return this.featureAttributes.stream().filter(Feature::getEnabled).map(Feature::getId).collect(Collectors.toList());
    }

    public List<String> getEnabledFeatureNames() {
        return this.featureAttributes.stream().filter(Feature::getEnabled).map(Feature::getName).collect(Collectors.toList());
    }

    public TimeConfiguration getDetectionInterval() {
        return this.detectionInterval;
    }

    public TimeConfiguration getWindowDelay() {
        return this.windowDelay;
    }

    public Integer getShingleSize() {
        return this.shingleSize;
    }

    private static Integer getShingleSize(Integer customShingleSize) {
        return customShingleSize == null ? 8 : customShingleSize;
    }

    public Map<String, Object> getUiMetadata() {
        return this.uiMetadata;
    }

    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public List<String> getCategoryField() {
        return this.categoryFields;
    }

    public long getDetectorIntervalInMilliseconds() {
        return ((IntervalTimeConfiguration)this.getDetectionInterval()).toDuration().toMillis();
    }

    public long getDetectorIntervalInSeconds() {
        return this.getDetectorIntervalInMilliseconds() / 1000L;
    }

    public long getDetectorIntervalInMinutes() {
        return this.getDetectorIntervalInMilliseconds() / 1000L / 60L;
    }

    public Duration getDetectionIntervalDuration() {
        return ((IntervalTimeConfiguration)this.getDetectionInterval()).toDuration();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getDetectorType() {
        return this.detectorType;
    }

    public void setDetectionDateRange(DetectionDateRange detectionDateRange) {
        this.detectionDateRange = detectionDateRange;
    }

    public DetectionDateRange getDetectionDateRange() {
        return this.detectionDateRange;
    }

    public String getResultIndex() {
        return this.resultIndex;
    }

    public boolean isMultientityDetector() {
        return AnomalyDetector.isMultientityDetector(this.getCategoryField());
    }

    public boolean isMultiCategoryDetector() {
        return this.categoryFields != null && this.categoryFields.size() > 1;
    }

    private static boolean isMultientityDetector(List<String> categoryFields) {
        return categoryFields != null && categoryFields.size() > 0;
    }

    public boolean invalidShingleSizeRange(Integer shingleSizeToTest) {
        return shingleSizeToTest != null && (shingleSizeToTest < 1 || shingleSizeToTest > 60);
    }
}

