/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(16u, 24u, 23u, 25u) << ivec4(16, 24, 23, 25)) => uvec4(1048576u, 402653184u, 192937984u, 838860800u)
 * (uvec4(16u, 24u, 23u, 25u) << ivec4(23, 12, 14, 19)) => uvec4(134217728u, 98304u, 376832u, 13107200u)
 * (uvec4(23u, 12u, 14u, 19u) << ivec4(16, 24, 23, 25)) => uvec4(1507328u, 201326592u, 117440512u, 637534208u)
 * (uvec4(23u, 12u, 14u, 19u) << ivec4(23, 12, 14, 19)) => uvec4(192937984u, 49152u, 229376u, 9961472u)
 */
#version 130

void main()
{
  float[all(equal((uvec4(16u, 24u, 23u, 25u) << ivec4(16, 24, 23, 25)), uvec4(1048576u, 402653184u, 192937984u, 838860800u))) ? 1 : -1] array0;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) << ivec4(23, 12, 14, 19)), uvec4(134217728u, 98304u, 376832u, 13107200u))) ? 1 : -1] array1;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) << ivec4(16, 24, 23, 25)), uvec4(1507328u, 201326592u, 117440512u, 637534208u))) ? 1 : -1] array2;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) << ivec4(23, 12, 14, 19)), uvec4(192937984u, 49152u, 229376u, 9961472u))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
