/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class RenameMessage
extends AttributeMessage {
    public static final String TAG = "rename";
    private static final String NAMEABLE_TAG = "nameable";
    private static final String NAME_TAG = "name";

    public RenameMessage(FreeColGameObject object, String newName) {
        super(TAG, NAMEABLE_TAG, object.getId(), NAME_TAG, newName);
    }

    public RenameMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, NAMEABLE_TAG, NAME_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        FreeColGameObject fcgo;
        String nameableId = this.getStringAttribute(NAMEABLE_TAG);
        try {
            fcgo = serverPlayer.getOurFreeColGameObject(nameableId, FreeColGameObject.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!(fcgo instanceof Nameable)) {
            return serverPlayer.clientError("Not a nameable: " + nameableId);
        }
        return this.igc(freeColServer).renameObject(serverPlayer, (Nameable)((Object)fcgo), this.getStringAttribute(NAME_TAG));
    }
}

