
#ifndef KCDDB_EXPORT_H
#define KCDDB_EXPORT_H

#ifdef KCDDB_STATIC_DEFINE
#  define KCDDB_EXPORT
#  define KCDDB_NO_EXPORT
#else
#  ifndef KCDDB_EXPORT
#    ifdef KCddb_EXPORTS
        /* We are building this library */
#      define KCDDB_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KCDDB_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KCDDB_NO_EXPORT
#    define KCDDB_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KCDDB_DECL_DEPRECATED
#  define KCDDB_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KCDDB_DECL_DEPRECATED_EXPORT
#  define KCDDB_DECL_DEPRECATED_EXPORT KCDDB_EXPORT KCDDB_DECL_DEPRECATED
#endif

#ifndef KCDDB_DECL_DEPRECATED_NO_EXPORT
#  define KCDDB_DECL_DEPRECATED_NO_EXPORT KCDDB_NO_EXPORT KCDDB_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCDDB_NO_DEPRECATED
#    define KCDDB_NO_DEPRECATED
#  endif
#endif

#define KCDDB_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KCDDB_NO_DEPRECATED)
#  undef KCDDB_DEPRECATED
#  define KCDDB_DEPRECATED_EXPORT KCDDB_EXPORT
#  define KCDDB_DEPRECATED_NO_EXPORT KCDDB_NO_EXPORT
#elif defined(KCDDB_NO_DEPRECATED_WARNINGS)
#  define KCDDB_DEPRECATED
#  define KCDDB_DEPRECATED_EXPORT KCDDB_EXPORT
#  define KCDDB_DEPRECATED_NO_EXPORT KCDDB_NO_EXPORT
#else
#  define KCDDB_DEPRECATED KCDDB_DECL_DEPRECATED
#  define KCDDB_DEPRECATED_EXPORT KCDDB_DECL_DEPRECATED_EXPORT
#  define KCDDB_DEPRECATED_NO_EXPORT KCDDB_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCDDB_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCDDB_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCDDB_NO_DEPRECATED
#  define KCDDB_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50100
#endif
#ifdef KCDDB_NO_DEPRECATED_WARNINGS
#  define KCDDB_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCDDB_DEPRECATED_WARNINGS_SINCE
#  ifdef KCDDB_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCDDB_DEPRECATED_WARNINGS_SINCE KCDDB_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCDDB_DEPRECATED_WARNINGS_SINCE 0x50100
#  endif
#endif

#ifndef KCDDB_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCDDB_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50000
#endif

#ifdef KCDDB_DEPRECATED
#  define KCDDB_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KCDDB_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCDDB_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KCDDB_DEPRECATED_WARNINGS_SINCE >= 0x50100
#  define KCDDB_DEPRECATED_VERSION_5_1(text) KCDDB_DECL_DEPRECATED_TEXT(text)
#else
#  define KCDDB_DEPRECATED_VERSION_5_1(text)
#endif
#define KCDDB_DEPRECATED_VERSION_5(minor, text)      KCDDB_DEPRECATED_VERSION_5_##minor(text)
#define KCDDB_DEPRECATED_VERSION(major, minor, text) KCDDB_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KCDDB_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCDDB_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KCDDB_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KCDDB_DEPRECATED_VERSION(major, minor, text)
#  define KCDDB_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCDDB_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KCDDB_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KCDDB_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KCDDB_EXPORT_H */
