/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.annotations.ProjectUserAnnotationsProvider;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.annotation.AnnotationCompletionTagProvider;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class PhpAnnotations
implements PropertyChangeListener {
    public static final String PROP_RESOLVE_DEPRECATED_ELEMENTS = "PROP_RESOLVE_DEPRECATED_ELEMENTS";
    public static final String PROP_UNKNOWN_ANNOTATIONS_AS_TYPE_ANNOTATIONS = "PROP_UNKNOWN_ANNOTATIONS_AS_TYPE_ANNOTATIONS";
    private static final PhpAnnotations INSTANCE = new PhpAnnotations();
    private final Map<FileObject, List<AnnotationCompletionTagProvider>> cache = new WeakHashMap<FileObject, List<AnnotationCompletionTagProvider>>();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private PhpAnnotations() {
        this.getPhpOptions().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String key = evt.getKey();
                String newValue = evt.getNewValue();
                if ("phpAnnottationsResolveDeprecetatedElements".equals(key)) {
                    PhpAnnotations.this.propertyChangeSupport.firePropertyChange(PhpAnnotations.PROP_RESOLVE_DEPRECATED_ELEMENTS, null, (Object)Boolean.parseBoolean(newValue));
                } else if ("phpAnnotationsUnknownAnnotationsAsTypeAnnotations".equals(key)) {
                    PhpAnnotations.this.propertyChangeSupport.firePropertyChange(PhpAnnotations.PROP_UNKNOWN_ANNOTATIONS_AS_TYPE_ANNOTATIONS, null, (Object)Boolean.parseBoolean(newValue));
                }
            }
        });
    }

    public static PhpAnnotations getDefault() {
        return INSTANCE;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized List<AnnotationCompletionTagProvider> getCompletionTagProviders(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        List<AnnotationCompletionTagProvider> providers = this.cache.get(fileObject);
        if (providers != null) {
            return providers;
        }
        this.cache.clear();
        providers = this.computeProviders(fileObject);
        this.cache.put(fileObject, providers);
        return providers;
    }

    public boolean isResolveDeprecatedElements() {
        return this.getPhpOptions().isAnnotationsResolveDeprecatedElements();
    }

    public boolean isUnknownAnnotationsAsTypeAnnotations() {
        return this.getPhpOptions().isAnnotationsUnknownAnnotationsAsTypeAnnotations();
    }

    private List<AnnotationCompletionTagProvider> computeProviders(FileObject fileObject) {
        assert (Thread.holdsLock(this));
        ArrayList<AnnotationCompletionTagProvider> result = new ArrayList<AnnotationCompletionTagProvider>();
        result.addAll(org.netbeans.modules.php.api.annotation.PhpAnnotations.getCompletionTagProviders());
        PhpProject phpProject = PhpProjectUtils.getPhpProject(fileObject);
        if (phpProject != null) {
            ProjectPropertiesSupport.addWeakProjectPropertyChangeListener(phpProject, this);
            PhpModule phpModule = phpProject.getPhpModule();
            for (PhpFrameworkProvider provider : phpProject.getFrameworks()) {
                result.addAll(provider.getAnnotationsCompletionTagProviders(phpModule));
            }
            result.add((AnnotationCompletionTagProvider)phpProject.getLookup().lookup(ProjectUserAnnotationsProvider.class));
        }
        return result;
    }

    private PhpOptions getPhpOptions() {
        return PhpOptions.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("frameworks".equals(evt.getPropertyName())) {
            PhpAnnotations phpAnnotations = this;
            synchronized (phpAnnotations) {
                this.cache.clear();
            }
        }
    }
}

