/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.core.model.ExportImageViaObjectStorageTupleDetails;
import com.oracle.bmc.core.model.ExportImageViaObjectStorageUriDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="destinationType", defaultImpl=ExportImageDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ExportImageViaObjectStorageUriDetails.class, name="objectStorageUri"), @JsonSubTypes.Type(value=ExportImageViaObjectStorageTupleDetails.class, name="objectStorageTuple")})
@JsonFilter(value="explicitlySetFilter")
public class ExportImageDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="exportFormat")
    private final ExportFormat exportFormat;

    @Deprecated
    @ConstructorProperties(value={"exportFormat"})
    protected ExportImageDetails(ExportFormat exportFormat) {
        this.exportFormat = exportFormat;
    }

    public ExportFormat getExportFormat() {
        return this.exportFormat;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportImageDetails(");
        sb.append("super=").append(super.toString());
        sb.append("exportFormat=").append(String.valueOf((Object)this.exportFormat));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportImageDetails)) {
            return false;
        }
        ExportImageDetails other = (ExportImageDetails)((Object)o);
        return Objects.equals((Object)this.exportFormat, (Object)other.exportFormat) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.exportFormat == null ? 43 : this.exportFormat.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ExportFormat implements BmcEnum
    {
        Qcow2("QCOW2"),
        Vmdk("VMDK"),
        Oci("OCI"),
        Vhd("VHD"),
        Vdi("VDI");

        private final String value;
        private static Map<String, ExportFormat> map;

        private ExportFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExportFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ExportFormat: " + key);
        }

        static {
            map = new HashMap<String, ExportFormat>();
            for (ExportFormat v : ExportFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

