/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.ui.JFXDownloadModePanel;
import org.netbeans.modules.javafx2.project.ui.JFXIconsPanel;
import org.netbeans.modules.javafx2.project.ui.JFXJavaScriptCallbacksPanel;
import org.netbeans.modules.javafx2.project.ui.JFXRequestRuntimePanel;
import org.netbeans.modules.javafx2.project.ui.JFXSigningPanel;
import org.netbeans.modules.javafx2.project.ui.RuntimeComboBox;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JFXDeploymentPanel
extends JPanel
implements HelpCtx.Provider {
    private static final String OTHER_RUNTIME_DIALOG_TITLE = NbBundle.getMessage(JFXDeploymentPanel.class, (String)"LBL_runtime_dialog_title");
    private static final String DEFAULT_RT = NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_runtime_default");
    private static final String PREDEFINED_RT = NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_runtime_predefined");
    private static final String EMPTY_STRING = "$empty$";
    private static final String ITEMS_DELIMITER = ";";
    private File lastImageFolder = null;
    private JFXProjectProperties jfxProps;
    private static final Logger LOGGER = Logger.getLogger("javafx");
    private volatile boolean comboBoxNativeBundlingActionRunning = false;
    private JButton buttonCustomJSMessage;
    private JButton buttonDownloadMode;
    private JButton buttonIcons;
    private JButton buttonSigning;
    private JCheckBox checkBoxBLOB;
    private JCheckBox checkBoxBundle;
    private JCheckBox checkBoxDeskShortcut;
    private JCheckBox checkBoxDisableProxy;
    private JCheckBox checkBoxInstallPerm;
    private JCheckBox checkBoxMenuShortcut;
    private JCheckBox checkBoxNoInternet;
    private JCheckBox checkBoxUnrestrictedAcc;
    private JCheckBox checkBoxUpgradeBackground;
    private RuntimeComboBox comboBoxRT;
    private Box.Filler filler2;
    private Box.Filler keepInfoMessageHeight;
    private JLabel labelCommon;
    private JLabel labelCustomJS;
    private JLabel labelCustomJSMessage;
    private JLabel labelDownloadMode;
    private JLabel labelDownloadModeMessage;
    private JLabel labelIcons;
    private JLabel labelIconsMessage;
    private JLabel labelInitialRemark;
    private JLabel labelInitialRemarkSwing;
    private JLabel labelProperties;
    private JLabel labelPropertiesSwing;
    private JLabel labelRT;
    private JLabel labelSigning;
    private JLabel labelSigningMessage;
    private JPanel panelBottom;
    private JPanel panelSigning;
    private JPanel panelTopLabel;
    private JPanel panelWS1;
    private JPanel panelWS2;
    private JLabel warningSigning;

    public JFXDeploymentPanel(JFXProjectProperties props) {
        this.jfxProps = props;
        this.initComponents();
        if (JFXProjectProperties.isTrue(props.getEvaluator().getProperty("javafx.swing"))) {
            this.labelInitialRemark.setVisible(false);
            this.labelInitialRemark.setEnabled(false);
            this.labelInitialRemarkSwing.setVisible(true);
            this.labelInitialRemarkSwing.setEnabled(true);
            this.labelProperties.setVisible(false);
            this.labelProperties.setEnabled(false);
            this.labelPropertiesSwing.setVisible(true);
            this.labelPropertiesSwing.setEnabled(true);
            this.checkBoxInstallPerm.setVisible(false);
            this.checkBoxDeskShortcut.setVisible(false);
            this.checkBoxMenuShortcut.setVisible(false);
            this.labelCustomJS.setVisible(false);
            this.labelCustomJSMessage.setVisible(false);
            this.buttonCustomJSMessage.setVisible(false);
            this.labelDownloadMode.setVisible(false);
            this.labelDownloadModeMessage.setVisible(false);
            this.buttonDownloadMode.setVisible(false);
            this.checkBoxInstallPerm.setEnabled(false);
            this.checkBoxDeskShortcut.setEnabled(false);
            this.checkBoxMenuShortcut.setEnabled(false);
            this.labelCustomJS.setEnabled(false);
            this.labelCustomJSMessage.setEnabled(false);
            this.buttonCustomJSMessage.setEnabled(false);
            this.labelDownloadMode.setEnabled(false);
            this.labelDownloadModeMessage.setEnabled(false);
            this.buttonDownloadMode.setEnabled(false);
        } else {
            this.labelInitialRemark.setVisible(true);
            this.labelInitialRemark.setEnabled(true);
            this.labelInitialRemarkSwing.setVisible(false);
            this.labelInitialRemarkSwing.setEnabled(false);
            this.labelProperties.setVisible(true);
            this.labelProperties.setEnabled(true);
            this.labelPropertiesSwing.setVisible(false);
            this.labelPropertiesSwing.setEnabled(false);
            this.checkBoxInstallPerm.setModel(this.jfxProps.getInstallPermanentlyModel());
            this.checkBoxDeskShortcut.setModel(this.jfxProps.getAddDesktopShortcutModel());
            this.checkBoxMenuShortcut.setModel(this.jfxProps.getAddStartMenuShortcutModel());
            this.refreshCustomJSLabel();
            if (this.jfxProps.getRuntimeCP().isEmpty()) {
                this.buttonDownloadMode.setEnabled(false);
                this.labelDownloadMode.setEnabled(false);
                this.labelDownloadModeMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_DownloadModeNone"));
                this.labelDownloadModeMessage.setEnabled(false);
            } else {
                this.refreshDownloadModeControls();
            }
        }
        this.checkBoxUpgradeBackground.setModel(this.jfxProps.getBackgroundUpdateCheckModel());
        this.checkBoxNoInternet.setModel(this.jfxProps.getAllowOfflineModel());
        this.checkBoxDisableProxy.setModel(this.jfxProps.getDisableProxyModel());
        this.checkBoxUnrestrictedAcc.setSelected(this.jfxProps.getSigningEnabled());
        this.labelSigning.setEnabled(this.jfxProps.getSigningEnabled());
        this.labelSigningMessage.setEnabled(this.jfxProps.getSigningEnabled());
        this.checkBoxBLOB.setEnabled(this.jfxProps.getSigningEnabled());
        this.checkBoxBLOB.setSelected(this.jfxProps.getBLOBSigningEnabled());
        this.buttonSigning.setEnabled(this.jfxProps.getSigningEnabled());
        this.checkBoxBundle.setSelected(this.jfxProps.getNativeBundlingEnabled());
        this.refreshSigningLabel();
        this.refreshIconsLabel();
        this.initComboRT();
    }

    private void initComboRT() {
        this.comboBoxRT.getModel().setPredefined(DEFAULT_RT);
        this.comboBoxRT.getModel().addPredefined(JFXDeploymentPanel.tokenize(PREDEFINED_RT, ITEMS_DELIMITER).toArray());
        String rt = this.jfxProps.getRequestedRT();
        this.comboBoxRT.getModel().setSelectedItem(rt != null && !rt.isEmpty() ? rt : DEFAULT_RT);
        this.comboBoxRT.setEnabled(true);
        this.comboBoxRT.setGrowAction(new AbstractAction(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_runtime_other")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFXDeploymentPanel.this.askOtherRuntime();
            }
        });
        this.comboBoxRT.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String cur = e.getItem().toString();
                    JFXDeploymentPanel.this.jfxProps.setRequestedRT(cur.equals(DEFAULT_RT) ? null : cur);
                }
            }
        });
    }

    private void initComponents() {
        this.panelTopLabel = new JPanel();
        this.labelInitialRemark = new JLabel();
        this.labelInitialRemarkSwing = new JLabel();
        this.panelBottom = new JPanel();
        this.labelCommon = new JLabel();
        this.labelIcons = new JLabel();
        this.labelIconsMessage = new JLabel();
        this.buttonIcons = new JButton();
        this.checkBoxBundle = new JCheckBox();
        this.labelSigning = new JLabel();
        this.labelSigningMessage = new JLabel();
        this.warningSigning = new JLabel();
        this.buttonSigning = new JButton();
        this.checkBoxDisableProxy = new JCheckBox();
        this.labelProperties = new JLabel();
        this.labelPropertiesSwing = new JLabel();
        this.panelWS1 = new JPanel();
        this.checkBoxNoInternet = new JCheckBox();
        this.checkBoxUpgradeBackground = new JCheckBox();
        this.panelWS2 = new JPanel();
        this.checkBoxInstallPerm = new JCheckBox();
        this.checkBoxDeskShortcut = new JCheckBox();
        this.checkBoxMenuShortcut = new JCheckBox();
        this.labelCustomJS = new JLabel();
        this.labelCustomJSMessage = new JLabel();
        this.buttonCustomJSMessage = new JButton();
        this.labelDownloadMode = new JLabel();
        this.labelDownloadModeMessage = new JLabel();
        this.buttonDownloadMode = new JButton();
        this.labelRT = new JLabel();
        this.comboBoxRT = new RuntimeComboBox();
        this.panelSigning = new JPanel();
        this.checkBoxUnrestrictedAcc = new JCheckBox();
        this.checkBoxBLOB = new JCheckBox();
        this.keepInfoMessageHeight = new Box.Filler(new Dimension(0, 32), new Dimension(0, 32), new Dimension(Short.MAX_VALUE, 32));
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setLayout(new GridBagLayout());
        this.panelTopLabel.setLayout(new GridBagLayout());
        this.labelInitialRemark.setText(NbBundle.getBundle(JFXDeploymentPanel.class).getString("JFXDeploymentPanel.labelInitialRemark.text"));
        this.labelInitialRemark.setVerticalAlignment(1);
        this.labelInitialRemark.setPreferredSize(new Dimension(1015, 35));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.panelTopLabel.add((Component)this.labelInitialRemark, gridBagConstraints);
        this.labelInitialRemarkSwing.setText(NbBundle.getBundle(JFXDeploymentPanel.class).getString("JFXDeploymentPanel.labelInitialRemarkSwing.text"));
        this.labelInitialRemarkSwing.setVerticalAlignment(1);
        this.labelInitialRemarkSwing.setPreferredSize(new Dimension(1047, 35));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.panelTopLabel.add((Component)this.labelInitialRemarkSwing, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.panelTopLabel, gridBagConstraints);
        this.panelBottom.setLayout(new GridBagLayout());
        this.labelCommon.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelCommon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(7, 0, 10, 0);
        this.panelBottom.add((Component)this.labelCommon, gridBagConstraints);
        this.labelIcons.setLabelFor(this.labelIconsMessage);
        Mnemonics.setLocalizedText((JLabel)this.labelIcons, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelIcons.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 19, 15, 10);
        this.panelBottom.add((Component)this.labelIcons, gridBagConstraints);
        this.labelIcons.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.labelIcons.text"));
        this.labelIcons.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.labelIcons.text"));
        this.labelIconsMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelIconsMessage.text"));
        this.labelIconsMessage.setPreferredSize(new Dimension(200, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.panelBottom.add((Component)this.labelIconsMessage, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonIcons, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.buttonIcons.text"));
        this.buttonIcons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXDeploymentPanel.this.buttonIconsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.panelBottom.add((Component)this.buttonIcons, gridBagConstraints);
        this.buttonIcons.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.buttonIcons.text"));
        this.buttonIcons.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.buttonIcons.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxBundle, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.checkBoxBundle.text"));
        this.checkBoxBundle.setToolTipText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.checkBoxBundle.toolTipText"));
        this.checkBoxBundle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXDeploymentPanel.this.checkBoxBundleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 15, 10, 0);
        this.panelBottom.add((Component)this.checkBoxBundle, gridBagConstraints);
        this.checkBoxBundle.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.checkBoxBundle.text"));
        this.checkBoxBundle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.checkBoxBundle.text"));
        this.labelSigning.setLabelFor(this.labelSigningMessage);
        Mnemonics.setLocalizedText((JLabel)this.labelSigning, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelSigning.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 37, 15, 10);
        this.panelBottom.add((Component)this.labelSigning, gridBagConstraints);
        this.labelSigning.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.labelSigning.text"));
        this.labelSigning.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.labelSigning.text"));
        this.labelSigningMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelSigningMessage.text"));
        this.labelSigningMessage.setPreferredSize(new Dimension(200, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.panelBottom.add((Component)this.labelSigningMessage, gridBagConstraints);
        this.warningSigning.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/javafx2/project/ui/resources/info.png")));
        this.warningSigning.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.warningSigning.text"));
        this.warningSigning.setPreferredSize(new Dimension(526, 30));
        this.warningSigning.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 36, 9, 0);
        this.panelBottom.add((Component)this.warningSigning, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonSigning, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.buttonSigning.text"));
        this.buttonSigning.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXDeploymentPanel.this.buttonSigningActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.panelBottom.add((Component)this.buttonSigning, gridBagConstraints);
        this.buttonSigning.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.buttonSigning.text"));
        this.buttonSigning.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.buttonSigning.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxDisableProxy, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.checkBoxDisableProxy.text"));
        this.checkBoxDisableProxy.setToolTipText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"TOOLTIP.JFXDeploymentPanel.checkBoxDisableProxy.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 15, 15, 0);
        this.panelBottom.add((Component)this.checkBoxDisableProxy, gridBagConstraints);
        this.checkBoxDisableProxy.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.checkBoxDisableProxy.text"));
        this.checkBoxDisableProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.checkBoxDisableProxy.text"));
        this.labelProperties.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelProperties.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(7, 0, 10, 0);
        this.panelBottom.add((Component)this.labelProperties, gridBagConstraints);
        this.labelPropertiesSwing.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelPropertiesSwing.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 0, 10, 0);
        this.panelBottom.add((Component)this.labelPropertiesSwing, gridBagConstraints);
        this.panelWS1.setLayout(new GridBagLayout());
        this.checkBoxNoInternet.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxNoInternet, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.checkBoxNoInternet.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelWS1.add((Component)this.checkBoxNoInternet, gridBagConstraints);
        this.checkBoxNoInternet.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.checkBoxNoInternet.text"));
        this.checkBoxNoInternet.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.checkBoxNoInternet.text"));
        this.checkBoxUpgradeBackground.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxUpgradeBackground, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.checkBoxUpgradeBackground.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        this.panelWS1.add((Component)this.checkBoxUpgradeBackground, gridBagConstraints);
        this.checkBoxUpgradeBackground.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.checkBoxUpgradeBackground.text"));
        this.checkBoxUpgradeBackground.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.checkBoxUpgradeBackground.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 15, 10, 0);
        this.panelBottom.add((Component)this.panelWS1, gridBagConstraints);
        this.panelWS2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxInstallPerm, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.checkBoxInstallPerm.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        this.panelWS2.add((Component)this.checkBoxInstallPerm, gridBagConstraints);
        this.checkBoxInstallPerm.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.checkBoxInstallPerm.text"));
        this.checkBoxInstallPerm.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.checkBoxInstallPerm.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxDeskShortcut, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.checkBoxDeskShortcut.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelWS2.add((Component)this.checkBoxDeskShortcut, gridBagConstraints);
        this.checkBoxDeskShortcut.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.checkBoxDeskShortcut.text"));
        this.checkBoxDeskShortcut.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.checkBoxDeskShortcut.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxMenuShortcut, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.checkBoxMenuShortcut.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelWS2.add((Component)this.checkBoxMenuShortcut, gridBagConstraints);
        this.checkBoxMenuShortcut.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.checkBoxMenuShortcut.text"));
        this.checkBoxMenuShortcut.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.checkBoxMenuShortcut.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 15, 15, 0);
        this.panelBottom.add((Component)this.panelWS2, gridBagConstraints);
        this.labelCustomJS.setLabelFor(this.labelCustomJSMessage);
        Mnemonics.setLocalizedText((JLabel)this.labelCustomJS, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelCustomJS.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 19, 15, 10);
        this.panelBottom.add((Component)this.labelCustomJS, gridBagConstraints);
        this.labelCustomJS.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.labelCustomJS.text"));
        this.labelCustomJS.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.labelCustomJS.text"));
        this.labelCustomJSMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelCustomJSMessage.text"));
        this.labelCustomJSMessage.setPreferredSize(new Dimension(200, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.panelBottom.add((Component)this.labelCustomJSMessage, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonCustomJSMessage, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.buttonCustomJSMessage.text"));
        this.buttonCustomJSMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXDeploymentPanel.this.buttonCustomJSMessageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.panelBottom.add((Component)this.buttonCustomJSMessage, gridBagConstraints);
        this.buttonCustomJSMessage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.buttonCustomJSMessage.text"));
        this.buttonCustomJSMessage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.buttonCustomJSMessage.text"));
        this.labelDownloadMode.setLabelFor(this.labelDownloadModeMessage);
        Mnemonics.setLocalizedText((JLabel)this.labelDownloadMode, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelDownloadMode.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 19, 15, 10);
        this.panelBottom.add((Component)this.labelDownloadMode, gridBagConstraints);
        this.labelDownloadMode.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.labelDownloadMode.text"));
        this.labelDownloadMode.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.labelDownloadMode.text"));
        this.labelDownloadModeMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelDownloadModeMessage.text"));
        this.labelDownloadModeMessage.setPreferredSize(new Dimension(200, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 512;
        this.panelBottom.add((Component)this.labelDownloadModeMessage, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonDownloadMode, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.buttonDownloadMode.text"));
        this.buttonDownloadMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXDeploymentPanel.this.buttonDownloadModeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelBottom.add((Component)this.buttonDownloadMode, gridBagConstraints);
        this.buttonDownloadMode.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.buttonDownloadMode.text"));
        this.buttonDownloadMode.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.buttonDownloadMode.text"));
        this.labelRT.setLabelFor(this.comboBoxRT);
        Mnemonics.setLocalizedText((JLabel)this.labelRT, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelRT.text"));
        this.labelRT.setToolTipText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelRT.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(3, 19, 15, 10);
        this.panelBottom.add((Component)this.labelRT, gridBagConstraints);
        this.labelRT.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.labelRT.text"));
        this.labelRT.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.labelRT.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 0.1;
        this.panelBottom.add((Component)this.comboBoxRT, gridBagConstraints);
        this.comboBoxRT.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.comboBoxRT.text"));
        this.comboBoxRT.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.comboBoxRT.text"));
        this.panelSigning.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxUnrestrictedAcc, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.checkBoxUnrestrictedAcc.text"));
        this.checkBoxUnrestrictedAcc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXDeploymentPanel.this.checkBoxUnrestrictedAccActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        this.panelSigning.add((Component)this.checkBoxUnrestrictedAcc, gridBagConstraints);
        this.checkBoxUnrestrictedAcc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.checkBoxUnrestrictedAcc.text"));
        this.checkBoxUnrestrictedAcc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.checkBoxUnrestrictedAcc.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxBLOB, (String)NbBundle.getMessage(JFXDeploymentPanel.class, (String)"JFXDeploymentPanel.checkBoxBLOB.text"));
        this.checkBoxBLOB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXDeploymentPanel.this.checkBoxBLOBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelSigning.add((Component)this.checkBoxBLOB, gridBagConstraints);
        this.checkBoxBLOB.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AN_JFXDeploymentPanel.checkBoxBLOB.text"));
        this.checkBoxBLOB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"AD_JFXDeploymentPanel.checkBoxBLOB.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 15, 5, 0);
        this.panelBottom.add((Component)this.panelSigning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.panelBottom.add((Component)this.keepInfoMessageHeight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 1280;
        this.add((Component)this.panelBottom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.filler2, gridBagConstraints);
    }

    private void refreshDownloadModeControls() {
        if (this.jfxProps.getRuntimeCP().size() > this.jfxProps.getLazyJars().size()) {
            if (this.jfxProps.getLazyJars().isEmpty()) {
                this.labelDownloadModeMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_DownloadModeEager"));
            } else {
                this.labelDownloadModeMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_DownloadModeMixed"));
            }
        } else {
            this.labelDownloadModeMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_DownloadModeLazy"));
        }
    }

    private void buttonCustomJSMessageActionPerformed(ActionEvent evt) {
        JFXJavaScriptCallbacksPanel rc = new JFXJavaScriptCallbacksPanel(this.jfxProps);
        DialogDescriptor dd = new DialogDescriptor((Object)rc, NbBundle.getMessage(JFXDeploymentPanel.class, (String)"TXT_JSCallbacks"), true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            this.jfxProps.setJSCallbacks(rc.getResources());
            this.jfxProps.setJSCallbacksChanged(true);
            this.refreshCustomJSLabel();
        }
    }

    private void buttonDownloadModeActionPerformed(ActionEvent evt) {
        JFXDownloadModePanel rc = new JFXDownloadModePanel(this.jfxProps.getRuntimeCP(), this.jfxProps.getLazyJars());
        DialogDescriptor dd = new DialogDescriptor((Object)rc, NbBundle.getMessage(JFXDeploymentPanel.class, (String)"TXT_ManageResources"), true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            this.jfxProps.setLazyJars(rc.getResources());
            this.jfxProps.setLazyJarsChanged(true);
            this.refreshDownloadModeControls();
        }
    }

    private void checkBoxUnrestrictedAccActionPerformed(ActionEvent evt) {
        boolean sel = this.checkBoxUnrestrictedAcc.isSelected();
        this.labelSigning.setEnabled(sel);
        this.labelSigningMessage.setEnabled(sel);
        this.checkBoxBLOB.setEnabled(sel);
        this.buttonSigning.setEnabled(sel);
        this.jfxProps.setSigningEnabled(sel);
        this.jfxProps.setPermissionsElevated(sel);
        if (this.jfxProps.getSigningEnabled() && this.jfxProps.getSigningType() == JFXProjectProperties.SigningType.NOSIGN) {
            this.jfxProps.setSigningType(JFXProjectProperties.SigningType.SELF);
        }
        this.refreshSigningLabel();
    }

    private void buttonSigningActionPerformed(ActionEvent evt) {
        JFXSigningPanel panel = new JFXSigningPanel(this.jfxProps);
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, NbBundle.getMessage(JFXSigningPanel.class, (String)"TITLE_JFXSigningPanel"), true, null);
        panel.registerListeners();
        panel.setDialogDescriptor(dialogDesc);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.setVisible(true);
        if (dialogDesc.getValue() == DialogDescriptor.OK_OPTION) {
            panel.store();
            this.refreshSigningLabel();
        }
        panel.unregisterListeners();
        dialog.dispose();
    }

    private void checkBoxBundleActionPerformed(ActionEvent evt) {
        boolean sel = this.checkBoxBundle.isSelected();
        this.jfxProps.setNativeBundlingEnabled(sel);
    }

    private void buttonIconsActionPerformed(ActionEvent evt) {
        JFXIconsPanel panel = new JFXIconsPanel(this.jfxProps, this.lastImageFolder);
        panel.registerDocumentListeners();
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, NbBundle.getMessage(JFXIconsPanel.class, (String)"TITLE_JFXIconsPanel"), true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.setVisible(true);
        if (dialogDesc.getValue() == DialogDescriptor.OK_OPTION) {
            panel.store();
            this.refreshIconsLabel();
        }
        panel.unregisterDocumentListeners();
    }

    private void checkBoxBLOBActionPerformed(ActionEvent evt) {
        boolean sel = this.checkBoxBLOB.isSelected();
        this.jfxProps.setBLOBSigningEnabled(sel);
    }

    private void refreshCustomJSLabel() {
        int jsDefs = 0;
        for (Map.Entry<String, String> entry : this.jfxProps.getJSCallbacks().entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            ++jsDefs;
        }
        if (jsDefs == 0) {
            this.labelCustomJSMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_CallbacksDefinedNone"));
        } else {
            this.labelCustomJSMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_CallbacksDefined", (Object)jsDefs));
        }
    }

    private void refreshSigningLabel() {
        if (!this.jfxProps.getSigningEnabled() || this.jfxProps.getSigningType() == JFXProjectProperties.SigningType.NOSIGN) {
            this.labelSigningMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_SigningUnsigned"));
        } else if (this.jfxProps.getSigningType() == JFXProjectProperties.SigningType.KEY) {
            this.labelSigningMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_SigningKey", (Object)this.jfxProps.getSigningKeyAlias()));
        } else {
            this.labelSigningMessage.setText(NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_SigningGenerated"));
        }
    }

    private void refreshIconsLabel() {
        String msg = "";
        if (this.jfxProps.getWSIconPath() != null && !this.jfxProps.getWSIconPath().isEmpty()) {
            msg = NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_IconsJNLPDefined");
        }
        if (this.jfxProps.getSplashImagePath() != null && !this.jfxProps.getSplashImagePath().isEmpty()) {
            String string = msg = msg.isEmpty() ? NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_IconsSplashDefined") : msg + ", " + NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_IconsSplashDefined");
        }
        if (this.jfxProps.getNativeIconPath() != null && !this.jfxProps.getNativeIconPath().isEmpty()) {
            String string = msg = msg.isEmpty() ? NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_IconsNativeDefined") : msg + ", " + NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_IconsNativeDefined");
        }
        if (msg.isEmpty()) {
            msg = NbBundle.getMessage(JFXDeploymentPanel.class, (String)"MSG_IconsUndefined");
        }
        this.labelIconsMessage.setText(msg);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JFXDeploymentPanel.class.getName());
    }

    private void askOtherRuntime() {
        JFXRequestRuntimePanel panel = new JFXRequestRuntimePanel();
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, OTHER_RUNTIME_DIALOG_TITLE, true, null);
        panel.registerListener();
        panel.setDialogDescriptor(dialogDesc);
        panel.setInputText(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.setVisible(true);
        if (dialogDesc.getValue() == DialogDescriptor.OK_OPTION) {
            String s = panel.getInputText().trim();
            this.comboBoxRT.getModel().setUserDefined(s);
            this.comboBoxRT.getModel().setSelectedItem(s);
            this.jfxProps.setRequestedRT(s);
        }
        panel.unregisterListener();
        dialog.dispose();
    }

    private static List<String> tokenize(String sequence, String delimiter) {
        StringTokenizer st = new StringTokenizer(sequence, delimiter);
        ArrayList<String> r = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            r.add(next.equals(EMPTY_STRING) ? "" : next);
        }
        return r;
    }
}

