/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.spi;

import java.io.File;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.gradle.util.GradleVersion;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.spi.Bundle;
import org.openide.util.NbPreferences;

public final class GradleSettings {
    private static final Logger LOG = Logger.getLogger(GradleSettings.class.getName());
    public static final String PROP_GRADLE_DISTRIBUTION = "gradleHome";
    public static final String PROP_PREFER_WRAPPER = "preferWrapper";
    public static final String PROP_GRADLE_USER_HOME = "gradleUserHome";
    @Deprecated
    public static final String PROP_START_DAEMON_ON_START = "startDaemonOnStart";
    public static final String PROP_REUSE_OUTPUT_TABS = "reuseOutputTabs";
    public static final String PROP_USE_CUSTOM_GRADLE = "useCustomGradle";
    @Deprecated
    public static final String PROP_GRADLE_VERSION = "gradleVersion";
    @Deprecated
    public static final String PROP_SILENT_INSTALL = "silentInstall";
    public static final String PROP_OPT_OFFLINE = "offline";
    @Deprecated
    public static final String PROP_OPT_NO_REBUILD = "noRebuild";
    public static final String PROP_OPT_USE_CONFIG_CACHE = "useConfigCache";
    public static final String PROP_OPT_CONFIGURE_ON_DEMAND = "configureOnDemand";
    public static final String PROP_SKIP_TEST = "skipTest";
    public static final String PROP_SKIP_CHECK = "skipCheck";
    public static final String PROP_LOG_LEVEL = "logLevel";
    public static final String PROP_STACKTRACE = "stacktrace";
    public static final String PROP_HIDE_EMPTY_CONF = "hideEmptyConfiguration";
    public static final String PROP_ALWAYS_SHOW_OUTPUT = "alwaysShowOutput";
    public static final String PROP_DISPLAY_DESCRIPTION = "displayDescription";
    public static final String PROP_REUSE_EDITOR_ON_STACKTRACE = "reuseEditorOnStackTace";
    @Deprecated
    public static final String PROP_DISABLE_CACHE = "disableCache";
    @Deprecated
    public static final String PROP_LAZY_OPEN_GROUPS = "lazyOpen";
    public static final String PROP_PREFER_MAVEN = "preferMaven";
    public static final String PROP_DOWNLOAD_LIBS = "downloadLibs";
    public static final String PROP_DOWNLOAD_SOURCES = "downloadSources";
    public static final String PROP_DOWNLOAD_JAVADOC = "downloadJavaDoc";
    public static final String PROP_GRADLE_EXEC_RULE = "gradleExecutionRule";
    private static final GradleSettings INSTANCE = new GradleSettings(NbPreferences.forModule(GradleSettings.class));
    private final Preferences preferences;

    @Deprecated
    public GradleSettings() {
        this(NbPreferences.forModule(GradleSettings.class));
    }

    GradleSettings(Preferences preferences) {
        this.preferences = preferences;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public static GradleSettings getDefault() {
        return INSTANCE;
    }

    public String getDistributionHome() {
        return this.getPreferences().get(PROP_GRADLE_DISTRIBUTION, "");
    }

    public void setDistributionHome(String gradleHome) {
        this.getPreferences().put(PROP_GRADLE_DISTRIBUTION, gradleHome);
    }

    public boolean isWrapperPreferred() {
        return this.getPreferences().getBoolean(PROP_PREFER_WRAPPER, true);
    }

    public void setWrapperPreferred(boolean b) {
        this.getPreferences().putBoolean(PROP_PREFER_WRAPPER, b);
    }

    public void setGradleUserHome(File dir) {
        if (dir != null) {
            this.getPreferences().put(PROP_GRADLE_USER_HOME, dir.getAbsolutePath());
        } else {
            this.getPreferences().remove(PROP_GRADLE_USER_HOME);
        }
    }

    public File getGradleUserHome() {
        String dir = this.getPreferences().get(PROP_GRADLE_USER_HOME, System.getenv("GRADLE_USER_HOME"));
        return dir != null ? new File(dir) : new File(System.getProperty("user.home"), ".gradle");
    }

    @Deprecated
    public void setSilentInstall(boolean b) {
        LOG.warning("silentInstall setting is deprecated. This setter has no effect.");
    }

    @Deprecated
    public boolean isSilentInstall() {
        return false;
    }

    public void setReuseOutputTabs(boolean b) {
        this.getPreferences().putBoolean(PROP_REUSE_OUTPUT_TABS, b);
    }

    public boolean isReuseOutputTabs() {
        String def = Bundle.DEFAULT_REUSE_OUTPUT();
        if ("never".equals(def)) {
            return false;
        }
        return this.getPreferences().getBoolean(PROP_REUSE_OUTPUT_TABS, "true".equals(def));
    }

    public void setOffline(boolean b) {
        this.getPreferences().putBoolean(PROP_OPT_OFFLINE, b);
    }

    public boolean isOffline() {
        return this.getPreferences().getBoolean(PROP_OPT_OFFLINE, false);
    }

    public void setAlwaysShowOutput(boolean b) {
        this.getPreferences().putBoolean(PROP_ALWAYS_SHOW_OUTPUT, b);
    }

    public boolean isAlwaysShowOutput() {
        return this.getPreferences().getBoolean(PROP_ALWAYS_SHOW_OUTPUT, true);
    }

    @Deprecated
    public void setStartDaemonOnStart(boolean b) {
        LOG.warning("startDaemonOnStart setting is deprecated. This setter has no effect.");
    }

    @Deprecated
    public boolean isStartDaemonOnStart() {
        return false;
    }

    public void setUseCustomGradle(boolean b) {
        this.getPreferences().putBoolean(PROP_USE_CUSTOM_GRADLE, b);
    }

    public boolean useCustomGradle() {
        return this.getPreferences().getBoolean(PROP_USE_CUSTOM_GRADLE, false);
    }

    public void setSkipTest(boolean b) {
        this.getPreferences().putBoolean(PROP_SKIP_TEST, b);
    }

    public boolean skipTest() {
        return this.getPreferences().getBoolean(PROP_SKIP_TEST, false);
    }

    public void setSkipCheck(boolean b) {
        this.getPreferences().putBoolean(PROP_SKIP_CHECK, b);
    }

    public boolean skipCheck() {
        return this.getPreferences().getBoolean(PROP_SKIP_CHECK, true);
    }

    @Deprecated
    public void setGradleVersion(String version) {
        LOG.warning("gradleVersion setting is deprecated. This setter has no effect.");
    }

    @Deprecated
    public String getGradleVersion() {
        return GradleVersion.current().getVersion();
    }

    @Deprecated
    public void setNoRebuild(boolean b) {
        LOG.warning("noRebuild setting is deprecated. This setter has no effect.");
    }

    @Deprecated
    public boolean getNoRebuild() {
        return false;
    }

    public void setUseConfigCache(boolean b) {
        this.getPreferences().putBoolean(PROP_OPT_USE_CONFIG_CACHE, b);
    }

    public boolean getUseConfigCache() {
        return this.getPreferences().getBoolean(PROP_OPT_USE_CONFIG_CACHE, false);
    }

    public void setConfigureOnDemand(boolean b) {
        this.getPreferences().putBoolean(PROP_OPT_CONFIGURE_ON_DEMAND, b);
    }

    public boolean isConfigureOnDemand() {
        return this.getPreferences().getBoolean(PROP_OPT_CONFIGURE_ON_DEMAND, true);
    }

    public void setDefaultLogLevel(GradleCommandLine.LogLevel level) {
        this.getPreferences().put(PROP_LOG_LEVEL, level.name());
    }

    public GradleCommandLine.LogLevel getDefaultLogLevel() {
        String lvl = this.getPreferences().get(PROP_LOG_LEVEL, GradleCommandLine.LogLevel.LIFECYCLE.name());
        return GradleCommandLine.LogLevel.valueOf(lvl);
    }

    public void setDefaultStackTrace(GradleCommandLine.StackTrace st) {
        this.getPreferences().put(PROP_STACKTRACE, st.name());
    }

    public GradleCommandLine.StackTrace getDefaultStackTrace() {
        String st = this.getPreferences().get(PROP_STACKTRACE, GradleCommandLine.StackTrace.NONE.name());
        return GradleCommandLine.StackTrace.valueOf(st);
    }

    public void setHideEmptyConfigurations(boolean b) {
        this.getPreferences().putBoolean(PROP_HIDE_EMPTY_CONF, b);
    }

    public boolean isHideEmptyConfigurations() {
        return this.getPreferences().getBoolean(PROP_HIDE_EMPTY_CONF, true);
    }

    public void setDisplayDescription(boolean b) {
        this.getPreferences().putBoolean(PROP_DISPLAY_DESCRIPTION, b);
    }

    public boolean isDisplayDesctiption() {
        return this.getPreferences().getBoolean(PROP_DISPLAY_DESCRIPTION, true);
    }

    public void setReuseEditorOnStackTrace(boolean b) {
        this.getPreferences().putBoolean(PROP_REUSE_EDITOR_ON_STACKTRACE, b);
    }

    public boolean isReuseEditorOnStackTace() {
        return this.getPreferences().getBoolean(PROP_REUSE_EDITOR_ON_STACKTRACE, false);
    }

    @Deprecated
    public void setOpenLazy(boolean b) {
    }

    @Deprecated
    public boolean isOpenLazy() {
        return true;
    }

    @Deprecated
    public void setCacheDisabled(boolean b) {
    }

    @Deprecated
    public boolean isCacheDisabled() {
        return false;
    }

    public void setPreferMaven(boolean b) {
        this.getPreferences().putBoolean(PROP_PREFER_MAVEN, b);
    }

    public boolean isPreferMaven() {
        return this.getPreferences().getBoolean(PROP_PREFER_MAVEN, false);
    }

    public void setDownloadLibs(DownloadLibsRule rule) {
        this.getPreferences().put(PROP_DOWNLOAD_LIBS, rule.name());
    }

    public DownloadLibsRule getDownloadLibs() {
        String ruleName = this.getPreferences().get(PROP_DOWNLOAD_LIBS, DownloadLibsRule.AS_NEEDED.name());
        return DownloadLibsRule.valueOf(ruleName);
    }

    public void setDownloadSources(DownloadMiscRule rule) {
        this.getPreferences().put(PROP_DOWNLOAD_SOURCES, rule.name());
    }

    public DownloadMiscRule getDownloadSources() {
        String ruleName = this.getPreferences().get(PROP_DOWNLOAD_SOURCES, DownloadMiscRule.ALWAYS.name());
        return DownloadMiscRule.valueOf(ruleName);
    }

    public void setDownloadJavadoc(DownloadMiscRule rule) {
        this.getPreferences().put(PROP_DOWNLOAD_JAVADOC, rule.name());
    }

    public DownloadMiscRule getDownloadJavadoc() {
        String ruleName = this.getPreferences().get(PROP_DOWNLOAD_JAVADOC, DownloadMiscRule.NEVER.name());
        return DownloadMiscRule.valueOf(ruleName);
    }

    public void setGradleExecutionRule(GradleExecutionRule rule) {
        this.getPreferences().put(PROP_GRADLE_EXEC_RULE, rule.name());
    }

    public GradleExecutionRule getGradleExecutionRule() {
        String ruleName = this.getPreferences().get(PROP_GRADLE_EXEC_RULE, GradleExecutionRule.TRUSTED_PROJECTS.name());
        return GradleExecutionRule.valueOf(ruleName);
    }

    public static enum DownloadLibsRule {
        NEVER,
        AS_NEEDED,
        ALWAYS;


        public String toString() {
            switch (this) {
                case ALWAYS: {
                    return Bundle.DL_ALWAYS();
                }
                case NEVER: {
                    return Bundle.DL_NEVER();
                }
                case AS_NEEDED: {
                    return Bundle.DL_AS_NEEDED();
                }
            }
            return this.name();
        }
    }

    public static enum DownloadMiscRule {
        NEVER,
        ALWAYS;


        public String toString() {
            switch (this) {
                case ALWAYS: {
                    return Bundle.DL_ALWAYS();
                }
                case NEVER: {
                    return Bundle.DL_NEVER();
                }
            }
            return this.name();
        }
    }

    public static enum GradleExecutionRule {
        TRUSTED_PROJECTS,
        ALWAYS;


        public String toString() {
            switch (this) {
                case TRUSTED_PROJECTS: {
                    return Bundle.GE_TRUSTED_PROJECTS();
                }
                case ALWAYS: {
                    return Bundle.GE_ALWAYS();
                }
            }
            return this.name();
        }
    }
}

