/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class WatchesNodeModelFilter
extends VariablesNodeModel
implements ExtendedNodeModelFilter {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";

    public WatchesNodeModelFilter(ContextProvider lookupProvider) {
        super(lookupProvider);
    }

    public static boolean isEmptyWatch(Object node) {
        return "EmptyWatch".equals(node.getClass().getSimpleName());
    }

    public String getDisplayName(NodeModel model, Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(WatchesNodeModelFilter.class).getString("CTL_WatchesModel_Column_Name_Name");
        }
        if (o instanceof JPDAWatch) {
            if (WatchesNodeModelFilter.isEmptyWatch(o)) {
                return "<_html><font color=\"#808080\">&lt;" + NbBundle.getBundle(WatchesNodeModelFilter.class).getString("CTL_WatchesModel_Empty_Watch_Hint") + "&gt;</font></html>";
            }
            return ((JPDAWatch)o).getExpression();
        }
        try {
            return model.getDisplayName(o);
        }
        catch (UnknownTypeException utex) {
            return super.getDisplayName(o);
        }
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        return this.getShortDescription(node);
    }

    @Override
    protected String getShortDescriptionSynch(Object o) {
        if (o instanceof JPDAWatch) {
            if (WatchesNodeModelFilter.isEmptyWatch(o)) {
                return NbBundle.getMessage(WatchesNodeModelFilter.class, (String)"TTP_NewWatch");
            }
            JPDAWatch w = (JPDAWatch)o;
            boolean evaluated = VariablesTreeModelFilter.isEvaluated(o);
            if (!evaluated) {
                return w.getExpression();
            }
            String e = w.getExceptionDescription();
            if (e != null) {
                return w.getExpression() + " = >" + e + "<";
            }
            String t = w.getType();
            if (t == null) {
                return w.getExpression() + " = " + w.getValue();
            }
            try {
                return w.getExpression() + " = (" + w.getType() + ") " + w.getToStringValue();
            }
            catch (InvalidExpressionException ex) {
                return ex.getLocalizedMessage();
            }
        }
        return super.getShortDescriptionSynch(o);
    }

    @Override
    protected void testKnown(Object o) throws UnknownTypeException {
        if (o instanceof JPDAWatch) {
            return;
        }
        super.testKnown(o);
    }

    public boolean canRename(ExtendedNodeModel model, Object node) throws UnknownTypeException {
        return model.canRename(node) || WatchesNodeModelFilter.isEmptyWatch(node);
    }

    public boolean canCopy(ExtendedNodeModel model, Object node) throws UnknownTypeException {
        return model.canCopy(node) && !WatchesNodeModelFilter.isEmptyWatch(node);
    }

    public boolean canCut(ExtendedNodeModel model, Object node) throws UnknownTypeException {
        return model.canCut(node) && !WatchesNodeModelFilter.isEmptyWatch(node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel model, Object node) throws IOException, UnknownTypeException {
        return model.clipboardCopy(node);
    }

    public Transferable clipboardCut(ExtendedNodeModel model, Object node) throws IOException, UnknownTypeException {
        return model.clipboardCut(node);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel model, Object node, Transferable t) throws UnknownTypeException {
        return model.getPasteTypes(node, t);
    }

    public void setName(ExtendedNodeModel model, Object node, String name) throws UnknownTypeException {
        ((JPDAWatch)node).setExpression(name);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String getIconBaseWithExtension(ExtendedNodeModel model, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return WATCH;
        }
        if (node instanceof JPDAWatch) {
            if (WatchesNodeModelFilter.isEmptyWatch(node)) {
                return null;
            }
            return WATCH;
        }
        try {
            return model.getIconBaseWithExtension(node);
        }
        catch (UnknownTypeException utex) {
            return super.getIconBaseWithExtension(node);
        }
    }
}

