/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.openide.util.WeakListeners;

public final class OptionsUtils {
    public static final String PAIR_CHARACTERS_COMPLETION = "pair-characters-completion";
    public static final String SQL_AUTO_COMPLETION_SUBWORDS = "sql-completion-subwords";
    public static final boolean SQL_AUTO_COMPLETION_SUBWORDS_DEFAULT = false;
    private static final AtomicBoolean INITED = new AtomicBoolean(false);
    private static final PreferenceChangeListener PREFERENCES_TRACKER = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String settingName;
            String string = settingName = evt == null ? null : evt.getKey();
            if (settingName == null || OptionsUtils.PAIR_CHARACTERS_COMPLETION.equals(settingName)) {
                pairCharactersCompletion = preferences.getBoolean(OptionsUtils.PAIR_CHARACTERS_COMPLETION, true);
            }
            if (settingName == null || OptionsUtils.SQL_AUTO_COMPLETION_SUBWORDS.equals(settingName)) {
                sqlCompletionSubwords = preferences.getBoolean(OptionsUtils.SQL_AUTO_COMPLETION_SUBWORDS, false);
            }
        }
    };
    private static Preferences preferences;
    private static boolean pairCharactersCompletion;
    private static boolean sqlCompletionSubwords;

    private OptionsUtils() {
    }

    public static boolean isPairCharactersCompletion() {
        OptionsUtils.lazyInit();
        return pairCharactersCompletion;
    }

    public static boolean isSqlCompletionSubwords() {
        OptionsUtils.lazyInit();
        return sqlCompletionSubwords;
    }

    private static void lazyInit() {
        if (INITED.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)"text/x-sql").lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)PREFERENCES_TRACKER, (Object)preferences));
            PREFERENCES_TRACKER.preferenceChange(null);
        }
    }

    static {
        pairCharactersCompletion = true;
        sqlCompletionSubwords = false;
    }
}

