/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.javascript2.editor.JsonFoldTypeProvider;
import org.netbeans.modules.javascript2.editor.Utils;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.Index;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.JsReference;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.types.api.Type;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public class JsStructureScanner
implements StructureScanner {
    private static final String FONT_GRAY_COLOR = "<font color=\"#999999\">";
    private static final String CLOSE_FONT = "</font>";
    private static final Logger LOGGER = Logger.getLogger(JsStructureScanner.class.getName());
    private final Language<JsTokenId> language;
    private static ImageIcon priviligedIcon = null;
    private static ImageIcon callbackIcon = null;
    private static ImageIcon publicGenerator = null;
    private static ImageIcon privateGenerator = null;
    private static ImageIcon priviligedGenerator = null;

    public JsStructureScanner(Language<JsTokenId> language) {
        this.language = language;
    }

    public List<? extends StructureItem> scan(ParserResult info) {
        ArrayList<StructureItem> items = new ArrayList<StructureItem>();
        long start = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Structure scanner started at {0} ms", start);
        org.netbeans.modules.javascript2.types.spi.ParserResult result = (org.netbeans.modules.javascript2.types.spi.ParserResult)info;
        Model model = Model.getModel((ParserResult)result, (boolean)false);
        model.resolve();
        JsObject globalObject = model.getGlobalObject();
        CancelSupport cancel = CancelSupport.getDefault();
        this.getEmbededItems(result, globalObject, items, new HashSet<String>(), cancel);
        long end = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Creating structure took {0} ms", new Object[]{end - start});
        return items;
    }

    private List<StructureItem> getEmbededItems(org.netbeans.modules.javascript2.types.spi.ParserResult result, JsObject jsObject, List<StructureItem> collectedItems, Set<String> processedObjects, CancelSupport cancel) {
        JsObject assignedObject;
        Collection assignmentForOffset;
        if (ModelUtils.wasProcessed((JsObject)jsObject, processedObjects)) {
            return collectedItems;
        }
        if (jsObject.isVirtual()) {
            return collectedItems;
        }
        if (cancel.isCancelled()) {
            return collectedItems;
        }
        ArrayList properties = new ArrayList(jsObject.getProperties().values());
        boolean countFunctionChild = jsObject.getJSKind().isFunction() && !jsObject.isAnonymous() && jsObject.getJSKind() != JsElement.Kind.CONSTRUCTOR && !this.containsFunction(jsObject) || "prototype".equals(jsObject.getName()) && properties.isEmpty();
        for (Object child : properties) {
            if (cancel.isCancelled()) {
                return collectedItems;
            }
            if (result.getSnapshot().getOriginalOffset(child.getOffset()) < 0 && !"prototype".equals(child.getName()) || child.isVirtual() || child.getName().equals("prototype") && child.getProperties().isEmpty()) continue;
            List<StructureItem> children = new ArrayList<StructureItem>();
            if ((countFunctionChild && !child.getModifiers().contains(Modifier.STATIC) && !child.getName().equals("prototype") || child.getJSKind() == JsElement.Kind.ANONYMOUS_OBJECT) && child.getJSKind() != JsElement.Kind.OBJECT_LITERAL || child.getJSKind().isFunction() && child.isAnonymous() && child.getParent().getJSKind().isFunction() && child.getParent().getJSKind() != JsElement.Kind.FILE) continue;
            if (!(child instanceof JsReference) || !ModelUtils.isDescendant((JsObject)child, (JsObject)((JsReference)child).getOriginal())) {
                children = this.getEmbededItems(result, (JsObject)child, children, processedObjects, cancel);
            }
            if ((child.hasExactName() || child.isAnonymous() || child.getJSKind() == JsElement.Kind.CONSTRUCTOR) && child.getJSKind().isFunction()) {
                JsFunction function = (JsFunction)child;
                if (function.isAnonymous()) {
                    collectedItems.addAll(children);
                    continue;
                }
                if (!function.isDeclared()) continue;
                collectedItems.add(new JsFunctionStructureItem(function, children, result));
                continue;
            }
            if ((child.getJSKind() == JsElement.Kind.OBJECT && (children.size() > 0 || child.isDeclared()) || child.getJSKind() == JsElement.Kind.OBJECT_LITERAL || child.getJSKind() == JsElement.Kind.ANONYMOUS_OBJECT) && (children.size() > 0 || child.isDeclared())) {
                if (jsObject.getJSKind() != JsElement.Kind.FILE || !"text/x-json".equals(jsObject.getMimeType())) {
                    collectedItems.add(new JsObjectStructureItem((JsObject)child, children, result));
                    continue;
                }
                collectedItems.addAll(children);
                continue;
            }
            if (child.getJSKind() == JsElement.Kind.PROPERTY) {
                if (!child.isDeclared() || !child.getModifiers().contains(Modifier.PUBLIC) && jsObject.getParent() instanceof JsFunction && jsObject.getJSKind() != JsElement.Kind.CLASS) continue;
                collectedItems.add(new JsSimpleStructureItem((JsObject)child, children.isEmpty() ? null : children, "prop-", result));
                continue;
            }
            if ((child.getJSKind() == JsElement.Kind.VARIABLE || child.getJSKind() == JsElement.Kind.CONSTANT) && child.isDeclared() && (!jsObject.isAnonymous() || jsObject.isAnonymous() && jsObject.getFullyQualifiedName().indexOf(46) == -1)) {
                if (children.isEmpty()) {
                    collectedItems.add(new JsSimpleStructureItem((JsObject)child, "var-", result));
                    continue;
                }
                collectedItems.add(new JsObjectStructureItem((JsObject)child, children, result));
                continue;
            }
            if (child.getJSKind() == JsElement.Kind.CLASS && child.isDeclared()) {
                collectedItems.add(new JsClassStructureItem((JsObject)child, children, result));
                continue;
            }
            if (child.getJSKind() != JsElement.Kind.BLOCK) continue;
            collectedItems.addAll(children);
        }
        if (jsObject instanceof JsFunction) {
            JsFunction jsFunction = (JsFunction)jsObject;
            for (JsObject param : jsFunction.getParameters()) {
                if (!this.hasDeclaredProperty(param) || jsObject instanceof JsReference && !((JsReference)jsObject).getOriginal().isAnonymous()) continue;
                ArrayList<StructureItem> items = new ArrayList<StructureItem>();
                this.getEmbededItems(result, param, items, processedObjects, cancel);
                collectedItems.add(new JsObjectStructureItem(param, items, result));
            }
            if (jsFunction.getReturnTypes().size() == 1 && !jsFunction.isAnonymous()) {
                TypeUsage returnType = (TypeUsage)jsFunction.getReturnTypes().iterator().next();
                JsObject returnObject = ModelUtils.findJsObjectByName((JsObject)Model.getModel((ParserResult)result, (boolean)false).getGlobalObject(), (String)returnType.getType());
                if (returnObject != null && returnObject.getJSKind() == JsElement.Kind.ANONYMOUS_OBJECT) {
                    for (JsObject property : returnObject.getProperties().values()) {
                        ArrayList<StructureItem> items = new ArrayList<StructureItem>();
                        this.getEmbededItems(result, property, items, processedObjects, cancel);
                        collectedItems.add(new JsObjectStructureItem(property, items, result));
                    }
                }
            }
        }
        if (jsObject.getJSKind() != JsElement.Kind.BLOCK && jsObject.getDeclarationName() != null && (assignmentForOffset = jsObject.getAssignmentForOffset(jsObject.getDeclarationName().getOffsetRange().getEnd())).size() == 1 && (assignedObject = ModelUtils.findJsObjectByName((JsObject)Model.getModel((ParserResult)result, (boolean)false).getGlobalObject(), (String)((TypeUsage)assignmentForOffset.iterator().next()).getType())) != null && assignedObject.getJSKind() == JsElement.Kind.ANONYMOUS_OBJECT && processedObjects.contains(assignedObject.getParent().getFullyQualifiedName())) {
            for (JsObject property : assignedObject.getProperties().values()) {
                ArrayList<StructureItem> items = new ArrayList<StructureItem>();
                this.getEmbededItems(result, property, items, processedObjects, cancel);
                collectedItems.add(new JsObjectStructureItem(property, items, result));
            }
        }
        return collectedItems;
    }

    private boolean containsFunction(JsObject jsObject) {
        for (JsObject property : jsObject.getProperties().values()) {
            if (property.getJSKind().isFunction() && property.isDeclared() && !property.isAnonymous()) {
                return true;
            }
            if (!this.containsFunction(property)) continue;
            return true;
        }
        return false;
    }

    private boolean isNotAnonymousFunction(TokenSequence ts, int functionKeywordPosition) {
        int position = ts.offset();
        boolean value = false;
        ts.move(functionKeywordPosition);
        ts.moveNext();
        Token token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE));
        if (!(token.id() != JsTokenId.OPERATOR_ASSIGNMENT && token.id() != JsTokenId.OPERATOR_COLON || !ts.movePrevious() || (token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE))).id() != JsTokenId.IDENTIFIER && token.id() != JsTokenId.PRIVATE_IDENTIFIER)) {
            value = true;
        }
        if (!value) {
            ts.move(functionKeywordPosition);
            ts.moveNext();
            ts.moveNext();
            token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE));
            if (token.id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.PRIVATE_IDENTIFIER) {
                value = true;
            }
        }
        ts.move(position);
        ts.moveNext();
        return value;
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        HashMap<String, List<OffsetRange>> folds;
        long start = System.currentTimeMillis();
        String mimeType = info.getSnapshot().getMimeType();
        if (JsTokenId.isJSONBasedMimeType((String)mimeType)) {
            folds = this.foldsJson((org.netbeans.modules.javascript2.types.spi.ParserResult)info);
        } else {
            folds = new HashMap();
            TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
            TokenSequence<?> ts = th.tokenSequence(this.language);
            List list = th.tokenSequenceList(ts.languagePath(), 0, info.getSnapshot().getText().length());
            ArrayList<FoldingItem> stack = new ArrayList<FoldingItem>();
            TokenSequenceIterator tsi = new TokenSequenceIterator(list, false);
            while (tsi.hasMore()) {
                ts = tsi.getSequence();
                JsTokenId lastContextId = null;
                int functionKeywordPosition = 0;
                ts.moveStart();
                while (ts.moveNext()) {
                    TokenId tokenId = ts.token().id();
                    if (tokenId == JsTokenId.DOC_COMMENT) {
                        int startOffset = ts.offset() + 3;
                        int endOffset = ts.offset() + ts.token().length() - 2;
                        this.appendFold(folds, FoldType.DOCUMENTATION.code(), info.getSnapshot().getOriginalOffset(startOffset), info.getSnapshot().getOriginalOffset(endOffset));
                        continue;
                    }
                    if (tokenId == JsTokenId.BLOCK_COMMENT) {
                        int startOffset = ts.offset() + 2;
                        int endOffset = ts.offset() + ts.token().length() - 2;
                        this.appendFold(folds, FoldType.COMMENT.code(), info.getSnapshot().getOriginalOffset(startOffset), info.getSnapshot().getOriginalOffset(endOffset));
                        continue;
                    }
                    if (((JsTokenId)tokenId).isKeyword()) {
                        lastContextId = (JsTokenId)tokenId;
                        if (lastContextId != JsTokenId.KEYWORD_FUNCTION) continue;
                        functionKeywordPosition = ts.offset();
                        continue;
                    }
                    if (tokenId == JsTokenId.BRACKET_LEFT_CURLY) {
                        String kind = lastContextId == JsTokenId.KEYWORD_FUNCTION && this.isNotAnonymousFunction(ts, functionKeywordPosition) ? FoldType.MEMBER.code() : FoldType.CODE_BLOCK.code();
                        stack.add(new FoldingItem(kind, ts.offset()));
                        continue;
                    }
                    if (tokenId != JsTokenId.BRACKET_RIGHT_CURLY || stack.isEmpty()) continue;
                    FoldingItem fromStack = (FoldingItem)stack.remove(stack.size() - 1);
                    TokenId previousTokenId = null;
                    if (ts.movePrevious()) {
                        previousTokenId = ts.token().id();
                        ts.moveNext();
                    }
                    if (previousTokenId == null || previousTokenId == JsTokenId.BRACKET_LEFT_CURLY) continue;
                    this.appendFold(folds, fromStack.kind, info.getSnapshot().getOriginalOffset(fromStack.start), info.getSnapshot().getOriginalOffset(ts.offset() + 1));
                }
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Folding took %s ms", end - start);
        return folds;
    }

    private Map<String, List<OffsetRange>> foldsJson(org.netbeans.modules.javascript2.types.spi.ParserResult info) {
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        TokenSequence<?> ts = th.tokenSequence(this.language);
        List list = th.tokenSequenceList(ts.languagePath(), 0, info.getSnapshot().getText().length());
        ArrayList<FoldingItem> stack = new ArrayList<FoldingItem>();
        TokenSequenceIterator tsi = new TokenSequenceIterator(list, false);
        while (tsi.hasMore()) {
            ts = tsi.getSequence();
            ts.moveStart();
            while (ts.moveNext()) {
                FoldingItem fromStack;
                TokenId tokenId = ts.token().id();
                if (tokenId == JsTokenId.BRACKET_LEFT_CURLY) {
                    stack.add(new FoldingItem(JsonFoldTypeProvider.OBJECT.code(), ts.offset()));
                    continue;
                }
                if (tokenId == JsTokenId.BRACKET_RIGHT_CURLY && !stack.isEmpty()) {
                    fromStack = (FoldingItem)stack.remove(stack.size() - 1);
                    this.appendFold(folds, fromStack.kind, info.getSnapshot().getOriginalOffset(fromStack.start), info.getSnapshot().getOriginalOffset(ts.offset() + 1));
                    continue;
                }
                if (tokenId == JsTokenId.BRACKET_LEFT_BRACKET) {
                    stack.add(new FoldingItem(JsonFoldTypeProvider.ARRAY.code(), ts.offset()));
                    continue;
                }
                if (tokenId != JsTokenId.BRACKET_RIGHT_BRACKET || stack.isEmpty()) continue;
                fromStack = (FoldingItem)stack.remove(stack.size() - 1);
                this.appendFold(folds, fromStack.kind, info.getSnapshot().getOriginalOffset(fromStack.start), info.getSnapshot().getOriginalOffset(ts.offset() + 1));
            }
        }
        return folds;
    }

    private void appendFold(Map<String, List<OffsetRange>> folds, String kind, int startOffset, int endOffset) {
        if (startOffset >= 0 && endOffset >= startOffset) {
            this.getRanges(folds, kind).add(new OffsetRange(startOffset, endOffset));
        }
    }

    private List<OffsetRange> getRanges(Map<String, List<OffsetRange>> folds, String kind) {
        List<OffsetRange> ranges = folds.get(kind);
        if (ranges == null) {
            ranges = new ArrayList<OffsetRange>();
            folds.put(kind, ranges);
        }
        return ranges;
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(true, true);
    }

    private boolean hasDeclaredProperty(JsObject jsObject) {
        boolean result = false;
        Iterator it = jsObject.getProperties().values().iterator();
        while (!result && it.hasNext()) {
            JsObject property = (JsObject)it.next();
            result = property.isDeclared();
            if (result) continue;
            result = this.hasDeclaredProperty(property);
        }
        return result;
    }

    private class JsFunctionStructureItem
    extends JsStructureItem {
        private final List<TypeUsage> resolvedTypes;

        public JsFunctionStructureItem(JsFunction elementHandle, List<? extends StructureItem> children, org.netbeans.modules.javascript2.types.spi.ParserResult parserResult) {
            super((JsObject)elementHandle, children, "fn", parserResult);
            Collection returnTypes = this.getFunctionScope().getReturnTypes();
            this.resolvedTypes = new ArrayList<TypeUsage>(ModelUtils.resolveTypes((Collection)returnTypes, (Model)Model.getModel((ParserResult)parserResult, (boolean)false), (Index)Index.get((FileObject)parserResult.getSnapshot().getSource().getFileObject()), (boolean)false));
        }

        public final JsFunction getFunctionScope() {
            return (JsFunction)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendFunctionDescription(this.getFunctionScope(), formatter);
            return formatter.getText();
        }

        protected void appendFunctionDescription(JsFunction function, HtmlFormatter formatter) {
            formatter.reset();
            if (function == null) {
                return;
            }
            boolean isDeprecated = this.getFunctionScope().isDeprecated();
            if (isDeprecated) {
                formatter.deprecated(true);
            }
            formatter.appendText(this.getFunctionScope().getDeclarationName().getName());
            if (isDeprecated) {
                formatter.deprecated(false);
            }
            formatter.appendText("(");
            boolean addComma = false;
            for (JsObject jsObject : function.getParameters()) {
                if (addComma) {
                    formatter.appendText(", ");
                } else {
                    addComma = true;
                }
                Collection types = jsObject.getAssignmentForOffset(jsObject.getDeclarationName().getOffsetRange().getStart());
                if (!types.isEmpty()) {
                    formatter.appendHtml(JsStructureScanner.FONT_GRAY_COLOR);
                    StringBuilder typeSb = new StringBuilder();
                    for (TypeUsage type : types) {
                        if (typeSb.length() > 0) {
                            typeSb.append("|");
                        }
                        typeSb.append(type.getType());
                    }
                    if (typeSb.length() > 0) {
                        formatter.appendText(typeSb.toString());
                    }
                    formatter.appendText(" ");
                    formatter.appendHtml(JsStructureScanner.CLOSE_FONT);
                }
                formatter.appendText(jsObject.getName());
            }
            formatter.appendText(")");
            this.appendTypeInfo(formatter, this.resolvedTypes);
        }

        @Override
        public String getName() {
            return this.getFunctionScope().getDeclarationName().getName();
        }

        @Override
        public ImageIcon getCustomIcon() {
            if (this.getFunctionScope().getJSKind() == JsElement.Kind.CALLBACK) {
                if (callbackIcon == null) {
                    callbackIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/resources/methodCallback.png"));
                }
                return callbackIcon;
            }
            if (this.getFunctionScope().getJSKind() == JsElement.Kind.GENERATOR) {
                if (this.getModifiers().contains(Modifier.PUBLIC)) {
                    if (publicGenerator == null) {
                        publicGenerator = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/resources/generatorPublic.png"));
                    }
                    return publicGenerator;
                }
                if (this.getModifiers().contains(Modifier.PRIVATE)) {
                    if (privateGenerator == null) {
                        privateGenerator = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/resources/generatorPrivate.png"));
                    }
                    return privateGenerator;
                }
                if (this.getModifiers().contains(Modifier.PROTECTED)) {
                    if (priviligedGenerator == null) {
                        priviligedGenerator = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/resources/generatorPriviliged.png"));
                    }
                    return priviligedGenerator;
                }
            }
            if (this.getModifiers().contains(Modifier.PROTECTED)) {
                if (priviligedIcon == null) {
                    priviligedIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/resources/methodPriviliged.png"));
                }
                return priviligedIcon;
            }
            return super.getCustomIcon();
        }
    }

    private class JsObjectStructureItem
    extends JsStructureItem {
        public JsObjectStructureItem(JsObject elementHandle, List<? extends StructureItem> children, org.netbeans.modules.javascript2.types.spi.ParserResult parserResult) {
            super(elementHandle, children, "ob", parserResult);
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendObjectDescription(this.getModelElement(), formatter);
            return formatter.getText();
        }

        protected void appendObjectDescription(JsObject object, HtmlFormatter formatter) {
            formatter.reset();
            if (object == null) {
                return;
            }
            boolean isDeprecated = object.isDeprecated();
            if (isDeprecated) {
                formatter.deprecated(true);
            }
            formatter.appendText(object.isAnonymous() ? "{...}" : object.getName());
            if (isDeprecated) {
                formatter.deprecated(false);
            }
        }
    }

    private class JsSimpleStructureItem
    extends JsStructureItem {
        private final JsObject object;
        private final List<TypeUsage> resolvedTypes;

        public JsSimpleStructureItem(JsObject elementHandle, String sortPrefix, org.netbeans.modules.javascript2.types.spi.ParserResult parserResult) {
            this(elementHandle, null, sortPrefix, parserResult);
        }

        public JsSimpleStructureItem(JsObject elementHandle, List<? extends StructureItem> children, String sortPrefix, org.netbeans.modules.javascript2.types.spi.ParserResult parserResult) {
            super(elementHandle, children, sortPrefix, parserResult);
            this.object = elementHandle;
            Collection assignmentForOffset = this.object.getAssignments();
            this.resolvedTypes = new ArrayList<TypeUsage>(ModelUtils.resolveTypes((Collection)assignmentForOffset, (Model)Model.getModel((ParserResult)parserResult, (boolean)false), (Index)Index.get((FileObject)parserResult.getSnapshot().getSource().getFileObject()), (boolean)false));
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            boolean isDeprecated = this.object.isDeprecated();
            if (isDeprecated) {
                formatter.deprecated(true);
            }
            formatter.appendText(this.getElementHandle().getName());
            if (isDeprecated) {
                formatter.deprecated(false);
            }
            this.appendTypeInfo(formatter, this.resolvedTypes);
            return formatter.getText();
        }
    }

    private class JsClassStructureItem
    extends JsStructureItem {
        public JsClassStructureItem(JsObject elementHandle, List<? extends StructureItem> children, org.netbeans.modules.javascript2.types.spi.ParserResult parserResult) {
            super(elementHandle, children, "cl", parserResult);
        }

        public String getHtml(HtmlFormatter formatter) {
            Collection assignments;
            JsObject prototype;
            formatter.reset();
            JsObject clObject = this.getModelElement();
            boolean isDeprecated = clObject.isDeprecated();
            if (isDeprecated) {
                formatter.deprecated(true);
            }
            formatter.appendText(clObject.getDeclarationName().getName());
            if (isDeprecated) {
                formatter.deprecated(false);
            }
            if ((prototype = clObject.getProperty("prototype")) != null && (assignments = prototype.getAssignments()) != null && !assignments.isEmpty()) {
                formatter.appendHtml(JsStructureScanner.FONT_GRAY_COLOR);
                formatter.appendText(" :: ");
                boolean addComma = false;
                for (TypeUsage type : assignments) {
                    if (addComma) {
                        formatter.appendText(", ");
                    } else {
                        addComma = true;
                    }
                    formatter.appendText(type.getType());
                }
                formatter.appendHtml(JsStructureScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private static final class TokenSequenceIterator {
        private final List<TokenSequence<?>> list;
        private final boolean backward;
        private int index;

        public TokenSequenceIterator(List<TokenSequence<?>> list, boolean backward) {
            this.list = list;
            this.backward = backward;
            this.index = -1;
        }

        public boolean hasMore() {
            return this.backward ? this.hasPrevious() : this.hasNext();
        }

        public TokenSequence<?> getSequence() {
            assert (this.index >= 0 && this.index < this.list.size()) : "No sequence available, call hasMore() first.";
            return this.list.get(this.index);
        }

        private boolean hasPrevious() {
            boolean anotherSeq = false;
            if (this.index == -1) {
                this.index = this.list.size() - 1;
                anotherSeq = true;
            }
            while (this.index >= 0) {
                TokenSequence<?> seq = this.list.get(this.index);
                if (anotherSeq) {
                    seq.moveEnd();
                }
                if (seq.movePrevious()) {
                    return true;
                }
                anotherSeq = true;
                --this.index;
            }
            return false;
        }

        private boolean hasNext() {
            boolean anotherSeq = false;
            if (this.index == -1) {
                this.index = 0;
                anotherSeq = true;
            }
            while (this.index < this.list.size()) {
                TokenSequence<?> seq = this.list.get(this.index);
                if (anotherSeq) {
                    seq.moveStart();
                }
                if (seq.moveNext()) {
                    return true;
                }
                anotherSeq = true;
                ++this.index;
            }
            return false;
        }
    }

    private static class FoldingItem {
        String kind;
        int start;

        public FoldingItem(String kind, int start) {
            this.kind = kind;
            this.start = start;
        }
    }

    private abstract class JsStructureItem
    implements StructureItem {
        private JsObject modelElement;
        private final List<? extends StructureItem> children;
        private final String sortPrefix;
        protected final org.netbeans.modules.javascript2.types.spi.ParserResult parserResult;
        private final String fqn;

        public JsStructureItem(JsObject elementHandle, List<? extends StructureItem> children, String sortPrefix, org.netbeans.modules.javascript2.types.spi.ParserResult parserResult) {
            this.modelElement = elementHandle;
            this.sortPrefix = sortPrefix;
            this.parserResult = parserResult;
            this.fqn = this.modelElement.getFullyQualifiedName();
            this.children = children != null ? children : Collections.emptyList();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JsStructureItem other = (JsStructureItem)obj;
            if (this.fqn == null ? other.fqn != null : !this.fqn.equals(other.fqn)) {
                return false;
            }
            if (this.modelElement == null && other.modelElement != null || this.modelElement != null && other.modelElement == null) {
                return false;
            }
            return this.modelElement == other.modelElement || !(this.modelElement.getJSKind() == null ? other.modelElement.getJSKind() != null : !this.modelElement.getJSKind().equals((Object)other.modelElement.getJSKind()));
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + (this.fqn != null ? this.fqn.hashCode() : 0);
            hash = 37 * hash + (this.modelElement != null && this.modelElement.getJSKind() != null ? this.modelElement.getJSKind().hashCode() : 0);
            return hash;
        }

        public String getName() {
            return this.modelElement.getName();
        }

        public String getSortText() {
            return this.sortPrefix + this.modelElement.getName();
        }

        public ElementHandle getElementHandle() {
            return this.modelElement;
        }

        public ElementKind getKind() {
            return this.modelElement.getKind();
        }

        public Set<Modifier> getModifiers() {
            EnumSet<Modifier> modifiers;
            if (this.modelElement.getModifiers().isEmpty()) {
                modifiers = Collections.EMPTY_SET;
            } else {
                modifiers = EnumSet.noneOf(Modifier.class);
                modifiers.addAll(this.modelElement.getModifiers());
            }
            if (modifiers.contains(Modifier.PRIVATE) && (modifiers.contains(Modifier.PUBLIC) || modifiers.contains(Modifier.PROTECTED))) {
                modifiers.remove(Modifier.PUBLIC);
                modifiers.remove(Modifier.PROTECTED);
            }
            return modifiers;
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public long getPosition() {
            return this.parserResult.getSnapshot().getOriginalOffset(this.modelElement.getOffset());
        }

        public long getEndPosition() {
            return this.parserResult.getSnapshot().getOriginalOffset(this.modelElement.getOffsetRange().getEnd());
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        public JsObject getModelElement() {
            return this.modelElement;
        }

        protected void appendTypeInfo(HtmlFormatter formatter, Collection<? extends Type> types) {
            Collection<String> displayNames = Utils.getDisplayNames(types);
            if (!displayNames.isEmpty()) {
                formatter.appendHtml(JsStructureScanner.FONT_GRAY_COLOR);
                formatter.appendText(" : ");
                boolean addDelimiter = false;
                for (String displayName : displayNames) {
                    if (addDelimiter) {
                        formatter.appendText("|");
                    } else {
                        addDelimiter = true;
                    }
                    formatter.appendHtml(displayName);
                }
                formatter.appendHtml(JsStructureScanner.CLOSE_FONT);
            }
        }
    }
}

