/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.awt.GraphicsUtils;
import org.openide.util.Parameters;

final class DropGlassPane
extends JPanel {
    private static final HashMap<Integer, DropGlassPane> map = new HashMap();
    private static final int MIN_X = 5;
    private static final int MIN_Y = 3;
    private static final int MIN_WIDTH = 10;
    private static final int MIN_HEIGTH = 3;
    private static transient Component oldPane;
    private static transient JComponent originalSource;
    private static transient boolean wasVisible;
    private Line2D line = null;

    private DropGlassPane() {
    }

    public static synchronized DropGlassPane getDefault(JComponent comp) {
        Integer id = System.identityHashCode(comp);
        if (map.get(id) == null) {
            DropGlassPane dgp = new DropGlassPane();
            dgp.setOpaque(false);
            map.put(id, dgp);
        }
        return map.get(id);
    }

    static void setOriginalPane(JComponent source, Component pane, boolean visible) {
        if (oldPane != null) {
            throw new IllegalStateException("Original pane already present");
        }
        Parameters.notNull((CharSequence)"source", (Object)source);
        Parameters.notNull((CharSequence)"pane", (Object)pane);
        oldPane = pane;
        originalSource = source;
        wasVisible = visible;
    }

    static boolean isOriginalPaneStored() {
        return oldPane != null;
    }

    static void putBackOriginal() {
        if (oldPane == null) {
            throw new IllegalStateException("No original pane present");
        }
        JRootPane rp = originalSource.getRootPane();
        if (rp == null) {
            if (null != SwingUtilities.getWindowAncestor(originalSource)) {
                throw new IllegalStateException("originalSource " + originalSource + " has no root pane: " + rp);
            }
        } else {
            rp.setGlassPane(oldPane);
            oldPane.setVisible(wasVisible);
        }
        oldPane = null;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!aFlag) {
            this.setDropLine(null);
        }
    }

    public void setDropLine(Line2D line) {
        Line2D oldLine = this.line;
        this.line = line;
        if (null == oldLine && null != line || null != oldLine && null == line) {
            this.repaint();
        }
    }

    private Line2D checkLineBounds(Line2D line) {
        Rectangle bounds = this.getBounds();
        double startPointX = Math.max(line.getX1(), (double)(bounds.x + 5));
        double startPointY = Math.max(line.getY1(), (double)(bounds.y + 3));
        double endPointX = Math.min(line.getX2(), (double)(bounds.x + bounds.width - 10));
        double endPointY = Math.min(line.getY2(), (double)(bounds.y + bounds.height - 3));
        line.setLine(startPointX, startPointY, endPointX, endPointY);
        return line;
    }

    @Override
    public void paint(Graphics g) {
        if (this.line != null) {
            Color c = UIManager.getColor("Tree.dropLine");
            if (c != null) {
                g.setColor(c);
            }
            this.line = this.checkLineBounds(this.line);
            int x1 = (int)this.line.getX1();
            int x2 = (int)this.line.getX2();
            int y1 = (int)this.line.getY1();
            g.setColor(UIManager.getColor("Tree.selectionBackground"));
            if (g instanceof Graphics2D) {
                Path2D.Float shape = new Path2D.Float();
                ((Path2D)shape).moveTo(x1, y1 - 3);
                ((Path2D)shape).lineTo(x1 + 3, y1);
                ((Path2D)shape).lineTo(x2 - 3, y1);
                ((Path2D)shape).lineTo(x2, y1 - 3);
                ((Path2D)shape).lineTo(x2, y1 + 5);
                ((Path2D)shape).lineTo(x2 - 3, y1 + 2);
                ((Path2D)shape).lineTo(x1 + 3, y1 + 2);
                ((Path2D)shape).lineTo(x1, y1 + 5);
                shape.closePath();
                GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
                ((Graphics2D)g).fill(shape);
            } else {
                g.drawLine(x1 + 2, y1, x2 - 2, y1);
                g.drawLine(x1 + 2, y1 + 1, x2 - 2, y1 + 1);
                g.drawLine(x1, y1 - 2, x1, y1 + 3);
                g.drawLine(x1 + 1, y1 - 1, x1 + 1, y1 + 2);
                g.drawLine(x2, y1 - 2, x2, y1 + 3);
                g.drawLine(x2 - 1, y1 - 1, x2 - 1, y1 + 2);
            }
        }
    }
}

