/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.api.J2SECategoryExtensionProvider;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.openide.awt.Mnemonics;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerJar
extends JPanel
implements HelpCtx.Provider {
    private J2SEProject project;
    private List<J2SECategoryExtensionProvider> compProviders = new LinkedList<J2SECategoryExtensionProvider>();
    private final ComboBoxModel<?> sourceLevel;
    private final Map<JComponent, Collection<Supplier<Boolean>>> jLinkComponents;
    private JCheckBox compressCheckBox;
    private JCheckBox copyLibs;
    private JTextField distDirField;
    private JLabel distDirLabel;
    private JCheckBox doJarCheckBox;
    private JTextField excludeField;
    private JLabel excludeLabel;
    private JLabel excludeMessage;
    private JPanel extPanel;
    private JCheckBox jCheckBox1;
    private JCheckBox jLinkCreateLaucher;
    private JTextField jLinkLaucherName;
    private JLabel jLinkLauncherNameLabel;
    private JCheckBox jlink;
    private JCheckBox jlinkStrip;
    private JPanel mainPanel;

    public CustomizerJar(J2SEProjectProperties uiProperties) {
        this.initComponents();
        LinkedHashMap<JComponent, Collection<Object>> m = new LinkedHashMap<JComponent, Collection<Object>>();
        m.put(this.jlink, Collections.emptySet());
        m.put(this.jlinkStrip, Collections.singleton(this::isJLinkOptionsEnabled));
        m.put(this.jLinkCreateLaucher, Collections.singleton(this::isJLinkOptionsEnabled));
        m.put(this.jLinkLaucherName, Arrays.asList(this::isJLinkOptionsEnabled, this::isJLinkLauncherEnabled));
        m.put(this.jLinkLauncherNameLabel, Arrays.asList(this::isJLinkOptionsEnabled, this::isJLinkLauncherEnabled));
        this.jLinkComponents = Collections.unmodifiableMap(m);
        int nextExtensionYPos = 0;
        this.project = uiProperties.getProject();
        for (J2SECategoryExtensionProvider compProvider : this.project.getLookup().lookupAll(J2SECategoryExtensionProvider.class)) {
            if (compProvider.getCategory() != J2SECategoryExtensionProvider.ExtensibleCategory.PACKAGING || !this.addExtPanel(this.project, compProvider, nextExtensionYPos)) continue;
            this.compProviders.add(compProvider);
            ++nextExtensionYPos;
        }
        this.addPanelFiller(nextExtensionYPos);
        this.distDirField.setDocument(uiProperties.DIST_JAR_MODEL);
        this.excludeField.setDocument(uiProperties.BUILD_CLASSES_EXCLUDES_MODEL);
        uiProperties.JAR_COMPRESS_MODEL.setMnemonic(this.compressCheckBox.getMnemonic());
        this.compressCheckBox.setModel(uiProperties.JAR_COMPRESS_MODEL);
        uiProperties.DO_JAR_MODEL.setMnemonic(this.doJarCheckBox.getMnemonic());
        this.doJarCheckBox.setModel(uiProperties.DO_JAR_MODEL);
        uiProperties.COPY_LIBS_MODEL.setMnemonic(this.copyLibs.getMnemonic());
        this.copyLibs.setModel(uiProperties.COPY_LIBS_MODEL);
        this.sourceLevel = uiProperties.JAVAC_SOURCE_MODEL;
        this.sourceLevel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                CustomizerJar.this.enableJLink();
            }
        });
        uiProperties.JLINK_MODEL.setMnemonic(this.jlink.getMnemonic());
        this.jlink.setModel(new ButtonModelDecorator(uiProperties.JLINK_MODEL));
        uiProperties.JLINK_STRIP_MODEL.setMnemonic(this.jlinkStrip.getMnemonic());
        this.jlinkStrip.setModel(new ButtonModelDecorator(uiProperties.JLINK_STRIP_MODEL));
        uiProperties.JLINK_LAUNCHER_MODEL.setMnemonic(this.jLinkCreateLaucher.getMnemonic());
        this.jLinkCreateLaucher.setModel(new ButtonModelDecorator(uiProperties.JLINK_LAUNCHER_MODEL));
        this.jLinkLaucherName.setDocument(uiProperties.JLINK_LAUNCHER_NAME_MODEL);
        this.doJarCheckBox.addActionListener(e -> {
            if (!this.doJarCheckBox.isSelected()) {
                this.jlink.setSelected(false);
                this.enableJLink();
            }
        });
        this.jlink.addActionListener(e -> {
            if (this.jlink.isSelected()) {
                this.doJarCheckBox.setSelected(true);
            }
            this.enableJLink();
        });
        this.jLinkCreateLaucher.addActionListener(e -> this.enableJLink());
        this.enableJLink();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerJar.class);
    }

    private void initComponents() {
        this.jCheckBox1 = new JCheckBox();
        this.mainPanel = new JPanel();
        this.distDirLabel = new JLabel();
        this.distDirField = new JTextField();
        this.excludeLabel = new JLabel();
        this.excludeField = new JTextField();
        this.excludeMessage = new JLabel();
        this.compressCheckBox = new JCheckBox();
        this.doJarCheckBox = new JCheckBox();
        this.copyLibs = new JCheckBox();
        this.jlink = new JCheckBox();
        this.jLinkCreateLaucher = new JCheckBox();
        this.jLinkLauncherNameLabel = new JLabel();
        this.jLinkLaucherName = new JTextField();
        this.jlinkStrip = new JCheckBox();
        this.extPanel = new JPanel();
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)"jCheckBox1");
        this.setLayout(new GridBagLayout());
        this.mainPanel.setPreferredSize(new Dimension(435, 290));
        this.distDirLabel.setLabelFor(this.distDirField);
        Mnemonics.setLocalizedText((JLabel)this.distDirLabel, (String)NbBundle.getMessage(CustomizerJar.class, (String)"LBL_CustomizeJar_DistDir_JTextField"));
        this.distDirField.setEditable(false);
        this.excludeLabel.setLabelFor(this.excludeField);
        Mnemonics.setLocalizedText((JLabel)this.excludeLabel, (String)NbBundle.getMessage(CustomizerJar.class, (String)"LBL_CustomizeJar_Excludes_JTextField"));
        this.excludeMessage.setLabelFor(this.excludeField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/j2seproject/ui/customizer/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.excludeMessage, (String)bundle.getString("LBL_CustomizerJar_ExcludeMessage"));
        Mnemonics.setLocalizedText((AbstractButton)this.compressCheckBox, (String)NbBundle.getMessage(CustomizerJar.class, (String)"LBL_CustomizeJar_Commpres_JCheckBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.doJarCheckBox, (String)NbBundle.getMessage(CustomizerJar.class, (String)"CustomizerJar.doJarCheckBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.copyLibs, (String)NbBundle.getMessage(CustomizerJar.class, (String)"TXT_CopyLibraries"));
        Mnemonics.setLocalizedText((AbstractButton)this.jlink, (String)NbBundle.getMessage(CustomizerJar.class, (String)"TXT_Jar_JLink"));
        this.jlink.setActionCommand("Create J&LINK Distribution");
        Mnemonics.setLocalizedText((AbstractButton)this.jLinkCreateLaucher, (String)NbBundle.getMessage(CustomizerJar.class, (String)"TXT_Jar_JLink_CreateLaucher"));
        this.jLinkLauncherNameLabel.setLabelFor(this.jLinkLaucherName);
        Mnemonics.setLocalizedText((JLabel)this.jLinkLauncherNameLabel, (String)NbBundle.getMessage(CustomizerJar.class, (String)"TXT_Jar_JLink_LaucherName"));
        this.jLinkLaucherName.setText("jTextField1");
        Mnemonics.setLocalizedText((AbstractButton)this.jlinkStrip, (String)NbBundle.getMessage(CustomizerJar.class, (String)"TXT_Jar_JLinkStrip"));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.distDirLabel).addComponent(this.excludeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.excludeMessage).addGap(0, 112, Short.MAX_VALUE)).addComponent(this.excludeField).addComponent(this.distDirField))).addComponent(this.jlink, -2, 306, -2).addComponent(this.copyLibs).addComponent(this.compressCheckBox).addComponent(this.doJarCheckBox).addGroup(mainPanelLayout.createSequentialGroup().addGap(29, 29, 29).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jLinkLauncherNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLinkLaucherName)).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlinkStrip).addComponent(this.jLinkCreateLaucher)).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.distDirLabel).addComponent(this.distDirField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.excludeLabel).addComponent(this.excludeField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excludeMessage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.compressCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doJarCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyLibs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlink).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLinkCreateLaucher).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLinkLauncherNameLabel).addComponent(this.jLinkLaucherName, -2, -1, -2)).addGap(3, 3, 3).addComponent(this.jlinkStrip)));
        this.distDirField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerJar.class).getString("AD_jTextFieldDistDir"));
        this.excludeField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerJar.class).getString("AD_jTextFieldExcludes"));
        this.compressCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerJar.class).getString("AD_jCheckBoxCompress"));
        this.doJarCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJar.class, (String)"ACSD_BuildJarAfterCompile"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.extPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.extPanel, gridBagConstraints);
    }

    private boolean addExtPanel(Project p, J2SECategoryExtensionProvider compProvider, int gridY) {
        JComponent comp;
        if (compProvider != null && (comp = compProvider.createComponent(p, null)) != null) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = gridY;
            constraints.weightx = 1.0;
            this.extPanel.add((Component)comp, constraints);
            return true;
        }
        return false;
    }

    private void addPanelFiller(int gridY) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = gridY;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.extPanel.add((Component)new Box.Filler(new Dimension(), new Dimension(), new Dimension(10000, 10000)), constraints);
    }

    private boolean isJLinkEnabled() {
        SpecificationVersion sl = PlatformUiSupport.getSourceLevel((Object)this.sourceLevel.getSelectedItem());
        return J2SEProjectProperties.JDK9.compareTo(sl) <= 0;
    }

    private boolean isJLinkOptionsEnabled() {
        return this.jlink.isSelected();
    }

    private boolean isJLinkLauncherEnabled() {
        return this.jLinkCreateLaucher.isSelected();
    }

    private void enableJLink() {
        boolean correctSourceLevel = this.isJLinkEnabled();
        for (Map.Entry<JComponent, Collection<Supplier<Boolean>>> e : this.jLinkComponents.entrySet()) {
            JComponent c = e.getKey();
            c.setEnabled(e.getValue().stream().map(Supplier::get).reduce(correctSourceLevel, (a, b) -> a != false && b != false));
            if (!(c instanceof AbstractButton)) continue;
            ButtonModelDecorator.cast(((AbstractButton)c).getModel()).ifPresent(model -> model.setOverride(correctSourceLevel ? null : Boolean.valueOf(false)));
        }
    }

    private static final class ButtonModelDecorator
    implements ButtonModel {
        private final ButtonModel delegate;
        private final List<ActionListener> actionListeners;
        private final List<ItemListener> itemListeners;
        private final ChangeSupport changeListeners;
        private Boolean override;

        ButtonModelDecorator(@NonNull ButtonModel delegate) {
            this.delegate = delegate;
            this.actionListeners = new CopyOnWriteArrayList<ActionListener>();
            this.itemListeners = new CopyOnWriteArrayList<ItemListener>();
            this.changeListeners = new ChangeSupport((Object)this);
            this.delegate.addActionListener(e -> {
                ActionEvent ne = new ActionEvent(this, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
                for (ActionListener l : this.actionListeners) {
                    l.actionPerformed(ne);
                }
            });
            this.delegate.addItemListener(e -> {
                ItemEvent ne = new ItemEvent(this, e.getID(), e.getItem(), e.getStateChange());
                for (ItemListener l : this.itemListeners) {
                    l.itemStateChanged(ne);
                }
            });
            this.delegate.addChangeListener(e -> this.changeListeners.fireChange());
        }

        void setOverride(Boolean value) {
            this.override = value;
        }

        @NonNull
        static Optional<ButtonModelDecorator> cast(Object obj) {
            return obj instanceof ButtonModelDecorator ? Optional.of((ButtonModelDecorator)obj) : Optional.empty();
        }

        @Override
        public boolean isArmed() {
            return this.delegate.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.override != null ? this.override.booleanValue() : this.delegate.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.delegate.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.delegate.isRollover();
        }

        @Override
        public void setArmed(boolean b) {
            this.delegate.setArmed(b);
        }

        @Override
        public void setSelected(boolean b) {
            this.delegate.setSelected(b);
        }

        @Override
        public void setEnabled(boolean b) {
            this.delegate.setEnabled(b);
        }

        @Override
        public void setPressed(boolean b) {
            this.delegate.setPressed(b);
        }

        @Override
        public void setRollover(boolean b) {
            this.delegate.setRollover(b);
        }

        @Override
        public void setMnemonic(int key) {
            this.delegate.setMnemonic(key);
        }

        @Override
        public int getMnemonic() {
            return this.delegate.getMnemonic();
        }

        @Override
        public void setActionCommand(String s) {
            this.delegate.setActionCommand(s);
        }

        @Override
        public String getActionCommand() {
            return this.delegate.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup group) {
            this.delegate.setGroup(group);
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.actionListeners.add(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.actionListeners.remove(l);
        }

        @Override
        public void addItemListener(ItemListener l) {
            this.itemListeners.add(l);
        }

        @Override
        public void removeItemListener(ItemListener l) {
            this.itemListeners.remove(l);
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.changeListeners.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.changeListeners.removeChangeListener(l);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.delegate.getSelectedObjects();
        }
    }
}

