/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.persistence;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.DateFormat;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileRotate {
    private static final Logger LOG = LogManager.getLogger(FileRotate.class);
    private final Path FILE_TO_ROTATE;
    private final String FILENAME;
    private final TimeUnit ROTATION_TIME_UNIT;
    private final long ROTATION_PERIOD;
    private final DateFormat ROTATED_FILE_FORMAT;
    protected long lastRotatedMillis;
    private static final String FILE_PART_SEPARATOR = ".";

    FileRotate(Path file_to_rotate, TimeUnit rotation_time_unit, long rotation_period, DateFormat rotated_file_format) {
        this.FILE_TO_ROTATE = file_to_rotate;
        this.FILENAME = file_to_rotate.toFile().getName();
        this.ROTATION_TIME_UNIT = rotation_time_unit;
        this.ROTATION_PERIOD = rotation_period;
        this.ROTATED_FILE_FORMAT = rotated_file_format;
        this.lastRotatedMillis = System.currentTimeMillis();
    }

    synchronized Path tryRotate(long currentTimeMillis) throws IOException {
        if (this.shouldRotate(currentTimeMillis)) {
            return this.rotate(currentTimeMillis);
        }
        return null;
    }

    synchronized Path forceRotate(long currentTimeMillis) throws IOException {
        return this.rotate(currentTimeMillis);
    }

    protected boolean shouldRotate(long currentTimeMillis) {
        long timeSinceLastRotation = currentTimeMillis - this.lastRotatedMillis;
        long timeUnitsPassed = this.ROTATION_TIME_UNIT.convert(timeSinceLastRotation, TimeUnit.MILLISECONDS);
        return timeUnitsPassed >= this.ROTATION_PERIOD;
    }

    private static void tryDelete(Path file) throws IOException {
        try {
            if (!Files.deleteIfExists(file)) {
                LOG.warn("The file to delete didn't exist: {}", (Object)file);
            }
        }
        catch (IOException ioException) {
            LOG.error((Object)ioException);
            throw ioException;
        }
    }

    protected synchronized Path rotate(long currentMillis) throws IOException {
        if (!this.FILE_TO_ROTATE.toFile().exists()) {
            return null;
        }
        if (this.FILE_TO_ROTATE.getParent() == null) {
            return null;
        }
        String dir = this.FILE_TO_ROTATE.getParent().toString();
        StringBuilder targetFileName = new StringBuilder(this.FILENAME);
        targetFileName.append(FILE_PART_SEPARATOR).append(this.ROTATED_FILE_FORMAT.format(currentMillis));
        Path targetFilePath = Paths.get(dir, targetFileName.toString());
        Path ret = FileRotate.rotateFile(this.FILE_TO_ROTATE, targetFilePath);
        this.lastRotatedMillis = currentMillis;
        return ret;
    }

    public static Path rotateFile(Path fileToRotate, Path targetFilePath) throws IOException {
        Path ret;
        try {
            ret = Files.move(fileToRotate, targetFilePath, StandardCopyOption.ATOMIC_MOVE);
            LOG.info("## File rotated successfully to : {}", (Object)targetFilePath);
        }
        catch (FileAlreadyExistsException fae) {
            LOG.error("**Deleting file '{}' or else we cannot rotate the current {}", (Object)targetFilePath, (Object)fileToRotate);
            if (!Files.deleteIfExists(targetFilePath)) {
                LOG.error("Could not delete file: {}", (Object)targetFilePath);
            }
            try {
                ret = Files.move(fileToRotate, targetFilePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Exception ex) {
                LOG.error("Deleting file: {}", (Object)fileToRotate, (Object)ex);
                FileRotate.tryDelete(fileToRotate);
                ret = null;
            }
        }
        catch (IOException e) {
            LOG.error("Could not RENAME file '{}' to '{}'. Error: {}", (Object)fileToRotate, (Object)targetFilePath, (Object)e);
            FileRotate.tryDelete(fileToRotate);
            ret = null;
        }
        return ret;
    }

    public long getLastRotatedMillis() {
        return this.lastRotatedMillis;
    }
}

