/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service.grouper;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.collect.Tuple;
import org.opensearch.plugin.insights.core.service.grouper.QueryGrouper;
import org.opensearch.plugin.insights.rules.model.AggregationType;
import org.opensearch.plugin.insights.rules.model.Attribute;
import org.opensearch.plugin.insights.rules.model.GroupingType;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.plugin.insights.rules.model.healthStats.QueryGrouperHealthStats;
import org.opensearch.plugin.insights.settings.QueryInsightsSettings;

public class MinMaxHeapQueryGrouper
implements QueryGrouper {
    private static final Logger log = LogManager.getLogger(MinMaxHeapQueryGrouper.class);
    private volatile GroupingType groupingType;
    private final MetricType metricType;
    private final AggregationType aggregationType;
    private final ConcurrentHashMap<String, Tuple<SearchQueryRecord, Boolean>> groupIdToAggSearchQueryRecord;
    private final PriorityBlockingQueue<SearchQueryRecord> minHeapTopQueriesStore;
    private final PriorityBlockingQueue<SearchQueryRecord> maxHeapQueryStore;
    private int topNSize;
    private int maxGroups;

    public MinMaxHeapQueryGrouper(MetricType metricType, GroupingType groupingType, AggregationType aggregationType, PriorityBlockingQueue<SearchQueryRecord> topQueriesStore, int topNSize) {
        this.groupingType = groupingType;
        this.metricType = metricType;
        this.aggregationType = aggregationType;
        this.groupIdToAggSearchQueryRecord = new ConcurrentHashMap();
        this.minHeapTopQueriesStore = topQueriesStore;
        this.topNSize = topNSize;
        this.maxGroups = 100;
        this.maxHeapQueryStore = new PriorityBlockingQueue(this.maxGroups, (a, b) -> SearchQueryRecord.compare(b, a, metricType));
    }

    @Override
    public SearchQueryRecord add(SearchQueryRecord searchQueryRecord) {
        SearchQueryRecord aggregateSearchQueryRecord;
        if (this.groupingType == GroupingType.NONE) {
            throw new IllegalArgumentException("Do not use addQueryToGroup when GroupingType is None");
        }
        String groupId = this.getGroupingId(searchQueryRecord);
        if (groupId == null) {
            return null;
        }
        if (!this.groupIdToAggSearchQueryRecord.containsKey(groupId)) {
            if (this.checkMaxGroupsLimitReached(groupId)) {
                return null;
            }
            aggregateSearchQueryRecord = searchQueryRecord;
            aggregateSearchQueryRecord.setGroupingId(groupId);
            aggregateSearchQueryRecord.setMeasurementAggregation(this.metricType, this.aggregationType);
            aggregateSearchQueryRecord.addAttribute(Attribute.GROUP_BY, (Object)this.groupingType);
            this.addToMinPQ(aggregateSearchQueryRecord, groupId);
        } else {
            aggregateSearchQueryRecord = (SearchQueryRecord)this.groupIdToAggSearchQueryRecord.get(groupId).v1();
            boolean isPresentInMinPQ = (Boolean)this.groupIdToAggSearchQueryRecord.get(groupId).v2();
            if (isPresentInMinPQ) {
                this.minHeapTopQueriesStore.remove(aggregateSearchQueryRecord);
            } else {
                this.maxHeapQueryStore.remove(aggregateSearchQueryRecord);
            }
            this.addAndPromote(searchQueryRecord, aggregateSearchQueryRecord, groupId);
        }
        return aggregateSearchQueryRecord;
    }

    @Override
    public void drain() {
        log.debug("Number of groups for the current window is " + this.numberOfGroups());
        this.groupIdToAggSearchQueryRecord.clear();
        this.maxHeapQueryStore.clear();
        this.minHeapTopQueriesStore.clear();
    }

    @Override
    public boolean setGroupingType(GroupingType newGroupingType) {
        if (this.groupingType != newGroupingType) {
            this.groupingType = newGroupingType;
            this.drain();
            return true;
        }
        return false;
    }

    @Override
    public GroupingType getGroupingType() {
        return this.groupingType;
    }

    @Override
    public boolean setMaxGroups(int maxGroups) {
        if (this.maxGroups != maxGroups) {
            this.maxGroups = maxGroups;
            this.drain();
            return true;
        }
        return false;
    }

    @Override
    public void updateTopNSize(int newSize) {
        this.topNSize = newSize;
    }

    private void addToMinPQ(SearchQueryRecord searchQueryRecord, String groupId) {
        this.minHeapTopQueriesStore.add(searchQueryRecord);
        this.groupIdToAggSearchQueryRecord.put(groupId, (Tuple<SearchQueryRecord, Boolean>)new Tuple((Object)searchQueryRecord, (Object)true));
        this.overflow();
    }

    private void addAndPromote(SearchQueryRecord searchQueryRecord, SearchQueryRecord aggregateSearchQueryRecord, String groupId) {
        Number measurementToAdd = searchQueryRecord.getMeasurement(this.metricType);
        aggregateSearchQueryRecord.addMeasurement(this.metricType, measurementToAdd);
        this.addToMinPQ(aggregateSearchQueryRecord, groupId);
        if (this.maxHeapQueryStore.isEmpty()) {
            return;
        }
        if (SearchQueryRecord.compare(this.maxHeapQueryStore.peek(), this.minHeapTopQueriesStore.peek(), this.metricType) > 0) {
            SearchQueryRecord recordMovedFromMaxToMin = this.maxHeapQueryStore.poll();
            this.addToMinPQ(recordMovedFromMaxToMin, recordMovedFromMaxToMin.getGroupingId());
        }
    }

    private void overflow() {
        if (this.minHeapTopQueriesStore.size() > this.topNSize) {
            SearchQueryRecord recordMovedFromMinToMax = this.minHeapTopQueriesStore.poll();
            this.maxHeapQueryStore.add(recordMovedFromMinToMax);
            this.groupIdToAggSearchQueryRecord.put(recordMovedFromMinToMax.getGroupingId(), (Tuple<SearchQueryRecord, Boolean>)new Tuple((Object)recordMovedFromMinToMax, (Object)false));
        }
    }

    private boolean checkMaxGroupsLimitReached(String groupId) {
        if (this.maxGroups <= this.maxHeapQueryStore.size() && this.minHeapTopQueriesStore.size() >= this.topNSize) {
            log.warn("Exceeded [{}] setting threshold which is set at {}. Discarding new group with id {}.", (Object)QueryInsightsSettings.TOP_N_QUERIES_MAX_GROUPS_EXCLUDING_N.getKey(), (Object)this.maxGroups, (Object)groupId);
            return true;
        }
        return false;
    }

    int numberOfGroups() {
        return this.groupIdToAggSearchQueryRecord.size();
    }

    int numberOfTopGroups() {
        return this.minHeapTopQueriesStore.size();
    }

    private String getGroupingId(SearchQueryRecord searchQueryRecord) {
        try {
            switch (this.groupingType) {
                case SIMILARITY: {
                    return searchQueryRecord.getAttributes().get((Object)Attribute.QUERY_GROUP_HASHCODE).toString();
                }
                case NONE: {
                    throw new IllegalArgumentException("Should not try to group queries if grouping type is NONE");
                }
            }
            throw new IllegalArgumentException("The following grouping type is not supported : " + String.valueOf((Object)this.groupingType));
        }
        catch (Exception e) {
            log.error("Error when setting group id", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryGrouperHealthStats getHealthStats() {
        return new QueryGrouperHealthStats(this.groupIdToAggSearchQueryRecord.size(), this.maxHeapQueryStore.size());
    }
}

