/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Status;
import org.opensearch.indexmanagement.spi.indexstatemanagement.StatusChecker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0004R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/ExtensionStatusChecker;", "", "extensionCheckers", "", "", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/StatusChecker;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Ljava/util/Map;Lorg/opensearch/cluster/service/ClusterService;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "isEnabled", "", "extensionName", "opensearch-index-management"})
public final class ExtensionStatusChecker {
    @NotNull
    private final Map<String, StatusChecker> extensionCheckers;
    @NotNull
    private final ClusterService clusterService;

    public ExtensionStatusChecker(@NotNull Map<String, ? extends StatusChecker> extensionCheckers, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter(extensionCheckers, (String)"extensionCheckers");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.extensionCheckers = extensionCheckers;
        this.clusterService = clusterService;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    public final boolean isEnabled(@Nullable String extensionName) {
        StatusChecker statusChecker = this.extensionCheckers.get(extensionName);
        if (statusChecker == null) {
            return true;
        }
        StatusChecker checker = statusChecker;
        ClusterState clusterState = this.clusterService.state();
        Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterState");
        return checker.check(clusterState) == Status.ENABLED;
    }
}

