/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.stats;

import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableMap;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.indices.ModelCache;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.plugin.stats.KNNCounter;
import org.opensearch.knn.plugin.stats.KNNGraphValue;
import org.opensearch.knn.plugin.stats.KNNStat;
import org.opensearch.knn.plugin.stats.StatNames;
import org.opensearch.knn.plugin.stats.suppliers.EventOccurredWithinThresholdSupplier;
import org.opensearch.knn.plugin.stats.suppliers.KNNCircuitBreakerSupplier;
import org.opensearch.knn.plugin.stats.suppliers.KNNCounterSupplier;
import org.opensearch.knn.plugin.stats.suppliers.KNNInnerCacheStatsSupplier;
import org.opensearch.knn.plugin.stats.suppliers.LibraryInitializedSupplier;
import org.opensearch.knn.plugin.stats.suppliers.ModelIndexStatusSupplier;
import org.opensearch.knn.plugin.stats.suppliers.ModelIndexingDegradingSupplier;
import org.opensearch.knn.plugin.stats.suppliers.NativeMemoryCacheManagerSupplier;

public class KNNStats {
    private final Map<String, KNNStat<?>> knnStats = this.buildStatsMap();

    public Map<String, KNNStat<?>> getStats() {
        return this.knnStats;
    }

    public Map<String, KNNStat<?>> getNodeStats() {
        return this.getClusterOrNodeStats(false);
    }

    public Map<String, KNNStat<?>> getClusterStats() {
        return this.getClusterOrNodeStats(true);
    }

    private Map<String, KNNStat<?>> getClusterOrNodeStats(Boolean getClusterStats) {
        HashMap statsMap = new HashMap();
        for (Map.Entry<String, KNNStat<?>> entry : this.knnStats.entrySet()) {
            if (entry.getValue().isClusterLevel() != getClusterStats) continue;
            statsMap.put(entry.getKey(), entry.getValue());
        }
        return statsMap;
    }

    private Map<String, KNNStat<?>> buildStatsMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.addQueryStats(builder);
        this.addNativeMemoryStats(builder);
        this.addEngineStats(builder);
        this.addScriptStats(builder);
        this.addModelStats(builder);
        this.addGraphStats(builder);
        return builder.build();
    }

    private void addQueryStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.KNN_QUERY_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.KNN_QUERY_REQUESTS))).put((Object)StatNames.KNN_QUERY_WITH_FILTER_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.KNN_QUERY_WITH_FILTER_REQUESTS)));
        builder.put((Object)StatNames.MIN_SCORE_QUERY_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.MIN_SCORE_QUERY_REQUESTS))).put((Object)StatNames.MIN_SCORE_QUERY_WITH_FILTER_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.MIN_SCORE_QUERY_WITH_FILTER_REQUESTS)));
        builder.put((Object)StatNames.MAX_DISTANCE_QUERY_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.MAX_DISTANCE_QUERY_REQUESTS))).put((Object)StatNames.MAX_DISTANCE_QUERY_WITH_FILTER_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.MAX_DISTANCE_QUERY_WITH_FILTER_REQUESTS)));
    }

    private void addNativeMemoryStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.HIT_COUNT.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::hitCount))).put((Object)StatNames.MISS_COUNT.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::missCount))).put((Object)StatNames.LOAD_SUCCESS_COUNT.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::loadSuccessCount))).put((Object)StatNames.LOAD_EXCEPTION_COUNT.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::loadExceptionCount))).put((Object)StatNames.TOTAL_LOAD_TIME.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::totalLoadTime))).put((Object)StatNames.EVICTION_COUNT.getName(), new KNNStat<Long>(false, new KNNInnerCacheStatsSupplier(CacheStats::evictionCount))).put((Object)StatNames.GRAPH_MEMORY_USAGE.getName(), new KNNStat<Long>(false, new NativeMemoryCacheManagerSupplier<Long>(NativeMemoryCacheManager::getIndicesSizeInKilobytes))).put((Object)StatNames.GRAPH_MEMORY_USAGE_PERCENTAGE.getName(), new KNNStat<Float>(false, new NativeMemoryCacheManagerSupplier<Float>(NativeMemoryCacheManager::getIndicesSizeAsPercentage))).put((Object)StatNames.INDICES_IN_CACHE.getName(), new KNNStat<Map>(false, new NativeMemoryCacheManagerSupplier<Map>(NativeMemoryCacheManager::getIndicesCacheStats))).put((Object)StatNames.CACHE_CAPACITY_REACHED.getName(), new KNNStat<Boolean>(false, new NativeMemoryCacheManagerSupplier<Boolean>(NativeMemoryCacheManager::isCacheCapacityReached))).put((Object)StatNames.GRAPH_QUERY_ERRORS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.GRAPH_QUERY_ERRORS))).put((Object)StatNames.GRAPH_QUERY_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.GRAPH_QUERY_REQUESTS))).put((Object)StatNames.GRAPH_INDEX_ERRORS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.GRAPH_INDEX_ERRORS))).put((Object)StatNames.GRAPH_INDEX_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.GRAPH_INDEX_REQUESTS))).put((Object)StatNames.CIRCUIT_BREAKER_TRIGGERED.getName(), new KNNStat<Boolean>(true, new KNNCircuitBreakerSupplier()));
    }

    private void addEngineStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.FAISS_LOADED.getName(), new KNNStat<Boolean>(false, new LibraryInitializedSupplier(KNNEngine.FAISS))).put((Object)StatNames.NMSLIB_LOADED.getName(), new KNNStat<Boolean>(false, new LibraryInitializedSupplier(KNNEngine.NMSLIB))).put((Object)StatNames.LUCENE_LOADED.getName(), new KNNStat<Boolean>(false, new LibraryInitializedSupplier(KNNEngine.LUCENE)));
    }

    private void addScriptStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.SCRIPT_COMPILATIONS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.SCRIPT_COMPILATIONS))).put((Object)StatNames.SCRIPT_COMPILATION_ERRORS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.SCRIPT_COMPILATION_ERRORS))).put((Object)StatNames.SCRIPT_QUERY_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.SCRIPT_QUERY_REQUESTS))).put((Object)StatNames.SCRIPT_QUERY_ERRORS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.SCRIPT_QUERY_ERRORS)));
    }

    private void addModelStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.INDEXING_FROM_MODEL_DEGRADED.getName(), new KNNStat<Boolean>(false, new EventOccurredWithinThresholdSupplier(new ModelIndexingDegradingSupplier(ModelCache::getEvictedDueToSizeAt), KNNConstants.MODEL_CACHE_CAPACITY_ATROPHY_THRESHOLD_IN_MINUTES.intValue(), ChronoUnit.MINUTES))).put((Object)StatNames.MODEL_INDEX_STATUS.getName(), new KNNStat<ClusterHealthStatus>(true, new ModelIndexStatusSupplier<ClusterHealthStatus>(ModelDao::getHealthStatus))).put((Object)StatNames.TRAINING_REQUESTS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.TRAINING_REQUESTS))).put((Object)StatNames.TRAINING_ERRORS.getName(), new KNNStat<Long>(false, new KNNCounterSupplier(KNNCounter.TRAINING_ERRORS))).put((Object)StatNames.TRAINING_MEMORY_USAGE.getName(), new KNNStat<Long>(false, new NativeMemoryCacheManagerSupplier<Long>(NativeMemoryCacheManager::getTrainingSizeInKilobytes))).put((Object)StatNames.TRAINING_MEMORY_USAGE_PERCENTAGE.getName(), new KNNStat<Float>(false, new NativeMemoryCacheManagerSupplier<Float>(NativeMemoryCacheManager::getTrainingSizeAsPercentage)));
    }

    private void addGraphStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.GRAPH_STATS.getName(), new KNNStat<Map<String, Map<String, Object>>>(false, new Supplier<Map<String, Map<String, Object>>>(){

            @Override
            public Map<String, Map<String, Object>> get() {
                return KNNStats.this.createGraphStatsMap();
            }
        }));
    }

    private Map<String, Map<String, Object>> createGraphStatsMap() {
        HashMap<String, Long> mergeMap = new HashMap<String, Long>();
        mergeMap.put(KNNGraphValue.MERGE_CURRENT_OPERATIONS.getName(), KNNGraphValue.MERGE_CURRENT_OPERATIONS.getValue());
        mergeMap.put(KNNGraphValue.MERGE_CURRENT_DOCS.getName(), KNNGraphValue.MERGE_CURRENT_DOCS.getValue());
        mergeMap.put(KNNGraphValue.MERGE_CURRENT_SIZE_IN_BYTES.getName(), KNNGraphValue.MERGE_CURRENT_SIZE_IN_BYTES.getValue());
        mergeMap.put(KNNGraphValue.MERGE_TOTAL_OPERATIONS.getName(), KNNGraphValue.MERGE_TOTAL_OPERATIONS.getValue());
        mergeMap.put(KNNGraphValue.MERGE_TOTAL_TIME_IN_MILLIS.getName(), KNNGraphValue.MERGE_TOTAL_TIME_IN_MILLIS.getValue());
        mergeMap.put(KNNGraphValue.MERGE_TOTAL_DOCS.getName(), KNNGraphValue.MERGE_TOTAL_DOCS.getValue());
        mergeMap.put(KNNGraphValue.MERGE_TOTAL_SIZE_IN_BYTES.getName(), KNNGraphValue.MERGE_TOTAL_SIZE_IN_BYTES.getValue());
        HashMap<String, Long> refreshMap = new HashMap<String, Long>();
        refreshMap.put(KNNGraphValue.REFRESH_TOTAL_OPERATIONS.getName(), KNNGraphValue.REFRESH_TOTAL_OPERATIONS.getValue());
        refreshMap.put(KNNGraphValue.REFRESH_TOTAL_TIME_IN_MILLIS.getName(), KNNGraphValue.REFRESH_TOTAL_TIME_IN_MILLIS.getValue());
        HashMap<String, Map<String, Object>> graphStatsMap = new HashMap<String, Map<String, Object>>();
        graphStatsMap.put(StatNames.MERGE.getName(), mergeMap);
        graphStatsMap.put(StatNames.REFRESH.getName(), refreshMap);
        return graphStatsMap;
    }
}

