/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterManagerMetrics;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.RerouteService;
import org.opensearch.cluster.routing.RoutingNodes;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.opensearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.opensearch.cluster.routing.allocation.FailedShard;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.common.Priority;
import org.opensearch.common.UUIDs;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BatchRunnableExecutor;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.common.util.concurrent.TimeoutAwareRunnable;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.gateway.AsyncShardBatchFetch;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.PrimaryShardBatchAllocator;
import org.opensearch.gateway.ReplicaShardBatchAllocator;
import org.opensearch.gateway.ShardBatchResponseFactory;
import org.opensearch.gateway.TransportNodesGatewayStartedShardHelper;
import org.opensearch.gateway.TransportNodesListGatewayStartedShardsBatch;
import org.opensearch.index.store.Store;
import org.opensearch.indices.store.ShardAttributes;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadataBatch;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadataHelper;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.noop.NoopMetricsRegistry;

public class ShardsBatchGatewayAllocator
implements ExistingShardsAllocator {
    public static final String ALLOCATOR_NAME = "shards_batch_gateway_allocator";
    private static final Logger logger = LogManager.getLogger(ShardsBatchGatewayAllocator.class);
    private long maxBatchSize;
    private static final short DEFAULT_SHARD_BATCH_SIZE = 2000;
    public static final String PRIMARY_BATCH_ALLOCATOR_TIMEOUT_SETTING_KEY = "cluster.routing.allocation.shards_batch_gateway_allocator.primary_allocator_timeout";
    public static final String REPLICA_BATCH_ALLOCATOR_TIMEOUT_SETTING_KEY = "cluster.routing.allocation.shards_batch_gateway_allocator.replica_allocator_timeout";
    private TimeValue primaryShardsBatchGatewayAllocatorTimeout;
    private TimeValue replicaShardsBatchGatewayAllocatorTimeout;
    public static final TimeValue MIN_ALLOCATOR_TIMEOUT = TimeValue.timeValueSeconds((long)20L);
    private final ClusterManagerMetrics clusterManagerMetrics;
    public static final Setting<Long> GATEWAY_ALLOCATOR_BATCH_SIZE = Setting.longSetting("cluster.allocator.gateway.batch_size", 2000L, 1L, 10000L, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> PRIMARY_BATCH_ALLOCATOR_TIMEOUT_SETTING = Setting.timeSetting("cluster.routing.allocation.shards_batch_gateway_allocator.primary_allocator_timeout", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, new Setting.Validator<TimeValue>(){

        @Override
        public void validate(TimeValue timeValue) {
            if (timeValue.compareTo(MIN_ALLOCATOR_TIMEOUT) < 0 && timeValue.compareTo(TimeValue.MINUS_ONE) != 0) {
                throw new IllegalArgumentException("Setting [" + PRIMARY_BATCH_ALLOCATOR_TIMEOUT_SETTING.getKey() + "] should be more than 20s or -1ms to disable timeout");
            }
        }
    }, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> REPLICA_BATCH_ALLOCATOR_TIMEOUT_SETTING = Setting.timeSetting("cluster.routing.allocation.shards_batch_gateway_allocator.replica_allocator_timeout", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, new Setting.Validator<TimeValue>(){

        @Override
        public void validate(TimeValue timeValue) {
            if (timeValue.compareTo(MIN_ALLOCATOR_TIMEOUT) < 0 && timeValue.compareTo(TimeValue.MINUS_ONE) != 0) {
                throw new IllegalArgumentException("Setting [" + REPLICA_BATCH_ALLOCATOR_TIMEOUT_SETTING.getKey() + "] should be more than 20s or -1ms to disable timeout");
            }
        }
    }, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final RerouteService rerouteService;
    private final PrimaryShardBatchAllocator primaryShardBatchAllocator;
    private final ReplicaShardBatchAllocator replicaShardBatchAllocator;
    private Set<String> lastSeenEphemeralIds = Collections.emptySet();
    protected final ConcurrentMap<String, ShardsBatch> batchIdToStartedShardBatch = ConcurrentCollections.newConcurrentMap();
    protected final ConcurrentMap<String, ShardsBatch> batchIdToStoreShardBatch = ConcurrentCollections.newConcurrentMap();
    private final TransportNodesListGatewayStartedShardsBatch batchStartedAction;
    private final TransportNodesListShardStoreMetadataBatch batchStoreAction;

    @Inject
    public ShardsBatchGatewayAllocator(RerouteService rerouteService, TransportNodesListGatewayStartedShardsBatch batchStartedAction, TransportNodesListShardStoreMetadataBatch batchStoreAction, Settings settings, ClusterSettings clusterSettings, ClusterManagerMetrics clusterManagerMetrics) {
        this.rerouteService = rerouteService;
        this.primaryShardBatchAllocator = new InternalPrimaryBatchShardAllocator();
        this.replicaShardBatchAllocator = new InternalReplicaBatchShardAllocator();
        this.batchStartedAction = batchStartedAction;
        this.batchStoreAction = batchStoreAction;
        this.maxBatchSize = GATEWAY_ALLOCATOR_BATCH_SIZE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(GATEWAY_ALLOCATOR_BATCH_SIZE, this::setMaxBatchSize);
        this.primaryShardsBatchGatewayAllocatorTimeout = PRIMARY_BATCH_ALLOCATOR_TIMEOUT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(PRIMARY_BATCH_ALLOCATOR_TIMEOUT_SETTING, this::setPrimaryBatchAllocatorTimeout);
        this.replicaShardsBatchGatewayAllocatorTimeout = REPLICA_BATCH_ALLOCATOR_TIMEOUT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(REPLICA_BATCH_ALLOCATOR_TIMEOUT_SETTING, this::setReplicaBatchAllocatorTimeout);
        this.clusterManagerMetrics = clusterManagerMetrics;
    }

    @Override
    public void cleanCaches() {
        Stream.of(this.batchIdToStartedShardBatch, this.batchIdToStoreShardBatch).forEach(b -> {
            Releasables.close((Iterable)b.values().stream().map(shardsBatch -> shardsBatch.asyncBatch).collect(Collectors.toList()));
            b.clear();
        });
    }

    protected ShardsBatchGatewayAllocator() {
        this(2000L, null);
    }

    protected ShardsBatchGatewayAllocator(long batchSize, RerouteService rerouteService) {
        this.rerouteService = rerouteService;
        this.batchStartedAction = null;
        this.primaryShardBatchAllocator = null;
        this.batchStoreAction = null;
        this.replicaShardBatchAllocator = null;
        this.maxBatchSize = batchSize;
        this.primaryShardsBatchGatewayAllocatorTimeout = null;
        this.replicaShardsBatchGatewayAllocatorTimeout = null;
        this.clusterManagerMetrics = new ClusterManagerMetrics((MetricsRegistry)NoopMetricsRegistry.INSTANCE);
    }

    @Override
    public int getNumberOfInFlightFetches() {
        int count = 0;
        for (ShardsBatch batch : this.batchIdToStartedShardBatch.values()) {
            count += batch.getNumberOfInFlightFetches() * batch.getBatchedShards().size();
        }
        for (ShardsBatch batch : this.batchIdToStoreShardBatch.values()) {
            count += batch.getNumberOfInFlightFetches() * batch.getBatchedShards().size();
        }
        return count;
    }

    @Override
    public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        for (ShardRouting startedShard : startedShards) {
            this.safelyRemoveShardFromBothBatch(startedShard);
        }
    }

    @Override
    public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        for (FailedShard failedShard : failedShards) {
            this.safelyRemoveShardFromBothBatch(failedShard.getRoutingEntry());
        }
    }

    @Override
    public void beforeAllocation(RoutingAllocation allocation) {
        assert (this.primaryShardBatchAllocator != null);
        assert (this.replicaShardBatchAllocator != null);
        this.ensureAsyncFetchStorePrimaryRecency(allocation);
    }

    @Override
    public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
        assert (this.replicaShardBatchAllocator != null);
        List<List<ShardRouting>> storedShardBatches = this.batchIdToStoreShardBatch.values().stream().map(ShardsBatch::getBatchedShardRoutings).collect(Collectors.toList());
        if (allocation.routingNodes().hasInactiveShards()) {
            this.replicaShardBatchAllocator.processExistingRecoveries(allocation, storedShardBatches);
        }
    }

    @Override
    public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
        throw new UnsupportedOperationException("ShardsBatchGatewayAllocator does not support allocating unassigned shards");
    }

    @Override
    public BatchRunnableExecutor allocateAllUnassignedShards(RoutingAllocation allocation, boolean primary) {
        assert (this.primaryShardBatchAllocator != null);
        assert (this.replicaShardBatchAllocator != null);
        return this.innerAllocateUnassignedBatch(allocation, this.primaryShardBatchAllocator, this.replicaShardBatchAllocator, primary);
    }

    protected BatchRunnableExecutor innerAllocateUnassignedBatch(final RoutingAllocation allocation, final PrimaryShardBatchAllocator primaryBatchShardAllocator, final ReplicaShardBatchAllocator replicaBatchShardAllocator, boolean primary) {
        Set<String> batchesToAssign = this.createAndUpdateBatches(allocation, primary);
        if (batchesToAssign.isEmpty()) {
            return null;
        }
        ArrayList runnables = new ArrayList();
        if (primary) {
            final HashSet timedOutPrimaryShardIds = new HashSet();
            this.batchIdToStartedShardBatch.values().stream().filter(batch -> batchesToAssign.contains(batch.batchId)).forEach(shardsBatch -> runnables.add(new TimeoutAwareRunnable(){
                final /* synthetic */ ShardsBatch val$shardsBatch;
                final /* synthetic */ PrimaryShardBatchAllocator val$primaryBatchShardAllocator;
                final /* synthetic */ RoutingAllocation val$allocation;
                {
                    this.val$shardsBatch = shardsBatch;
                    this.val$primaryBatchShardAllocator = primaryShardBatchAllocator;
                    this.val$allocation = routingAllocation;
                }

                @Override
                public void onTimeout() {
                    timedOutPrimaryShardIds.addAll(this.val$shardsBatch.getBatchedShards());
                }

                @Override
                public void run() {
                    this.val$primaryBatchShardAllocator.allocateUnassignedBatch(this.val$shardsBatch.getBatchedShardRoutings(), this.val$allocation);
                }
            }));
            return new BatchRunnableExecutor(runnables, () -> this.primaryShardsBatchGatewayAllocatorTimeout){

                @Override
                public void onComplete() {
                    logger.trace("Triggering oncomplete after timeout for [{}] primary shards", (Object)timedOutPrimaryShardIds.size());
                    primaryBatchShardAllocator.allocateUnassignedBatchOnTimeout(timedOutPrimaryShardIds, allocation, true);
                    if (!timedOutPrimaryShardIds.isEmpty()) {
                        logger.trace("scheduling reroute after existing shards allocator timed out for primary shards");
                        assert (ShardsBatchGatewayAllocator.this.rerouteService != null);
                        ShardsBatchGatewayAllocator.this.rerouteService.reroute("reroute after existing shards allocator timed out", Priority.HIGH, (ActionListener<ClusterState>)ActionListener.wrap(r -> logger.trace("reroute after existing shards allocator timed out completed"), e -> logger.debug("reroute after existing shards allocator timed out failed", (Throwable)e)));
                    }
                }
            };
        }
        final HashSet timedOutReplicaShardIds = new HashSet();
        this.batchIdToStoreShardBatch.values().stream().filter(batch -> batchesToAssign.contains(batch.batchId)).forEach(batch -> runnables.add(new TimeoutAwareRunnable(){
            final /* synthetic */ ShardsBatch val$batch;
            final /* synthetic */ ReplicaShardBatchAllocator val$replicaBatchShardAllocator;
            final /* synthetic */ RoutingAllocation val$allocation;
            {
                this.val$batch = shardsBatch;
                this.val$replicaBatchShardAllocator = replicaShardBatchAllocator;
                this.val$allocation = routingAllocation;
            }

            @Override
            public void onTimeout() {
                timedOutReplicaShardIds.addAll(this.val$batch.getBatchedShards());
            }

            @Override
            public void run() {
                this.val$replicaBatchShardAllocator.allocateUnassignedBatch(this.val$batch.getBatchedShardRoutings(), this.val$allocation);
            }
        }));
        return new BatchRunnableExecutor(runnables, () -> this.replicaShardsBatchGatewayAllocatorTimeout){

            @Override
            public void onComplete() {
                logger.trace("Triggering oncomplete after timeout for [{}] replica shards", (Object)timedOutReplicaShardIds.size());
                replicaBatchShardAllocator.allocateUnassignedBatchOnTimeout(timedOutReplicaShardIds, allocation, false);
                if (!timedOutReplicaShardIds.isEmpty()) {
                    logger.trace("scheduling reroute after existing shards allocator timed out for replica shards");
                    assert (ShardsBatchGatewayAllocator.this.rerouteService != null);
                    ShardsBatchGatewayAllocator.this.rerouteService.reroute("reroute after existing shards allocator timed out", Priority.HIGH, (ActionListener<ClusterState>)ActionListener.wrap(r -> logger.trace("reroute after existing shards allocator timed out completed"), e -> logger.debug("reroute after existing shards allocator timed out failed", (Throwable)e)));
                }
            }
        };
    }

    protected Set<String> createAndUpdateBatches(RoutingAllocation allocation, boolean primary) {
        HashSet<String> batchesToBeAssigned = new HashSet<String>();
        RoutingNodes.UnassignedShards unassigned = allocation.routingNodes().unassigned();
        ConcurrentMap<String, ShardsBatch> currentBatches = primary ? this.batchIdToStartedShardBatch : this.batchIdToStoreShardBatch;
        HashMap currentBatchedShards = new HashMap();
        for (Map.Entry batchEntry : currentBatches.entrySet()) {
            ((ShardsBatch)batchEntry.getValue()).getBatchedShards().forEach(shardId -> currentBatchedShards.put(shardId, (String)batchEntry.getKey()));
        }
        HashMap newShardsToBatch = new HashMap();
        HashSet batchedShardsToAssign = Sets.newHashSet((Object[])new ShardId[0]);
        unassigned.forEach(shardRouting -> {
            if (!currentBatchedShards.containsKey(shardRouting.shardId()) && shardRouting.primary() == primary) {
                assert (shardRouting.unassigned());
                newShardsToBatch.put(shardRouting.shardId(), shardRouting);
            } else if (shardRouting.primary() == primary) {
                String batchId = (String)currentBatchedShards.get(shardRouting.shardId());
                batchesToBeAssigned.add(batchId);
                ((ShardsBatch)currentBatches.get((Object)batchId)).batchInfo.get(shardRouting.shardId()).setShardRouting((ShardRouting)shardRouting);
                batchedShardsToAssign.add(shardRouting.shardId());
            }
        });
        allocation.routingNodes().forEach(routingNode -> routingNode.getInitializingShards().forEach(shardRouting -> {
            if (currentBatchedShards.containsKey(shardRouting.shardId()) && shardRouting.primary() == primary) {
                batchedShardsToAssign.add(shardRouting.shardId());
                String batchId = (String)currentBatchedShards.get(shardRouting.shardId());
                ((ShardsBatch)currentBatches.get((Object)batchId)).batchInfo.get(shardRouting.shardId()).setShardRouting((ShardRouting)shardRouting);
            }
        }));
        this.refreshShardBatches(currentBatches, batchedShardsToAssign, primary);
        Iterator iterator = newShardsToBatch.values().iterator();
        assert (this.maxBatchSize > 0L) : "Shards batch size must be greater than 0";
        logger.debug("Using async fetch batch size {}", (Object)this.maxBatchSize);
        long batchSize = this.maxBatchSize;
        HashMap<ShardId, ShardEntry> perBatchShards = new HashMap<ShardId, ShardEntry>();
        while (iterator.hasNext()) {
            ShardRouting currentShard = (ShardRouting)iterator.next();
            ShardEntry shardEntry = new ShardEntry(new ShardAttributes(IndexMetadata.INDEX_DATA_PATH_SETTING.get(allocation.metadata().index(currentShard.index()).getSettings())), currentShard);
            perBatchShards.put(currentShard.shardId(), shardEntry);
            iterator.remove();
            if (--batchSize != 0L && iterator.hasNext()) continue;
            String batchUUId = UUIDs.base64UUID();
            ShardsBatch shardsBatch = new ShardsBatch(batchUUId, perBatchShards, primary, this.clusterManagerMetrics);
            this.addBatch(shardsBatch, primary);
            batchesToBeAssigned.add(batchUUId);
            perBatchShards.clear();
            batchSize = this.maxBatchSize;
        }
        return batchesToBeAssigned;
    }

    private void refreshShardBatches(ConcurrentMap<String, ShardsBatch> currentBatches, Set<ShardId> batchedShardsToAssign, boolean primary) {
        for (Map.Entry batchEntry : currentBatches.entrySet()) {
            Iterator<ShardId> shardIdIterator = ((ShardsBatch)batchEntry.getValue()).getBatchedShards().iterator();
            while (shardIdIterator.hasNext()) {
                ShardId shardId = shardIdIterator.next();
                if (batchedShardsToAssign.contains(shardId)) continue;
                shardIdIterator.remove();
                ((ShardsBatch)batchEntry.getValue()).clearShardFromCache(shardId);
            }
            ConcurrentMap<String, ShardsBatch> batches = primary ? this.batchIdToStartedShardBatch : this.batchIdToStoreShardBatch;
            this.deleteBatchIfEmpty(batches, ((ShardsBatch)batchEntry.getValue()).getBatchId());
        }
    }

    private void addBatch(ShardsBatch shardsBatch, boolean primary) {
        ConcurrentMap<String, ShardsBatch> batches;
        ConcurrentMap<String, ShardsBatch> concurrentMap = batches = primary ? this.batchIdToStartedShardBatch : this.batchIdToStoreShardBatch;
        if (batches.containsKey(shardsBatch.getBatchId())) {
            throw new IllegalStateException("Batch already exists. BatchId = " + shardsBatch.getBatchId());
        }
        batches.put(shardsBatch.getBatchId(), shardsBatch);
    }

    protected void safelyRemoveShardFromBatch(ShardRouting shardRouting, boolean primary) {
        String batchId;
        String string = batchId = primary ? this.getBatchId(shardRouting, true) : this.getBatchId(shardRouting, false);
        if (batchId == null) {
            logger.debug("Shard[{}] is not batched", (Object)shardRouting);
            return;
        }
        ConcurrentMap<String, ShardsBatch> batches = primary ? this.batchIdToStartedShardBatch : this.batchIdToStoreShardBatch;
        ShardsBatch batch = (ShardsBatch)batches.get(batchId);
        batch.removeFromBatch(shardRouting);
        this.deleteBatchIfEmpty(batches, batchId);
    }

    protected void safelyRemoveShardFromBothBatch(ShardRouting shardRouting) {
        this.safelyRemoveShardFromBatch(shardRouting, true);
        this.safelyRemoveShardFromBatch(shardRouting, false);
    }

    private void deleteBatchIfEmpty(ConcurrentMap<String, ShardsBatch> batches, String batchId) {
        ShardsBatch batch;
        if (batches.containsKey(batchId) && (batch = (ShardsBatch)batches.get(batchId)).getBatchedShards().isEmpty()) {
            Releasables.close(batch.getAsyncFetcher());
            batches.remove(batchId);
        }
    }

    protected String getBatchId(ShardRouting shardRouting, boolean primary) {
        ConcurrentMap<String, ShardsBatch> batches = primary ? this.batchIdToStartedShardBatch : this.batchIdToStoreShardBatch;
        return batches.entrySet().stream().filter(entry -> ((ShardsBatch)entry.getValue()).getBatchedShards().contains(shardRouting.shardId())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    @Override
    public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting unassignedShard, RoutingAllocation routingAllocation) {
        assert (unassignedShard.unassigned());
        assert (routingAllocation.debugDecision());
        if (this.getBatchId(unassignedShard, unassignedShard.primary()) == null) {
            this.createAndUpdateBatches(routingAllocation, unassignedShard.primary());
        }
        assert (this.getBatchId(unassignedShard, unassignedShard.primary()) != null);
        if (unassignedShard.primary()) {
            assert (this.primaryShardBatchAllocator != null);
            return this.primaryShardBatchAllocator.makeAllocationDecision(unassignedShard, routingAllocation, logger);
        }
        assert (this.replicaShardBatchAllocator != null);
        return this.replicaShardBatchAllocator.makeAllocationDecision(unassignedShard, routingAllocation, logger);
    }

    private void ensureAsyncFetchStorePrimaryRecency(RoutingAllocation allocation) {
        DiscoveryNodes nodes = allocation.nodes();
        if (this.hasNewNodes(nodes)) {
            Set newEphemeralIds = StreamSupport.stream(Spliterators.spliterator(nodes.getDataNodes().entrySet(), 0), false).map(node -> ((DiscoveryNode)node.getValue()).getEphemeralId()).collect(Collectors.toSet());
            logger.trace(() -> new ParameterizedMessage("new nodes {} found, clearing primary async-fetch-store cache", (Object)Sets.difference((Set)newEphemeralIds, this.lastSeenEphemeralIds)));
            this.batchIdToStoreShardBatch.values().forEach(batch -> ShardsBatchGatewayAllocator.clearCacheForBatchPrimary(batch, allocation));
            this.lastSeenEphemeralIds = newEphemeralIds;
        }
    }

    private static void clearCacheForBatchPrimary(ShardsBatch batch, RoutingAllocation allocation) {
        List<ShardRouting> primaries = batch.getBatchedShards().stream().map(allocation.routingNodes()::activePrimary).filter(Objects::nonNull).collect(Collectors.toList());
        AsyncShardBatchFetch<? extends BaseNodeResponse, ?> fetch = batch.getAsyncFetcher();
        primaries.forEach(shardRouting -> fetch.clearCacheForNode(shardRouting.currentNodeId()));
    }

    private boolean hasNewNodes(DiscoveryNodes nodes) {
        for (DiscoveryNode node : nodes.getDataNodes().values()) {
            if (this.lastSeenEphemeralIds.contains(node.getEphemeralId())) continue;
            return true;
        }
        return false;
    }

    AsyncShardFetch.FetchResult<? extends BaseNodeResponse> fetchDataAndCleanIneligibleShards(List<ShardRouting> eligibleShards, List<ShardRouting> inEligibleShards, RoutingAllocation allocation) {
        ConcurrentMap<String, ShardsBatch> batches;
        ShardRouting shardRouting = eligibleShards.iterator().hasNext() ? eligibleShards.iterator().next() : null;
        ShardRouting shardRouting2 = shardRouting = shardRouting == null && inEligibleShards.iterator().hasNext() ? inEligibleShards.iterator().next() : shardRouting;
        if (shardRouting == null) {
            return new AsyncShardFetch.FetchResult(null, Collections.emptyMap());
        }
        String batchId = this.getBatchId(shardRouting, shardRouting.primary());
        if (batchId == null) {
            logger.debug("Shard {} has no batch id", (Object)shardRouting);
            throw new IllegalStateException("Shard " + String.valueOf(shardRouting) + " has no batch id. Shard should batched before fetching");
        }
        ConcurrentMap<String, ShardsBatch> concurrentMap = batches = shardRouting.primary() ? this.batchIdToStartedShardBatch : this.batchIdToStoreShardBatch;
        if (!batches.containsKey(batchId)) {
            logger.debug("Batch {} has no shards batch", (Object)batchId);
            throw new IllegalStateException("Batch " + batchId + " has no shards batch");
        }
        ShardsBatch shardsBatch = (ShardsBatch)batches.get(batchId);
        inEligibleShards.forEach(sr -> this.safelyRemoveShardFromBatch((ShardRouting)sr, sr.primary()));
        if (shardsBatch.getBatchedShards().isEmpty() && eligibleShards.isEmpty()) {
            logger.debug("Batch {} is empty", (Object)batchId);
            return new AsyncShardFetch.FetchResult(null, Collections.emptyMap());
        }
        HashMap<ShardId, Set<String>> shardToIgnoreNodes = new HashMap<ShardId, Set<String>>();
        for (ShardId shardId : shardsBatch.asyncBatch.shardAttributesMap.keySet()) {
            shardToIgnoreNodes.put(shardId, allocation.getIgnoreNodes(shardId));
        }
        AsyncShardBatchFetch<BaseNodeResponse, ?> asyncFetcher = shardsBatch.getAsyncFetcher();
        AsyncShardFetch.FetchResult fetchResult = asyncFetcher.fetchData(allocation.nodes(), shardToIgnoreNodes);
        if (fetchResult.hasData()) {
            fetchResult.processAllocation(allocation);
        }
        return fetchResult;
    }

    public int getNumberOfStartedShardBatches() {
        return this.batchIdToStartedShardBatch.size();
    }

    public int getNumberOfStoreShardBatches() {
        return this.batchIdToStoreShardBatch.size();
    }

    private void setMaxBatchSize(long maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    protected void setPrimaryBatchAllocatorTimeout(TimeValue primaryShardsBatchGatewayAllocatorTimeout) {
        this.primaryShardsBatchGatewayAllocatorTimeout = primaryShardsBatchGatewayAllocatorTimeout;
    }

    protected void setReplicaBatchAllocatorTimeout(TimeValue replicaShardsBatchGatewayAllocatorTimeout) {
        this.replicaShardsBatchGatewayAllocatorTimeout = replicaShardsBatchGatewayAllocatorTimeout;
    }

    class InternalPrimaryBatchShardAllocator
    extends PrimaryShardBatchAllocator {
        InternalPrimaryBatchShardAllocator() {
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> fetchData(List<ShardRouting> eligibleShards, List<ShardRouting> inEligibleShards, RoutingAllocation allocation) {
            return ShardsBatchGatewayAllocator.this.fetchDataAndCleanIneligibleShards(eligibleShards, inEligibleShards, allocation);
        }
    }

    class InternalReplicaBatchShardAllocator
    extends ReplicaShardBatchAllocator {
        InternalReplicaBatchShardAllocator() {
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch> fetchData(List<ShardRouting> eligibleShards, List<ShardRouting> inEligibleShards, RoutingAllocation allocation) {
            return ShardsBatchGatewayAllocator.this.fetchDataAndCleanIneligibleShards(eligibleShards, inEligibleShards, allocation);
        }

        @Override
        protected boolean hasInitiatedFetching(ShardRouting shard) {
            ShardsBatch shardsBatch;
            String batchId = ShardsBatchGatewayAllocator.this.getBatchId(shard, shard.primary());
            if (batchId == null) {
                return false;
            }
            this.logger.trace("Checking if fetching done for batch id {}", (Object)batchId);
            ShardsBatch shardsBatch2 = shardsBatch = shard.primary() ? (ShardsBatch)ShardsBatchGatewayAllocator.this.batchIdToStartedShardBatch.get(batchId) : (ShardsBatch)ShardsBatchGatewayAllocator.this.batchIdToStoreShardBatch.get(batchId);
            if (shardsBatch == null || shardsBatch.getAsyncFetcher().hasEmptyCache()) {
                this.logger.trace("Batch cache is empty for batch {} ", (Object)batchId);
                return false;
            }
            return shardsBatch.getAsyncFetcher().getCache().findNodesToFetch().isEmpty();
        }
    }

    public class ShardsBatch {
        private final String batchId;
        private final boolean primary;
        private final InternalBatchAsyncFetch<? extends BaseNodeResponse, ?> asyncBatch;
        private final Map<ShardId, ShardEntry> batchInfo;

        public ShardsBatch(String batchId, Map<ShardId, ShardEntry> shardsWithInfo, boolean primary, ClusterManagerMetrics clusterManagerMetrics) {
            this.batchId = batchId;
            this.batchInfo = new HashMap<ShardId, ShardEntry>(shardsWithInfo);
            Map<ShardId, ShardAttributes> shardIdsMap = this.batchInfo.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ShardEntry)entry.getValue()).getShardAttributes()));
            this.primary = primary;
            this.asyncBatch = this.primary ? new InternalBatchAsyncFetch<TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch, TransportNodesGatewayStartedShardHelper.GatewayStartedShard>(logger, "batch_shards_started", shardIdsMap, ShardsBatchGatewayAllocator.this.batchStartedAction, batchId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard.class, new TransportNodesGatewayStartedShardHelper.GatewayStartedShard(null, false, null, null), TransportNodesGatewayStartedShardHelper.GatewayStartedShard::isEmpty, new ShardBatchResponseFactory(true), clusterManagerMetrics) : new InternalBatchAsyncFetch<TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadataBatch, TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadata>(logger, "batch_shards_store", shardIdsMap, ShardsBatchGatewayAllocator.this.batchStoreAction, batchId, TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadata.class, new TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadata(new TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata(null, Store.MetadataSnapshot.EMPTY, Collections.emptyList()), null), TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadata::isEmpty, new ShardBatchResponseFactory(false), clusterManagerMetrics);
        }

        protected void removeShard(ShardId shardId) {
            this.batchInfo.remove(shardId);
        }

        private TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadata buildEmptyReplicaShardResponse() {
            return new TransportNodesListShardStoreMetadataBatch.NodeStoreFilesMetadata(new TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata(null, Store.MetadataSnapshot.EMPTY, Collections.emptyList()), null);
        }

        private void removeFromBatch(ShardRouting shard) {
            this.removeShard(shard.shardId());
            this.clearShardFromCache(shard.shardId());
            assert (this.batchInfo.size() == this.asyncBatch.shardAttributesMap.size()) : "Shards size is not equal to fetcher size";
        }

        private void clearShardFromCache(ShardId shardId) {
            this.asyncBatch.clearShard(shardId);
        }

        public List<ShardRouting> getBatchedShardRoutings() {
            return this.batchInfo.values().stream().map(ShardEntry::getShardRouting).collect(Collectors.toList());
        }

        public Set<ShardId> getBatchedShards() {
            return this.batchInfo.keySet();
        }

        public String getBatchId() {
            return this.batchId;
        }

        public AsyncShardBatchFetch<? extends BaseNodeResponse, ?> getAsyncFetcher() {
            return this.asyncBatch;
        }

        public int getNumberOfInFlightFetches() {
            return this.asyncBatch.getNumberOfInFlightFetches();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ShardsBatch)) {
                return false;
            }
            ShardsBatch shardsBatch = (ShardsBatch)o;
            return this.batchId.equals(shardsBatch.getBatchId()) && this.batchInfo.keySet().equals(shardsBatch.getBatchedShards());
        }

        public int hashCode() {
            return Objects.hash(this.batchId);
        }

        public String toString() {
            return "batchId: " + this.batchId;
        }
    }

    static class ShardEntry {
        private final ShardAttributes shardAttributes;
        private ShardRouting shardRouting;

        public ShardEntry(ShardAttributes shardAttributes, ShardRouting shardRouting) {
            this.shardAttributes = shardAttributes;
            this.shardRouting = shardRouting;
        }

        public ShardRouting getShardRouting() {
            return this.shardRouting;
        }

        public ShardAttributes getShardAttributes() {
            return this.shardAttributes;
        }

        public ShardEntry setShardRouting(ShardRouting shardRouting) {
            this.shardRouting = shardRouting;
            return this;
        }
    }

    class InternalBatchAsyncFetch<T extends BaseNodeResponse, V>
    extends AsyncShardBatchFetch<T, V> {
        InternalBatchAsyncFetch(Logger logger, String type, Map<ShardId, ShardAttributes> map, AsyncShardFetch.Lister<? extends BaseNodesResponse<T>, T> action, String batchUUId, Class<V> clazz, V emptyShardResponse, Predicate<V> emptyShardResponsePredicate, ShardBatchResponseFactory<T, V> responseFactory, ClusterManagerMetrics clusterManagerMetrics) {
            super(logger, type, map, action, batchUUId, clazz, emptyShardResponse, emptyShardResponsePredicate, responseFactory, clusterManagerMetrics);
        }

        @Override
        protected void reroute(String reroutingKey, String reason) {
            this.logger.trace("{} scheduling reroute for {}", (Object)reroutingKey, (Object)reason);
            assert (ShardsBatchGatewayAllocator.this.rerouteService != null);
            ShardsBatchGatewayAllocator.this.rerouteService.reroute("async_shard_batch_fetch", Priority.HIGH, (ActionListener<ClusterState>)ActionListener.wrap(r -> this.logger.trace("{} scheduled reroute completed for {}", (Object)reroutingKey, (Object)reason), e -> this.logger.debug((Message)new ParameterizedMessage("{} scheduled reroute failed for {}", (Object)reroutingKey, (Object)reason), (Throwable)e)));
        }
    }
}

