/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.utils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.builder.SearchSourceBuilder;

public class TenantAwareHelper {
    public static boolean validateTenantId(MLFeatureEnabledSetting mlFeatureEnabledSetting, String tenantId, ActionListener<?> listener) {
        if (mlFeatureEnabledSetting.isMultiTenancyEnabled() && tenantId == null) {
            listener.onFailure((Exception)new OpenSearchStatusException("You don't have permission to access this resource", RestStatus.FORBIDDEN, new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean validateTenantResource(MLFeatureEnabledSetting mlFeatureEnabledSetting, String tenantIdFromRequest, String tenantIdFromResource, ActionListener<?> listener) {
        if (mlFeatureEnabledSetting.isMultiTenancyEnabled() && !Objects.equals(tenantIdFromRequest, tenantIdFromResource)) {
            listener.onFailure((Exception)new OpenSearchStatusException("You don't have permission to access this resource", RestStatus.FORBIDDEN, new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean isTenantFilteringEnabled(SearchRequest searchRequest) {
        QueryBuilder queryBuilder;
        SearchSourceBuilder searchSourceBuilder = searchRequest.source();
        if (searchSourceBuilder != null && (queryBuilder = searchSourceBuilder.query()) instanceof TermQueryBuilder) {
            TermQueryBuilder termQuery = (TermQueryBuilder)queryBuilder;
            return "tenant_id".equals(termQuery.fieldName());
        }
        return false;
    }

    public static String getTenantID(Boolean isMultiTenancyEnabled, RestRequest restRequest) {
        if (!isMultiTenancyEnabled.booleanValue()) {
            return null;
        }
        Map headers = restRequest.getHeaders();
        if (headers == null) {
            throw new OpenSearchStatusException("Rest request headers can't be null", RestStatus.FORBIDDEN, new Object[0]);
        }
        List tenantIdList = (List)headers.get("x-tenant-id");
        if (tenantIdList == null || tenantIdList.isEmpty()) {
            throw new OpenSearchStatusException("Tenant ID header is missing or has no value", RestStatus.FORBIDDEN, new Object[0]);
        }
        String tenantId = (String)tenantIdList.get(0);
        if (tenantId == null) {
            throw new OpenSearchStatusException("Tenant ID can't be null", RestStatus.FORBIDDEN, new Object[0]);
        }
        return tenantId;
    }
}

