/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.ConfigValidationIssue;
import org.opensearch.timeseries.rest.handler.AbstractTimeSeriesActionHandler;
import org.opensearch.timeseries.transport.ValidateConfigRequest;
import org.opensearch.timeseries.transport.ValidateConfigResponse;

public class RestValidateAction {
    private AnalysisType context;
    private Integer maxSingleStreamConfigs;
    private Integer maxHCConfigs;
    private Integer maxFeatures;
    private Integer maxCategoricalFields;
    private TimeValue requestTimeout;

    public RestValidateAction(AnalysisType context, Integer maxSingleStreamConfigs, Integer maxHCConfigs, Integer maxFeatures, Integer maxCategoricalFields, TimeValue requestTimeout) {
        this.context = context;
        this.maxSingleStreamConfigs = maxSingleStreamConfigs;
        this.maxHCConfigs = maxHCConfigs;
        this.maxFeatures = maxFeatures;
        this.maxCategoricalFields = maxCategoricalFields;
        this.requestTimeout = requestTimeout;
    }

    public void sendValidationParseResponse(ConfigValidationIssue issue, RestChannel channel) throws IOException {
        try {
            BytesRestResponse restResponse = new BytesRestResponse(RestStatus.OK, new ValidateConfigResponse(issue).toXContent(channel.newBuilder()));
            channel.sendResponse((RestResponse)restResponse);
        }
        catch (Exception e) {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
        }
    }

    private Boolean validationTypesAreAccepted(String validationType) {
        HashSet<String> typesInRequest = new HashSet<String>(Arrays.asList(validationType.split(",")));
        return !Collections.disjoint(typesInRequest, AbstractTimeSeriesActionHandler.ALL_VALIDATION_ASPECTS_STRS);
    }

    public ValidateConfigRequest prepareRequest(RestRequest request, NodeClient client, String typesStr) throws IOException {
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        if (!StringUtils.isBlank((CharSequence)typesStr) && !this.validationTypesAreAccepted(typesStr).booleanValue()) {
            throw new IllegalStateException("The given validation type doesn't exist");
        }
        Config config = null;
        if (this.context.isAD()) {
            config = AnomalyDetector.parse(parser);
        } else if (this.context.isForecast()) {
            config = Forecaster.parse(parser);
        } else {
            throw new UnsupportedOperationException("This method is not supported");
        }
        ValidateConfigRequest validateAnomalyDetectorRequest = new ValidateConfigRequest(this.context, config, typesStr, this.maxSingleStreamConfigs, this.maxHCConfigs, this.maxFeatures, this.requestTimeout, this.maxCategoricalFields);
        return validateAnomalyDetectorRequest;
    }
}

