/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.AutoCreateIndex;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.index.reindex.ReindexSslConfig;
import org.opensearch.index.reindex.ReindexValidator;
import org.opensearch.index.reindex.Reindexer;
import org.opensearch.index.reindex.spi.RemoteReindexExtension;
import org.opensearch.script.ScriptService;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportReindexAction
extends HandledTransportAction<ReindexRequest, BulkByScrollResponse> {
    static final Setting<List<String>> REMOTE_CLUSTER_WHITELIST = Setting.listSetting((String)"reindex.remote.whitelist", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<List<String>> REMOTE_CLUSTER_ALLOWLIST = Setting.listSetting((String)"reindex.remote.allowlist", REMOTE_CLUSTER_WHITELIST, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> REMOTE_REINDEX_RETRY_INITIAL_BACKOFF = Setting.timeSetting((String)"reindex.remote.retry.initial_backoff", (TimeValue)TimeValue.timeValueMillis((long)500L), (TimeValue)TimeValue.timeValueMillis((long)50L), (TimeValue)TimeValue.timeValueMillis((long)5000L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> REMOTE_REINDEX_RETRY_MAX_COUNT = Setting.intSetting((String)"reindex.remote.retry.max_count", (int)15, (int)1, (int)100, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static Optional<RemoteReindexExtension> remoteExtension = Optional.empty();
    private final ReindexValidator reindexValidator;
    private final Reindexer reindexer;
    private final ClusterService clusterService;

    @Inject
    public TransportReindexAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, ScriptService scriptService, AutoCreateIndex autoCreateIndex, Client client, TransportService transportService, ReindexSslConfig sslConfig) {
        super("indices:data/write/reindex", transportService, actionFilters, ReindexRequest::new);
        this.reindexValidator = new ReindexValidator(settings, clusterService, indexNameExpressionResolver, autoCreateIndex);
        this.reindexer = new Reindexer(clusterService, client, threadPool, scriptService, sslConfig, remoteExtension);
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, final ReindexRequest request, final ActionListener<BulkByScrollResponse> listener) {
        if (request.getRemoteInfo() != null) {
            request.setMaxRetries(((Integer)this.clusterService.getClusterSettings().get(REMOTE_REINDEX_RETRY_MAX_COUNT)).intValue());
            request.setRetryBackoffInitialTime((TimeValue)this.clusterService.getClusterSettings().get(REMOTE_REINDEX_RETRY_INITIAL_BACKOFF));
        }
        this.reindexValidator.initialValidation(request);
        final BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        this.reindexer.initTask(bulkByScrollTask, request, new ActionListener<Void>(){

            public void onResponse(Void v) {
                TransportReindexAction.this.reindexer.execute(bulkByScrollTask, request, (ActionListener<BulkByScrollResponse>)listener);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

