/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.core;

import java.security.AccessController;
import java.time.chrono.ChronoZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.parse.ParseExpression;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.type.OpenSearchTextType;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;

public class ExpressionScript {
    private final Expression expression;
    private final OpenSearchExprValueFactory valueFactory;
    private final Set<ReferenceExpression> fields;

    public ExpressionScript(Expression expression) {
        this.expression = expression;
        this.fields = AccessController.doPrivileged(() -> this.extractFields(expression));
        this.valueFactory = AccessController.doPrivileged(() -> this.buildValueFactory(this.fields));
    }

    public ExprValue execute(Supplier<Map<String, ScriptDocValues<?>>> docProvider, BiFunction<Expression, Environment<Expression, ExprValue>, ExprValue> evaluator) {
        return AccessController.doPrivileged(() -> {
            Environment<Expression, ExprValue> valueEnv = this.buildValueEnv(this.fields, this.valueFactory, docProvider);
            ExprValue result = (ExprValue)evaluator.apply(this.expression, valueEnv);
            return result;
        });
    }

    private Set<ReferenceExpression> extractFields(Expression expr) {
        HashSet<ReferenceExpression> fields = new HashSet<ReferenceExpression>();
        expr.accept((ExpressionNodeVisitor)new ExpressionNodeVisitor<Object, Set<ReferenceExpression>>(){

            public Object visitReference(ReferenceExpression node, Set<ReferenceExpression> context) {
                context.add(node);
                return null;
            }

            public Object visitParse(ParseExpression node, Set<ReferenceExpression> context) {
                node.getSourceField().accept((ExpressionNodeVisitor)this, context);
                return null;
            }
        }, fields);
        return fields;
    }

    private OpenSearchExprValueFactory buildValueFactory(Set<ReferenceExpression> fields) {
        Map<String, OpenSearchDataType> typeEnv = fields.stream().collect(Collectors.toMap(ReferenceExpression::getAttr, e -> OpenSearchDataType.of(e.type())));
        return new OpenSearchExprValueFactory(typeEnv, false);
    }

    private Environment<Expression, ExprValue> buildValueEnv(Set<ReferenceExpression> fields, OpenSearchExprValueFactory valueFactory, Supplier<Map<String, ScriptDocValues<?>>> docProvider) {
        HashMap<ReferenceExpression, ExprValue> valueEnv = new HashMap<ReferenceExpression, ExprValue>();
        for (ReferenceExpression field : fields) {
            String fieldName = field.getAttr();
            ExprValue exprValue = valueFactory.construct(fieldName, this.getDocValue(field, docProvider), false);
            valueEnv.put(field, exprValue);
        }
        return valueEnv::get;
    }

    private Object getDocValue(ReferenceExpression field, Supplier<Map<String, ScriptDocValues<?>>> docProvider) {
        String fieldName = OpenSearchTextType.convertTextToKeyword(field.getAttr(), field.type());
        ScriptDocValues<?> docValue = docProvider.get().get(fieldName);
        if (docValue == null || docValue.isEmpty()) {
            return null;
        }
        Object value = docValue.get(0);
        if (value instanceof ChronoZonedDateTime) {
            return ((ChronoZonedDateTime)value).toInstant();
        }
        return this.castNumberToFieldType(value, field.type());
    }

    private Object castNumberToFieldType(Object value, ExprType type) {
        if (value == null) {
            return value;
        }
        if (type == ExprCoreType.INTEGER) {
            return ((Long)value).intValue();
        }
        if (type == ExprCoreType.FLOAT) {
            return Float.valueOf(((Double)value).floatValue());
        }
        return value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionScript)) {
            return false;
        }
        ExpressionScript other = (ExpressionScript)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$expression = this.expression;
        Expression other$expression = other.expression;
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExpressionScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $expression = this.expression;
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }
}

