/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SdkClientDelegate;
import org.opensearch.remote.metadata.client.impl.LocalClusterIndicesClient;

public class SdkClientFactory {
    private static final Logger log = LogManager.getLogger(SdkClientFactory.class);

    public static SdkClient createSdkClient(Client client, NamedXContentRegistry xContentRegistry, Map<String, String> metadataSettings) {
        return SdkClientFactory.createSdkClient(client, xContentRegistry, metadataSettings, ForkJoinPool.commonPool());
    }

    public static SdkClient createSdkClient(Client client, NamedXContentRegistry xContentRegistry, Map<String, String> metadataSettings, Executor defaultExecutor) {
        String remoteMetadataType = metadataSettings.get("remote_metadata_type");
        Boolean multiTenancy = Boolean.parseBoolean(metadataSettings.get("tenant_aware"));
        ServiceLoader<SdkClientDelegate> loader = ServiceLoader.load(SdkClientDelegate.class);
        Iterator<SdkClientDelegate> iterator = loader.iterator();
        if (Strings.isNullOrEmpty((String)remoteMetadataType)) {
            log.info("Using local opensearch cluster as metadata store.", (Object)remoteMetadataType);
            return SdkClientFactory.createDefaultClient(client, xContentRegistry, metadataSettings, defaultExecutor, multiTenancy);
        }
        while (iterator.hasNext()) {
            SdkClientDelegate delegate = iterator.next();
            if (!delegate.supportsMetadataType(remoteMetadataType)) continue;
            log.info("Using {} as metadata store.", (Object)remoteMetadataType);
            delegate.initialize(metadataSettings);
            return new SdkClient(delegate, defaultExecutor, multiTenancy);
        }
        log.warn("Unable to find {} client implementation. Using local opensearch cluster as metadata store.", (Object)remoteMetadataType);
        return SdkClientFactory.createDefaultClient(client, xContentRegistry, metadataSettings, defaultExecutor, multiTenancy);
    }

    private static SdkClient createDefaultClient(Client client, NamedXContentRegistry xContentRegistry, Map<String, String> metadataSettings, Executor defaultExecutor, Boolean multiTenancy) {
        LocalClusterIndicesClient defaultclient = new LocalClusterIndicesClient(client, xContentRegistry, metadataSettings);
        return new SdkClient(defaultclient, defaultExecutor, multiTenancy);
    }

    static SdkClient wrapSdkClientDelegate(SdkClientDelegate delegate, Boolean multiTenancy) {
        return new SdkClient(delegate, multiTenancy);
    }
}

