/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.spi;

import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.alerting.spi.RemoteMonitorRunner;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.commons.alerting.action.DocLevelMonitorFanOutRequest;
import org.opensearch.commons.alerting.action.DocLevelMonitorFanOutResponse;
import org.opensearch.commons.alerting.model.IndexExecutionContext;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.MonitorMetadata;
import org.opensearch.commons.alerting.model.MonitorRunResult;
import org.opensearch.commons.alerting.model.TriggerRunResult;
import org.opensearch.commons.alerting.model.WorkflowRunContext;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.node.NodeClosedException;
import org.opensearch.transport.ActionNotFoundTransportException;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u008d\u0001\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00180\u00172\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0017H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\rH\u0016J>\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lorg/opensearch/alerting/spi/RemoteMonitorRunner;", "", "()V", "doFanOut", "", "Lorg/opensearch/commons/alerting/action/DocLevelMonitorFanOutResponse;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "monitorMetadata", "Lorg/opensearch/commons/alerting/model/MonitorMetadata;", "executionId", "", "concreteIndices", "", "workflowRunContext", "Lorg/opensearch/commons/alerting/model/WorkflowRunContext;", "dryrun", "", "transportService", "Lorg/opensearch/transport/TransportService;", "nodeMap", "", "Lorg/opensearch/cluster/node/DiscoveryNode;", "nodeShardAssignments", "", "Lorg/opensearch/core/index/shard/ShardId;", "(Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/commons/alerting/model/Monitor;Lorg/opensearch/commons/alerting/model/MonitorMetadata;Ljava/lang/String;Ljava/util/List;Lorg/opensearch/commons/alerting/model/WorkflowRunContext;ZLorg/opensearch/transport/TransportService;Ljava/util/Map;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFanOutAction", "runMonitor", "Lorg/opensearch/commons/alerting/model/MonitorRunResult;", "Lorg/opensearch/commons/alerting/model/TriggerRunResult;", "periodStart", "Ljava/time/Instant;", "periodEnd", "alerting-spi"})
public class RemoteMonitorRunner {
    @NotNull
    public MonitorRunResult<TriggerRunResult> runMonitor(@NotNull Monitor monitor, @NotNull Instant periodStart, @NotNull Instant periodEnd, boolean dryrun, @NotNull String executionId, @NotNull TransportService transportService) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)periodStart, (String)"periodStart");
        Intrinsics.checkNotNullParameter((Object)periodEnd, (String)"periodEnd");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        return new MonitorRunResult(monitor.getName(), periodStart, periodEnd, null, null, null, 56, null);
    }

    @NotNull
    public String getFanOutAction() {
        throw new UnsupportedOperationException("Fan out action needs to be implemented by remote monitor.");
    }

    @Nullable
    public Object doFanOut(@NotNull ClusterService clusterService, @NotNull Monitor monitor, @NotNull MonitorMetadata monitorMetadata, @NotNull String executionId, @NotNull List<String> concreteIndices, @Nullable WorkflowRunContext workflowRunContext, boolean dryrun, @NotNull TransportService transportService, @NotNull Map<String, ? extends DiscoveryNode> nodeMap, @NotNull Map<String, ? extends Set<ShardId>> nodeShardAssignments, @NotNull Continuation<? super List<DocLevelMonitorFanOutResponse>> $completion) {
        return RemoteMonitorRunner.doFanOut$suspendImpl(this, clusterService, monitor, monitorMetadata, executionId, concreteIndices, workflowRunContext, dryrun, transportService, nodeMap, nodeShardAssignments, $completion);
    }

    static /* synthetic */ Object doFanOut$suspendImpl(RemoteMonitorRunner $this, ClusterService clusterService, Monitor monitor, MonitorMetadata monitorMetadata, String executionId, List<String> concreteIndices, WorkflowRunContext workflowRunContext, boolean dryrun, TransportService transportService, Map<String, ? extends DiscoveryNode> nodeMap, Map<String, ? extends Set<ShardId>> nodeShardAssignments, Continuation<? super List<DocLevelMonitorFanOutResponse>> $completion) {
        Continuation<? super List<DocLevelMonitorFanOutResponse>> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl = false;
        GroupedActionListener listener2 = new GroupedActionListener((ActionListener)new ActionListener<Collection<? extends DocLevelMonitorFanOutResponse>>((Continuation<? super List<DocLevelMonitorFanOutResponse>>)cont){
            final /* synthetic */ Continuation<List<DocLevelMonitorFanOutResponse>> $cont;
            {
                this.$cont = $cont;
            }

            public void onResponse(@NotNull Collection<DocLevelMonitorFanOutResponse> response) {
                Intrinsics.checkNotNullParameter(response, (String)"response");
                this.$cont.resumeWith(Result.constructor-impl((Object)CollectionsKt.toMutableList(response)));
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getCause() instanceof Exception) {
                    Continuation<List<DocLevelMonitorFanOutResponse>> continuation = this.$cont;
                    Throwable throwable = e.getCause();
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    Throwable throwable2 = (Exception)throwable;
                    continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2)));
                } else {
                    this.$cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
                }
            }
        }, nodeShardAssignments.size());
        Writeable.Reader responseReader2 = doFanOut.2.responseReader.1.INSTANCE;
        for (Map.Entry<String, ? extends DiscoveryNode> node : nodeMap.entrySet()) {
            if (!nodeShardAssignments.containsKey(node.getKey())) continue;
            IndexExecutionContext indexExecutionContext = new IndexExecutionContext(CollectionsKt.emptyList(), (Map)new LinkedHashMap(), (Map)new LinkedHashMap(), "", "", CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, null, 768, null);
            Set<ShardId> set = nodeShardAssignments.get(node.getKey());
            Intrinsics.checkNotNull(set);
            DocLevelMonitorFanOutRequest docLevelMonitorFanOutRequest = new DocLevelMonitorFanOutRequest(monitor, dryrun, monitorMetadata, executionId, indexExecutionContext, CollectionsKt.toList((Iterable)set), concreteIndices, workflowRunContext);
            transportService.sendRequest(node.getValue(), $this.getFanOutAction(), (TransportRequest)docLevelMonitorFanOutRequest, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler<DocLevelMonitorFanOutResponse>((GroupedActionListener<DocLevelMonitorFanOutResponse>)listener2, (Writeable.Reader<DocLevelMonitorFanOutResponse>)responseReader2, clusterService, transportService, docLevelMonitorFanOutRequest){
                final /* synthetic */ GroupedActionListener<DocLevelMonitorFanOutResponse> $listener;
                final /* synthetic */ Writeable.Reader<DocLevelMonitorFanOutResponse> $responseReader;
                final /* synthetic */ ClusterService $clusterService;
                final /* synthetic */ TransportService $transportService;
                final /* synthetic */ DocLevelMonitorFanOutRequest $docLevelMonitorFanOutRequest;
                {
                    this.$listener = $listener;
                    this.$responseReader = $responseReader;
                    this.$clusterService = $clusterService;
                    this.$transportService = $transportService;
                    this.$docLevelMonitorFanOutRequest = $docLevelMonitorFanOutRequest;
                    super((ActionListener)$listener, $responseReader);
                }

                public void handleException(@NotNull TransportException e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Throwable cause = e.unwrapCause();
                    if (cause instanceof ConnectTransportException || e instanceof RemoteTransportException && (cause instanceof NodeClosedException || cause instanceof CircuitBreakingException || cause instanceof ActionNotFoundTransportException)) {
                        DiscoveryNode localNode = this.$clusterService.localNode();
                        this.$transportService.sendRequest(localNode, "cluster:admin/opensearch/alerting/monitor/doclevel/fanout", (TransportRequest)this.$docLevelMonitorFanOutRequest, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler<DocLevelMonitorFanOutResponse>(this.$listener, this.$responseReader){
                            final /* synthetic */ GroupedActionListener<DocLevelMonitorFanOutResponse> $listener;
                            {
                                this.$listener = $listener;
                                super((ActionListener)$listener, $responseReader);
                            }

                            public void handleException(@NotNull TransportException e) {
                                AlertingException alertingException;
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                Map map = new LinkedHashMap<K, V>();
                                if (e.getCause() instanceof AlertingException) {
                                    Throwable throwable = e.getCause();
                                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.util.AlertingException");
                                    alertingException = (AlertingException)throwable;
                                } else {
                                    OpenSearchException openSearchException = AlertingException.Companion.wrap((Exception)e);
                                    Intrinsics.checkNotNull((Object)openSearchException, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.util.AlertingException");
                                    alertingException = (AlertingException)openSearchException;
                                }
                                this.$listener.onResponse((Object)new DocLevelMonitorFanOutResponse("", "", "", map, null, null, alertingException, 48, null));
                            }

                            public void handleResponse(@NotNull DocLevelMonitorFanOutResponse response) {
                                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                                this.$listener.onResponse((Object)response);
                            }
                        });
                    } else {
                        AlertingException alertingException;
                        Map map = new LinkedHashMap<K, V>();
                        if (e.getCause() instanceof AlertingException) {
                            Throwable throwable = e.getCause();
                            Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.util.AlertingException");
                            alertingException = (AlertingException)throwable;
                        } else {
                            OpenSearchException openSearchException = AlertingException.Companion.wrap((Exception)e);
                            Intrinsics.checkNotNull((Object)openSearchException, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.util.AlertingException");
                            alertingException = (AlertingException)openSearchException;
                        }
                        this.$listener.onResponse((Object)new DocLevelMonitorFanOutResponse("", "", "", map, null, null, alertingException, 48, null));
                    }
                }

                public void handleResponse(@NotNull DocLevelMonitorFanOutResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.$listener.onResponse((Object)response);
                }
            });
        }
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }
}

