/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.PredictorCorrector;
import com.amazon.randomcutforest.parkservices.config.ScoringStrategy;
import com.amazon.randomcutforest.parkservices.returntypes.RCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import com.amazon.randomcutforest.preprocessor.IPreprocessor;
import com.amazon.randomcutforest.preprocessor.Preprocessor;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.RangeVector;
import com.amazon.randomcutforest.returntypes.TimedRangeVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import lombok.Generated;

public class ThresholdedRandomCutForest {
    RCFComputeDescriptor lastAnomalyDescriptor;
    protected ForestMode forestMode = ForestMode.STANDARD;
    protected TransformMethod transformMethod = TransformMethod.NONE;
    protected ScoringStrategy scoringStrategy = ScoringStrategy.EXPECTED_INVERSE_DEPTH;
    protected RandomCutForest forest;
    protected PredictorCorrector predictorCorrector;
    protected IPreprocessor preprocessor;

    public ThresholdedRandomCutForest(Builder<?> builder) {
        this.forestMode = builder.forestMode;
        this.transformMethod = builder.transformMethod;
        this.scoringStrategy = builder.scoringStrategy;
        Preprocessor.Builder preprocessorBuilder = Preprocessor.builder().shingleSize(builder.shingleSize).transformMethod(builder.transformMethod).forestMode(builder.forestMode);
        if (builder.forestMode == ForestMode.TIME_AUGMENTED) {
            int inputLength = builder.dimensions / builder.shingleSize;
            preprocessorBuilder.inputLength(inputLength);
            builder.dimensions += builder.shingleSize;
            preprocessorBuilder.normalizeTime(builder.normalizeTime);
            builder.internalShinglingEnabled = Optional.of(true);
        } else if (builder.forestMode == ForestMode.STREAMING_IMPUTE) {
            int inputLength = builder.dimensions / builder.shingleSize;
            preprocessorBuilder.inputLength(inputLength);
            preprocessorBuilder.imputationMethod(builder.imputationMethod);
            preprocessorBuilder.normalizeTime(true);
            if (builder.fillValues != null) {
                preprocessorBuilder.fillValues(builder.fillValues);
            }
            builder.internalShinglingEnabled = Optional.of(true);
            preprocessorBuilder.useImputedFraction(builder.useImputedFraction.orElse(0.5).doubleValue());
        } else {
            boolean smallInput = builder.internalShinglingEnabled.orElse(false);
            int inputLength = smallInput ? builder.dimensions / builder.shingleSize : builder.dimensions;
            preprocessorBuilder.inputLength(inputLength);
        }
        this.forest = builder.buildForest();
        this.validateNonNegativeArray(builder.weights);
        preprocessorBuilder.weights(builder.weights);
        preprocessorBuilder.weightTime(builder.weightTime.orElse(1.0).doubleValue());
        preprocessorBuilder.transformDecay(builder.transformDecay.orElse(1.0 / (double)builder.sampleSize).doubleValue());
        preprocessorBuilder.randomSeed(builder.randomSeed.orElse(0L) + 1L);
        preprocessorBuilder.dimensions(builder.dimensions);
        preprocessorBuilder.stopNormalization(builder.stopNormalization.orElse(Preprocessor.DEFAULT_STOP_NORMALIZATION));
        preprocessorBuilder.startNormalization(builder.startNormalization.orElse(Preprocessor.DEFAULT_START_NORMALIZATION).intValue());
        this.preprocessor = preprocessorBuilder.build();
        this.predictorCorrector = new PredictorCorrector(this.forest.getTimeDecay(), builder.anomalyRate, builder.autoAdjust, builder.dimensions / builder.shingleSize, builder.randomSeed.orElse(0L));
        this.lastAnomalyDescriptor = new RCFComputeDescriptor(null, 0L, builder.forestMode, builder.transformMethod, builder.imputationMethod);
        this.predictorCorrector.setAbsoluteThreshold(builder.lowerThreshold.orElse(BasicThresholder.DEFAULT_ABSOLUTE_THRESHOLD));
        this.predictorCorrector.setZfactor(builder.zFactor);
        this.predictorCorrector.setScoreDifferencing(builder.scoreDifferencing.orElse(BasicThresholder.DEFAULT_SCORE_DIFFERENCING));
        builder.ignoreNearExpectedFromAbove.ifPresent(this.predictorCorrector::setIgnoreNearExpectedFromAbove);
        builder.ignoreNearExpectedFromBelow.ifPresent(this.predictorCorrector::setIgnoreNearExpectedFromBelow);
        builder.ignoreNearExpectedFromAboveByRatio.ifPresent(this.predictorCorrector::setIgnoreNearExpectedFromAboveByRatio);
        builder.ignoreNearExpectedFromBelowByRatio.ifPresent(this.predictorCorrector::setIgnoreNearExpectedFromBelowByRatio);
        this.predictorCorrector.setLastStrategy(builder.scoringStrategy);
        this.predictorCorrector.setIgnoreDrift(builder.alertOnceInDrift);
    }

    void validateNonNegativeArray(double[] array) {
        if (array != null) {
            for (double element : array) {
                CommonUtils.checkArgument((element >= 0.0 ? 1 : 0) != 0, (String)" has to be non-negative");
            }
        }
    }

    public ThresholdedRandomCutForest(ForestMode forestMode, TransformMethod transformMethod, ScoringStrategy scoringStrategy, RandomCutForest forest, PredictorCorrector predictorCorrector, Preprocessor preprocessor, RCFComputeDescriptor descriptor) {
        this.forestMode = forestMode;
        this.transformMethod = transformMethod;
        this.scoringStrategy = scoringStrategy;
        this.forest = forest;
        this.predictorCorrector = predictorCorrector;
        this.preprocessor = preprocessor;
        this.lastAnomalyDescriptor = descriptor;
    }

    public ThresholdedRandomCutForest(RandomCutForest forest, double futureAnomalyRate, List<Double> values, double[] lastShingledInput) {
        this.forest = forest;
        int dimensions = forest.getDimensions();
        int inputLength = dimensions / forest.getShingleSize();
        Preprocessor preprocessor = new Preprocessor.Builder().transformMethod(TransformMethod.NONE).dimensions(dimensions).shingleSize(forest.getShingleSize()).inputLength(inputLength).initialShingledInput(lastShingledInput).initialPoint(CommonUtils.toFloatArray((double[])lastShingledInput)).imputationMethod(ImputationMethod.RCF).startNormalization(0).build();
        this.predictorCorrector = new PredictorCorrector(new BasicThresholder(values, futureAnomalyRate), inputLength);
        preprocessor.setValuesSeen((int)forest.getTotalUpdates());
        preprocessor.getDataQuality()[0].update(1.0);
        this.preprocessor = preprocessor;
        this.lastAnomalyDescriptor = new RCFComputeDescriptor(null, forest.getTotalUpdates());
    }

    protected <T extends AnomalyDescriptor> boolean saveDescriptor(T lastDescriptor) {
        return lastDescriptor.getAnomalyGrade() > 0.0;
    }

    protected <P extends AnomalyDescriptor> void augment(P description) {
        description.setScoringStrategy(this.scoringStrategy);
        this.initialSetup(description, this.lastAnomalyDescriptor, this.forest);
        this.predictorCorrector.detect(description, this.lastAnomalyDescriptor, this.forest);
        this.postProcess(description);
        if (this.saveDescriptor(description)) {
            this.lastAnomalyDescriptor = description.copyOf();
        }
    }

    public AnomalyDescriptor process(double[] inputPoint, long timestamp) {
        return this.process(inputPoint, timestamp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnomalyDescriptor process(double[] inputPoint, long timestamp, int[] missingValues) {
        AnomalyDescriptor description = new AnomalyDescriptor(inputPoint, timestamp);
        description.setScoringStrategy(this.scoringStrategy);
        boolean cacheDisabled = this.forest.getBoundingBoxCacheFraction() == 0.0;
        try {
            if (cacheDisabled) {
                this.forest.setBoundingBoxCacheFraction(1.0);
            }
            if (missingValues != null) {
                CommonUtils.checkArgument((missingValues.length <= inputPoint.length ? 1 : 0) != 0, (String)" incorrect data");
                for (int i = 0; i < missingValues.length; ++i) {
                    CommonUtils.checkArgument((missingValues[i] >= 0 ? 1 : 0) != 0, (String)" missing values cannot be at negative position");
                    CommonUtils.checkArgument((missingValues[i] < inputPoint.length ? 1 : 0) != 0, (String)"missing values cannot be at position larger than input length");
                }
                description.setMissingValues(missingValues);
            }
            this.augment(description);
        }
        finally {
            if (cacheDisabled) {
                this.forest.setBoundingBoxCacheFraction(0.0);
            }
        }
        if (this.saveDescriptor(description)) {
            this.lastAnomalyDescriptor = description.copyOf();
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnomalyDescriptor> processSequentially(double[][] data, Function<AnomalyDescriptor, Boolean> filter) {
        ArrayList<AnomalyDescriptor> answer = new ArrayList<AnomalyDescriptor>();
        if (data != null && data.length > 0) {
            boolean cacheDisabled = this.forest.getBoundingBoxCacheFraction() == 0.0;
            try {
                if (cacheDisabled) {
                    this.forest.setBoundingBoxCacheFraction(1.0);
                }
                long timestamp = this.preprocessor.getInternalTimeStamp();
                int length = this.preprocessor.getInputLength();
                for (double[] point : data) {
                    CommonUtils.checkArgument((point.length == length ? 1 : 0) != 0, (String)" nonuniform lengths ");
                    AnomalyDescriptor description = new AnomalyDescriptor(point, timestamp++);
                    this.augment(description);
                    if (this.saveDescriptor(description)) {
                        this.lastAnomalyDescriptor = description.copyOf();
                    }
                    if (!filter.apply(description).booleanValue()) continue;
                    answer.add(description);
                }
            }
            finally {
                if (cacheDisabled) {
                    this.forest.setBoundingBoxCacheFraction(0.0);
                }
            }
        }
        return answer;
    }

    public List<AnomalyDescriptor> processSequentially(double[][] data) {
        return this.processSequentially(data, x -> x.getAnomalyGrade() > 0.0);
    }

    public TimedRangeVector extrapolate(int horizon, boolean correct, double centrality) {
        int shingleSize = this.preprocessor.getShingleSize();
        CommonUtils.checkArgument((shingleSize > 1 ? 1 : 0) != 0, (String)"extrapolation is not meaningful for shingle size = 1");
        int dimensions = this.forest.getDimensions();
        int blockSize = dimensions / shingleSize;
        float[] lastPoint = this.preprocessor.getLastShingledPoint();
        if (this.forest.isOutputReady()) {
            int gap = (int)((long)this.preprocessor.getInternalTimeStamp() - this.lastAnomalyDescriptor.getInternalTimeStamp());
            float[] newPoint = lastPoint;
            if (gap <= shingleSize && correct && this.lastAnomalyDescriptor.getExpectedRCFPoint() != null) {
                newPoint = gap == 1 ? this.lastAnomalyDescriptor.getExpectedRCFPoint() : this.predictorCorrector.applyPastCorrector(newPoint, gap, shingleSize, blockSize, this.preprocessor.getScale(), this.transformMethod, this.lastAnomalyDescriptor);
            }
            RangeVector answer = this.forest.extrapolateWithRanges(newPoint, horizon, blockSize, false, 0, centrality);
            return this.preprocessor.invertForecastRange(answer, this.lastAnomalyDescriptor.getInputTimestamp(), this.lastAnomalyDescriptor.getDeltaShift(), this.lastAnomalyDescriptor.getExpectedRCFPoint() != null, this.lastAnomalyDescriptor.getExpectedTimeStamp());
        }
        return new TimedRangeVector(new TimedRangeVector(horizon * blockSize, horizon));
    }

    public TimedRangeVector extrapolate(int horizon) {
        return this.extrapolate(horizon, true, 1.0);
    }

    public RandomCutForest getForest() {
        return this.forest;
    }

    public void setZfactor(double factor) {
        this.predictorCorrector.setZfactor(factor);
    }

    public void setLowerThreshold(double lower) {
        this.predictorCorrector.setAbsoluteThreshold(lower);
    }

    @Deprecated
    public void setHorizon(double horizon) {
        this.predictorCorrector.setScoreDifferencing(1.0 - horizon);
    }

    public void setScoreDifferencing(double scoreDifferencing) {
        this.predictorCorrector.setScoreDifferencing(scoreDifferencing);
    }

    public void setIgnoreNearExpectedFromAbove(double[] ignoreSimilarFromAbove) {
        this.predictorCorrector.setIgnoreNearExpectedFromAbove(ignoreSimilarFromAbove);
    }

    public void setIgnoreNearExpectedFromAboveByRatio(double[] ignoreSimilarFromAbove) {
        this.predictorCorrector.setIgnoreNearExpectedFromAboveByRatio(ignoreSimilarFromAbove);
    }

    public void setIgnoreNearExpectedFromBelow(double[] ignoreSimilarFromBelow) {
        this.predictorCorrector.setIgnoreNearExpectedFromBelow(ignoreSimilarFromBelow);
    }

    public void setIgnoreNearExpectedFromBelowByRatio(double[] ignoreSimilarFromBelow) {
        this.predictorCorrector.setIgnoreNearExpectedFromBelowByRatio(ignoreSimilarFromBelow);
    }

    public void setScoringStrategy(ScoringStrategy strategy) {
        this.scoringStrategy = strategy;
    }

    @Deprecated
    public void setInitialThreshold(double initial) {
        this.predictorCorrector.setInitialThreshold(initial);
    }

    <P extends AnomalyDescriptor> P initialSetup(P description, RCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        description.setForestMode(this.forestMode);
        description.setTransformMethod(this.transformMethod);
        description.setImputationMethod(this.preprocessor.getImputationMethod());
        description.setNumberOfTrees(forest.getNumberOfTrees());
        description.setTotalUpdates(forest.getTotalUpdates());
        description.setLastAnomalyInternalTimestamp(lastAnomalyDescriptor.getInternalTimeStamp());
        description.setLastExpectedRCFPoint(lastAnomalyDescriptor.getExpectedRCFPoint());
        description.setDataConfidence(forest.getTimeDecay(), this.preprocessor.getValuesSeen(), forest.getOutputAfter(), this.preprocessor.dataQuality());
        description.setShingleSize(this.preprocessor.getShingleSize());
        description.setInputLength(this.preprocessor.getInputLength());
        description.setDimension(forest.getDimensions());
        description.setReasonableForecast(forest.isOutputReady() && forest.getDimensions() >= 4);
        description.setScale(this.preprocessor.getScale());
        description.setShift(this.preprocessor.getShift());
        description.setDeviations(this.preprocessor.getSmoothedDeviations());
        description.setNumberOfNewImputes(this.preprocessor.numberOfImputes(description.getInputTimestamp()));
        description.setInternalTimeStamp(this.preprocessor.getInternalTimeStamp() + description.getNumberOfNewImputes());
        description.setRCFPoint(this.preprocessor.getScaledShingledInput(description.getCurrentInput(), description.getInputTimestamp(), description.getMissingValues(), forest));
        return description;
    }

    <P extends AnomalyDescriptor> void postProcess(P result) {
        float[] point = result.getRCFPoint();
        if (point != null && result.getAnomalyGrade() > 0.0) {
            int shingleSize = result.getShingleSize();
            int dimension = result.getDimension();
            int base = dimension / shingleSize;
            double[] reference = result.getCurrentInput();
            float[] newPoint = result.getExpectedRCFPoint();
            int index = result.getRelativeIndex();
            if (index < 0) {
                reference = this.preprocessor.getShingledInput(shingleSize + index);
                result.setPastTimeStamp(this.preprocessor.getTimeStamp(shingleSize + index));
            }
            result.setPastValues(reference);
            if (newPoint != null) {
                double[] values = this.preprocessor.getExpectedValue(index, reference, point, newPoint);
                if (this.forestMode == ForestMode.TIME_AUGMENTED) {
                    long expectedTimestamp;
                    int endPosition = (shingleSize + index) * base;
                    double timeGap = newPoint[endPosition - 1] - point[endPosition - 1];
                    long l = expectedTimestamp = timeGap == 0.0 ? result.getInputTimestamp() : (long)values[base - 1];
                    if (index < 0) {
                        expectedTimestamp = timeGap == 0.0 ? this.preprocessor.getTimeStamp(shingleSize - 1 + index) : (long)values[base - 1];
                    }
                    result.setExpectedTimeStamp(expectedTimestamp);
                    double[] plausibleValues = Arrays.copyOf(values, base - 1);
                    result.setExpectedValues(0, plausibleValues, 1.0);
                } else {
                    result.setExpectedValues(0, values, 1.0);
                }
            }
            int startPosition = (shingleSize - 1 + result.getRelativeIndex()) * base;
            DiVector attribution = result.getAttribution();
            if (this.forestMode == ForestMode.TIME_AUGMENTED) {
                --base;
            }
            double[] flattenedAttribution = new double[base];
            for (int i = 0; i < base; ++i) {
                flattenedAttribution[i] = attribution.getHighLowSum(startPosition + i);
            }
            result.setRelevantAttribution(flattenedAttribution);
            if (this.forestMode == ForestMode.TIME_AUGMENTED) {
                result.setTimeAttribution(attribution.getHighLowSum(startPosition + base));
            }
        }
        this.preprocessor.update(result.getCurrentInput(), point, result.getInputTimestamp(), result.getMissingValues(), this.forest);
        if (point != null && result.getAnomalyGrade() > 0.0) {
            double[] postShift = this.preprocessor.getShift();
            result.setPostShift(postShift);
            result.setTransformDecay(this.preprocessor.getTransformDecay());
        }
        if (this.preprocessor.isOutputReady()) {
            result.setPostDeviations(this.preprocessor.getSmoothedDeviations());
        }
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    @Generated
    public RCFComputeDescriptor getLastAnomalyDescriptor() {
        return this.lastAnomalyDescriptor;
    }

    @Generated
    public ForestMode getForestMode() {
        return this.forestMode;
    }

    @Generated
    public TransformMethod getTransformMethod() {
        return this.transformMethod;
    }

    @Generated
    public ScoringStrategy getScoringStrategy() {
        return this.scoringStrategy;
    }

    @Generated
    public PredictorCorrector getPredictorCorrector() {
        return this.predictorCorrector;
    }

    @Generated
    public IPreprocessor getPreprocessor() {
        return this.preprocessor;
    }

    @Generated
    public void setLastAnomalyDescriptor(RCFComputeDescriptor lastAnomalyDescriptor) {
        this.lastAnomalyDescriptor = lastAnomalyDescriptor;
    }

    @Generated
    public void setForestMode(ForestMode forestMode) {
        this.forestMode = forestMode;
    }

    @Generated
    public void setTransformMethod(TransformMethod transformMethod) {
        this.transformMethod = transformMethod;
    }

    @Generated
    public void setForest(RandomCutForest forest) {
        this.forest = forest;
    }

    @Generated
    public void setPredictorCorrector(PredictorCorrector predictorCorrector) {
        this.predictorCorrector = predictorCorrector;
    }

    @Generated
    public void setPreprocessor(IPreprocessor preprocessor) {
        this.preprocessor = preprocessor;
    }

    public static class Builder<T extends Builder<T>> {
        protected int dimensions;
        protected int sampleSize = 256;
        protected Optional<Integer> outputAfter = Optional.empty();
        protected Optional<Integer> startNormalization = Optional.empty();
        protected Optional<Integer> stopNormalization = Optional.empty();
        protected int numberOfTrees = 50;
        protected Optional<Double> timeDecay = Optional.empty();
        protected Optional<Double> scoreDifferencing = Optional.empty();
        protected Optional<Double> lowerThreshold = Optional.empty();
        protected Optional<Double> weightTime = Optional.empty();
        protected Optional<Long> randomSeed = Optional.empty();
        protected boolean storeSequenceIndexesEnabled = false;
        protected boolean centerOfMassEnabled = false;
        protected boolean parallelExecutionEnabled = false;
        protected Optional<Integer> threadPoolSize = Optional.empty();
        protected double boundingBoxCacheFraction = 1.0;
        protected int shingleSize = 1;
        protected Optional<Boolean> internalShinglingEnabled = Optional.empty();
        protected double initialAcceptFraction = 1.0;
        protected double anomalyRate = 0.01;
        protected TransformMethod transformMethod = TransformMethod.NONE;
        protected ImputationMethod imputationMethod = ImputationMethod.RCF;
        protected ForestMode forestMode = ForestMode.STANDARD;
        protected ScoringStrategy scoringStrategy = ScoringStrategy.EXPECTED_INVERSE_DEPTH;
        protected boolean normalizeTime = false;
        protected double[] fillValues = null;
        protected double[] weights = null;
        protected Optional<Double> useImputedFraction = Optional.empty();
        protected boolean autoAdjust = false;
        protected double zFactor = BasicThresholder.DEFAULT_Z_FACTOR;
        protected boolean alertOnceInDrift = false;
        protected Optional<Double> transformDecay = Optional.empty();
        protected Optional<double[]> ignoreNearExpectedFromAbove = Optional.empty();
        protected Optional<double[]> ignoreNearExpectedFromBelow = Optional.empty();
        protected Optional<double[]> ignoreNearExpectedFromAboveByRatio = Optional.empty();
        protected Optional<double[]> ignoreNearExpectedFromBelowByRatio = Optional.empty();

        void validate() {
            if (this.forestMode == ForestMode.TIME_AUGMENTED) {
                if (this.internalShinglingEnabled.isPresent()) {
                    CommonUtils.checkArgument((this.shingleSize == 1 || this.internalShinglingEnabled.get() != false ? 1 : 0) != 0, (String)" shingle size has to be 1 or internal shingling must turned on");
                    CommonUtils.checkArgument((this.transformMethod == TransformMethod.NONE || this.internalShinglingEnabled.get() != false ? 1 : 0) != 0, (String)" internal shingling must turned on for transforms");
                } else {
                    this.internalShinglingEnabled = Optional.of(true);
                }
                if (this.useImputedFraction.isPresent()) {
                    throw new IllegalArgumentException(" imputation infeasible");
                }
            } else if (this.forestMode == ForestMode.STREAMING_IMPUTE) {
                CommonUtils.checkArgument((this.shingleSize > 1 ? 1 : 0) != 0, (String)"imputation with shingle size 1 is not meaningful");
                this.internalShinglingEnabled.ifPresent(x -> CommonUtils.checkArgument((boolean)x, (String)" input cannot be shingled (even if internal representation is different) "));
            } else {
                if (!this.internalShinglingEnabled.isPresent()) {
                    this.internalShinglingEnabled = Optional.of(true);
                }
                if (this.useImputedFraction.isPresent()) {
                    throw new IllegalArgumentException(" imputation infeasible");
                }
            }
            if (this.startNormalization.isPresent()) {
                if (this.outputAfter.isPresent()) {
                    CommonUtils.checkArgument((this.outputAfter.get() + this.shingleSize - 1 > this.startNormalization.get() ? 1 : 0) != 0, (String)"output after has to wait till normalization, reduce normalization");
                } else {
                    int n = this.startNormalization.get();
                    CommonUtils.checkArgument((n > 0 ? 1 : 0) != 0, (String)" startNormalization has to be positive");
                    this.outputAfter = Optional.of(Math.max(Math.max(1, (int)((double)this.sampleSize * 0.25)), n - this.shingleSize + 1));
                }
            } else if (this.outputAfter.isPresent()) {
                this.startNormalization = Optional.of(Math.min(Preprocessor.DEFAULT_START_NORMALIZATION, this.outputAfter.get()));
            }
        }

        public ThresholdedRandomCutForest build() {
            this.validate();
            return new ThresholdedRandomCutForest(this);
        }

        protected RandomCutForest buildForest() {
            RandomCutForest.Builder builder = new RandomCutForest.Builder().dimensions(this.dimensions).sampleSize(this.sampleSize).numberOfTrees(this.numberOfTrees).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled).centerOfMassEnabled(this.centerOfMassEnabled).parallelExecutionEnabled(this.parallelExecutionEnabled).boundingBoxCacheFraction(this.boundingBoxCacheFraction).shingleSize(this.shingleSize).internalShinglingEnabled(this.internalShinglingEnabled.get().booleanValue()).initialAcceptFraction(this.initialAcceptFraction);
            if (this.forestMode != ForestMode.STREAMING_IMPUTE) {
                this.outputAfter.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).outputAfter(arg_0));
            } else {
                this.outputAfter.ifPresent(n -> {
                    int num = Math.max(this.startNormalization.orElse(Preprocessor.DEFAULT_START_NORMALIZATION), n) - this.shingleSize + 1;
                    CommonUtils.checkArgument((num > 0 ? 1 : 0) != 0, (String)(" max(start normalization, output after) should be at least " + this.shingleSize));
                    builder.outputAfter(num);
                });
            }
            this.timeDecay.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).timeDecay(arg_0));
            this.randomSeed.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).randomSeed(arg_0));
            this.threadPoolSize.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).threadPoolSize(arg_0));
            return builder.build();
        }

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return (T)this;
        }

        public T startNormalization(int startNormalization) {
            this.startNormalization = Optional.of(startNormalization);
            return (T)this;
        }

        public T stopNormalization(int stopNormalization) {
            this.stopNormalization = Optional.of(stopNormalization);
            return (T)this;
        }

        public T outputAfter(int outputAfter) {
            this.outputAfter = Optional.of(outputAfter);
            return (T)this;
        }

        public T numberOfTrees(int numberOfTrees) {
            this.numberOfTrees = numberOfTrees;
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T timeDecay(double timeDecay) {
            this.timeDecay = Optional.of(timeDecay);
            return (T)this;
        }

        public T transformDecay(double transformDecay) {
            this.transformDecay = Optional.of(transformDecay);
            return (T)this;
        }

        public T zFactor(double zFactor) {
            this.zFactor = zFactor;
            return (T)this;
        }

        public T useImputedFraction(double fraction) {
            this.useImputedFraction = Optional.of(fraction);
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = Optional.of(randomSeed);
            return (T)this;
        }

        public T centerOfMassEnabled(boolean centerOfMassEnabled) {
            this.centerOfMassEnabled = centerOfMassEnabled;
            return (T)this;
        }

        public T parallelExecutionEnabled(boolean parallelExecutionEnabled) {
            this.parallelExecutionEnabled = parallelExecutionEnabled;
            return (T)this;
        }

        public T threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = Optional.of(threadPoolSize);
            return (T)this;
        }

        public T storeSequenceIndexesEnabled(boolean storeSequenceIndexesEnabled) {
            this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
            return (T)this;
        }

        @Deprecated
        public T compact(boolean compact) {
            return (T)this;
        }

        public T internalShinglingEnabled(boolean internalShinglingEnabled) {
            this.internalShinglingEnabled = Optional.of(internalShinglingEnabled);
            return (T)this;
        }

        @Deprecated
        public T precision(Precision precision) {
            return (T)this;
        }

        public T boundingBoxCacheFraction(double boundingBoxCacheFraction) {
            this.boundingBoxCacheFraction = boundingBoxCacheFraction;
            return (T)this;
        }

        public T initialAcceptFraction(double initialAcceptFraction) {
            this.initialAcceptFraction = initialAcceptFraction;
            return (T)this;
        }

        public Random getRandom() {
            return this.randomSeed.map(Random::new).orElseGet(Random::new);
        }

        public T anomalyRate(double anomalyRate) {
            this.anomalyRate = anomalyRate;
            return (T)this;
        }

        public T imputationMethod(ImputationMethod imputationMethod) {
            this.imputationMethod = imputationMethod;
            return (T)this;
        }

        public T fillValues(double[] values) {
            this.fillValues = Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T weights(double[] values) {
            this.weights = Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T normalizeTime(boolean normalizeTime) {
            this.normalizeTime = normalizeTime;
            return (T)this;
        }

        public T transformMethod(TransformMethod method) {
            this.transformMethod = method;
            return (T)this;
        }

        public T forestMode(ForestMode forestMode) {
            this.forestMode = forestMode;
            return (T)this;
        }

        public T scoreDifferencing(double persistence) {
            this.scoreDifferencing = Optional.of(persistence);
            return (T)this;
        }

        public T autoAdjust(boolean autoAdjust) {
            this.autoAdjust = autoAdjust;
            return (T)this;
        }

        public T weightTime(double value) {
            this.weightTime = Optional.of(value);
            return (T)this;
        }

        public T ignoreNearExpectedFromAbove(double[] ignoreSimilarFromAbove) {
            this.ignoreNearExpectedFromAbove = Optional.ofNullable(ignoreSimilarFromAbove);
            return (T)this;
        }

        public T ignoreNearExpectedFromBelow(double[] ignoreSimilarFromBelow) {
            this.ignoreNearExpectedFromBelow = Optional.ofNullable(ignoreSimilarFromBelow);
            return (T)this;
        }

        public T ignoreNearExpectedFromAboveByRatio(double[] ignoreSimilarFromAboveByRatio) {
            this.ignoreNearExpectedFromAboveByRatio = Optional.ofNullable(ignoreSimilarFromAboveByRatio);
            return (T)this;
        }

        public T ignoreNearExpectedFromBelowByRatio(double[] ignoreSimilarFromBelowByRatio) {
            this.ignoreNearExpectedFromBelowByRatio = Optional.ofNullable(ignoreSimilarFromBelowByRatio);
            return (T)this;
        }

        public T scoringStrategy(ScoringStrategy scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
            return (T)this;
        }

        public T alertOnce(boolean alertOnceInDrift) {
            this.alertOnceInDrift = alertOnceInDrift;
            return (T)this;
        }
    }
}

