/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.internal.pqc.lms.Composer;
import org.bouncycastle.crypto.internal.pqc.lms.HSSPrivateKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSPrivateKeyParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;

public final class AsymmetricLMSPrivateKey
extends AsymmetricLMSKey
implements Destroyable,
AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] keyData;
    private byte[] publicData;
    private ASN1Set attributes;
    private int hashCode;
    private AsymmetricKeyParameter lwKey;

    public AsymmetricLMSPrivateKey(int n, byte[] byArray, byte[] byArray2) {
        super(n);
        this.keyData = Arrays.clone(byArray);
        this.publicData = Arrays.clone(byArray2);
        this.hashCode = this.calculateHashCode();
        this.lwKey = AsymmetricLMSPrivateKey.getLwKey(this);
    }

    public AsymmetricLMSPrivateKey(byte[] byArray) throws IOException {
        this(PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricLMSPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this(ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey()).getOctets(), privateKeyInfo.getPublicKeyData(), privateKeyInfo.getAttributes());
    }

    private AsymmetricLMSPrivateKey(byte[] byArray, ASN1BitString aSN1BitString, ASN1Set aSN1Set) {
        this(Pack.bigEndianToInt(byArray, 0), byArray, aSN1BitString, aSN1Set);
    }

    private AsymmetricLMSPrivateKey(int n, byte[] byArray, ASN1BitString aSN1BitString, ASN1Set aSN1Set) {
        super(n);
        this.keyData = Arrays.copyOfRange(byArray, 4, byArray.length);
        this.attributes = aSN1Set;
        this.hashCode = this.calculateHashCode();
        this.lwKey = AsymmetricLMSPrivateKey.getLwKey(this);
        if (aSN1BitString != null) {
            byte[] byArray2 = aSN1BitString.getOctets();
            this.publicData = Arrays.copyOfRange(byArray2, 4, byArray2.length);
        } else {
            this.publicData = this.lwKey instanceof LMSPrivateKeyParameters ? ((LMSPrivateKeyParameters)this.lwKey).getPublicKey().getEncoded() : ((HSSPrivateKeyParameters)this.lwKey).getPublicKey().getLMSPublicKey().getEncoded();
        }
    }

    public long getUsagesRemaining() {
        if (this.lwKey instanceof LMSPrivateKeyParameters) {
            return ((LMSPrivateKeyParameters)this.lwKey).getUsagesRemaining();
        }
        return ((HSSPrivateKeyParameters)this.lwKey).getUsagesRemaining();
    }

    public long getIndex() {
        if (this.lwKey instanceof LMSPrivateKeyParameters) {
            return ((LMSPrivateKeyParameters)this.lwKey).getIndex();
        }
        return ((HSSPrivateKeyParameters)this.lwKey).getIndex();
    }

    public byte[] getSecret() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        byte[] byArray = Arrays.clone(this.keyData);
        KeyUtils.checkDestroyed(this);
        return byArray;
    }

    public byte[] getPublicData() {
        byte[] byArray = Arrays.clone(this.publicData);
        KeyUtils.checkDestroyed(this);
        return byArray;
    }

    public AsymmetricLMSPrivateKey extractKeyShard(int n) {
        if (this.lwKey instanceof LMSPrivateKeyParameters) {
            LMSPrivateKeyParameters lMSPrivateKeyParameters = ((LMSPrivateKeyParameters)this.lwKey).extractKeyShard(n);
            return new AsymmetricLMSPrivateKey(1, lMSPrivateKeyParameters.getEncoded(), this.publicData);
        }
        HSSPrivateKeyParameters hSSPrivateKeyParameters = ((HSSPrivateKeyParameters)this.lwKey).extractKeyShard(n);
        return new AsymmetricLMSPrivateKey(this.getL(), hSSPrivateKeyParameters.getEncoded(), this.publicData);
    }

    @Override
    public byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        byte[] byArray = Composer.compose().u32str(this.L).bytes(this.keyData).build();
        byte[] byArray2 = Composer.compose().u32str(this.L).bytes(this.publicData).build();
        KeyUtils.checkDestroyed(this);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
        if (Properties.isOverrideSet("org.bouncycastle.pkcs8.v1_info_only")) {
            return KeyUtils.getEncodedPrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), this.attributes, null);
        }
        return KeyUtils.getEncodedPrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray), this.attributes, byArray2);
    }

    @Override
    protected Object getInternalKey() {
        return this.lwKey;
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.keyData);
            if (this.publicData != null) {
                Arrays.clear(this.publicData);
            }
            this.publicData = null;
            this.attributes = null;
            this.lwKey = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    @Override
    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricLMSPrivateKey)) {
            return false;
        }
        AsymmetricLMSPrivateKey asymmetricLMSPrivateKey = (AsymmetricLMSPrivateKey)object;
        asymmetricLMSPrivateKey.checkApprovedOnlyModeStatus();
        if (!Arrays.constantTimeAreEqual(this.keyData, asymmetricLMSPrivateKey.keyData)) {
            return false;
        }
        return this.getAlgorithm().equals(asymmetricLMSPrivateKey.getAlgorithm());
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.getAlgorithm().hashCode();
        n = 31 * n + Arrays.hashCode(this.keyData);
        return n;
    }

    private static AsymmetricKeyParameter getLwKey(final AsymmetricLMSPrivateKey asymmetricLMSPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyParameter>(){

            @Override
            public AsymmetricKeyParameter run() {
                try {
                    if (asymmetricLMSPrivateKey.getL() == 1) {
                        return LMSPrivateKeyParameters.getInstance(asymmetricLMSPrivateKey.getSecret());
                    }
                    return HSSPrivateKeyParameters.getInstance(asymmetricLMSPrivateKey.getSecret());
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException);
                }
            }
        });
    }
}

