/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsKeyring_Compile.KmsWrapInfo;
import BoundedInts_Compile.int32;
import MaterialWrapping_Compile.GenerateAndWrapInput;
import MaterialWrapping_Compile.GenerateAndWrapMaterial;
import MaterialWrapping_Compile.GenerateAndWrapOutput;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.DataKeySpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenList;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types.RecipientInfo;

public class KmsGenerateAndWrapKeyMaterial
implements GenerateAndWrapMaterial<KmsWrapInfo>,
ActionWithResult<GenerateAndWrapInput, GenerateAndWrapOutput<KmsWrapInfo>, Error>,
Action<GenerateAndWrapInput, Result<GenerateAndWrapOutput<KmsWrapInfo>, Error>> {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<KmsGenerateAndWrapKeyMaterial> _TYPE = TypeDescriptor.referenceWithInitializer(KmsGenerateAndWrapKeyMaterial.class, () -> null);

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<GenerateAndWrapOutput<KmsWrapInfo>, Error> Invoke(GenerateAndWrapInput input) {
        Result<GenerateDataKeyResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out0;
        Result<GenerateAndWrapOutput<KmsWrapInfo>, Error> res = Result.Default(GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor(), GenerateAndWrapOutput.Default(KmsWrapInfo._typeDescriptor(), KmsWrapInfo.Default()));
        AlgorithmSuiteInfo _0_suite = input.dtor_algorithmSuite();
        Result<DafnyMap, Error> _1_valueOrError0 = Result.Default(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), DafnyMap.empty());
        _1_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_encryptionContext());
        if (_1_valueOrError0.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _1_valueOrError0.PropagateFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        DafnyMap _2_stringifiedEncCtx = _1_valueOrError0.Extract((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        GenerateDataKeyRequest _3_generatorRequest = GenerateDataKeyRequest.create(this.awsKmsKey(), Option.create_Some(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), _2_stringifiedEncCtx), Option.create_Some(int32._typeDescriptor(), AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_0_suite)), Option.create_None(DataKeySpec._typeDescriptor()), Option.create_Some(GrantTokenList._typeDescriptor(), this.grantTokens()), Option.create_None(RecipientInfo._typeDescriptor()), Option.create_None(TypeDescriptor.BOOLEAN));
        Result<GenerateDataKeyResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _4_maybeGenerateResponse = _out0 = this.client().GenerateDataKey(_3_generatorRequest);
        Result<GenerateDataKeyResponse, Error> _5_valueOrError1 = Result.Default(GenerateDataKeyResponse._typeDescriptor(), Error._typeDescriptor(), GenerateDataKeyResponse.Default());
        _5_valueOrError1 = _4_maybeGenerateResponse.MapFailure(GenerateDataKeyResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _6_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _6_e = _6_e_boxed0;
            return Error.create_ComAmazonawsKms(_6_e);
        });
        if (_5_valueOrError1.IsFailure(GenerateDataKeyResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _5_valueOrError1.PropagateFailure(GenerateDataKeyResponse._typeDescriptor(), Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        GenerateDataKeyResponse _7_generateResponse = _5_valueOrError1.Extract(GenerateDataKeyResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _8_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _8_valueOrError2 = __default.Need(Error._typeDescriptor(), _7_generateResponse.dtor_KeyId().is_Some() && AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(_7_generateResponse.dtor_KeyId().dtor_value()).is_Success(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS GenerateDataKey:: Invalid Key Id")));
        if (_8_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _8_valueOrError2.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Error> _9_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _9_valueOrError3 = __default.Need(Error._typeDescriptor(), _7_generateResponse.dtor_Plaintext().is_Some() && Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_0_suite)), BigInteger.valueOf(_7_generateResponse.dtor_Plaintext().dtor_value().length())), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Invalid data key")));
        if (_9_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _9_valueOrError3.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Error> _10_valueOrError4 = Outcome.Default(Error._typeDescriptor());
        _10_valueOrError4 = __default.Need(Error._typeDescriptor(), _7_generateResponse.dtor_CiphertextBlob().is_Some() && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(_7_generateResponse.dtor_CiphertextBlob().dtor_value()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GeneratedDataKey: Invalid ciphertext")));
        if (_10_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _10_valueOrError4.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Error> _11_valueOrError5 = Outcome.Default(Error._typeDescriptor());
        _11_valueOrError5 = __default.Need(Error._typeDescriptor(), _7_generateResponse.dtor_CiphertextForRecipient().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GeneratedDataKey: Invalid CiphertextForRecipient")));
        if (_11_valueOrError5.IsFailure(Error._typeDescriptor())) {
            res = _11_valueOrError5.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        GenerateAndWrapOutput<KmsWrapInfo> _12_output = GenerateAndWrapOutput.create(KmsWrapInfo._typeDescriptor(), _7_generateResponse.dtor_Plaintext().dtor_value(), _7_generateResponse.dtor_CiphertextBlob().dtor_value(), KmsWrapInfo.create(_7_generateResponse.dtor_KeyId().dtor_value()));
        res = Result.create_Success(GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor(), _12_output);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<KmsGenerateAndWrapKeyMaterial> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.KmsGenerateAndWrapKeyMaterial";
    }
}

