/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.example;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import java.util.ArrayList;
import java.util.List;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.classification.Label;
import org.tribuo.classification.example.DemoLabelDataSource;
import org.tribuo.impl.ArrayExample;

public final class ConcentricCirclesDataSource
extends DemoLabelDataSource {
    @Config(description="The radius of the outer circle.")
    private double radius = 2.0;
    @Config(description="The proportion of the circle radius that forms class one.")
    private double classProportion = 0.5;

    private ConcentricCirclesDataSource() {
    }

    public ConcentricCirclesDataSource(int numSamples, long seed, double radius, double classProportion) {
        super(numSamples, seed);
        this.radius = radius;
        this.classProportion = classProportion;
        this.postConfig();
    }

    @Override
    public void postConfig() {
        if (this.classProportion <= 0.0 || this.classProportion >= 1.0) {
            throw new PropertyException("", "classProportion", "Class proportion must be between zero and one, found " + this.classProportion);
        }
        if (this.radius <= 0.0) {
            throw new PropertyException("", "radius", "Radius must be positive, found " + this.radius);
        }
        super.postConfig();
    }

    @Override
    protected List<Example<Label>> generate() {
        ArrayList<Example<Label>> list = new ArrayList<Example<Label>>();
        for (int i = 0; i < this.numSamples; ++i) {
            double rotation = this.rng.nextDouble() * 2.0 * Math.PI;
            double distance = Math.sqrt(this.rng.nextDouble()) * this.radius;
            double[] values = new double[]{distance * Math.cos(rotation), distance * Math.sin(rotation)};
            double labelDistance = values[0] * values[0] + values[1] * values[1];
            Label label = labelDistance < this.classProportion * this.radius * this.radius ? FIRST_CLASS : SECOND_CLASS;
            list.add((Example<Label>)new ArrayExample((Output)label, FEATURE_NAMES, values));
        }
        return list;
    }

    public String toString() {
        return "ConcentricCircles(numSamples=" + this.numSamples + ",seed=" + this.seed + ",radius=" + this.radius + ",classProportion=" + this.classProportion + ")";
    }
}

