/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class WebRequestLog
extends ContainerLifeCycle
implements RequestLog {
    private final RequestLog.Writer writer;
    private final DateCache dateCache = new DateCache("dd/MMM/yyyy:HH:mm:ss ZZZ", Locale.getDefault(), TimeZone.getTimeZone("GMT"));

    public WebRequestLog(RequestLog.Writer writer) {
        this.writer = writer;
        this.addBean(writer);
    }

    public void log(Request request, Response response) {
        try {
            Long userId = (Long)request.getSession().getAttribute("userId");
            this.writer.write(String.format("%s - %s [%s] \"%s %s %s\" %d %d", request.getRemoteHost(), userId != null ? String.valueOf(userId) : "-", this.dateCache.format(request.getTimeStamp()), request.getMethod(), request.getOriginalURI(), request.getProtocol(), response.getCommittedMetaData().getStatus(), response.getHttpChannel().getBytesWritten()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

