"""Generated message classes for cloudasset version v1p7beta1.

The cloud asset API manages the history and inventory of cloud resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudasset'


class BigQueryDestination(_messages.Message):
  r"""A BigQuery destination for exporting assets to.

  Fields:
    dataset: Required. The BigQuery dataset in format
      "projects/projectId/datasets/datasetId", to which the snapshot result
      should be exported. If this dataset does not exist, the export call
      returns an INVALID_ARGUMENT error.
    force: If the destination table already exists and this flag is `TRUE`,
      the table will be overwritten by the contents of assets snapshot. If the
      flag is `FALSE` or unset and the destination table already exists, the
      export call returns an INVALID_ARGUMEMT error.
    partitionSpec: [partition_spec] determines whether to export to
      partitioned table(s) and how to partition the data. If [partition_spec]
      is unset or [partition_spec.partition_key] is unset or
      `PARTITION_KEY_UNSPECIFIED`, the snapshot results will be exported to
      non-partitioned table(s). [force] will decide whether to overwrite
      existing table(s). If [partition_spec] is specified. First, the snapshot
      results will be written to partitioned table(s) with two additional
      timestamp columns, readTime and requestTime, one of which will be the
      partition key. Secondly, in the case when any destination table already
      exists, it will first try to update existing table's schema as necessary
      by appending additional columns. Then, if [force] is `TRUE`, the
      corresponding partition will be overwritten by the snapshot results
      (data in different partitions will remain intact); if [force] is unset
      or `FALSE`, it will append the data. An error will be returned if the
      schema update or data appension fails.
    separateTablesPerAssetType: If this flag is `TRUE`, the snapshot results
      will be written to one or multiple tables, each of which contains
      results of one asset type. The [force] and [partition_spec] fields will
      apply to each of them. Field [table] will be concatenated with "_" and
      the asset type names (see https://cloud.google.com/asset-
      inventory/docs/supported-asset-types for supported asset types) to
      construct per-asset-type table names, in which all non-alphanumeric
      characters like "." and "/" will be substituted by "_". Example: if
      field [table] is "mytable" and snapshot results contain
      "storage.googleapis.com/Bucket" assets, the corresponding table name
      will be "mytable_storage_googleapis_com_Bucket". If any of these tables
      does not exist, a new table with the concatenated name will be created.
      When [content_type] in the ExportAssetsRequest is `RESOURCE`, the schema
      of each table will include RECORD-type columns mapped to the nested
      fields in the Asset.resource.data field of that asset type (up to the 15
      nested level BigQuery supports
      (https://cloud.google.com/bigquery/docs/nested-repeated#limitations)).
      The fields in >15 nested levels will be stored in JSON format string as
      a child column of its parent RECORD column. If error occurs when
      exporting to any table, the whole export call will return an error but
      the export results that already succeed will persist. Example: if
      exporting to table_type_A succeeds when exporting to table_type_B fails
      during one export call, the results in table_type_A will persist and
      there will not be partial results persisting in a table.
    table: Required. The BigQuery table to which the snapshot result should be
      written. If this table does not exist, a new table with the given name
      will be created.
  """

  dataset = _messages.StringField(1)
  force = _messages.BooleanField(2)
  partitionSpec = _messages.MessageField('PartitionSpec', 3)
  separateTablesPerAssetType = _messages.BooleanField(4)
  table = _messages.StringField(5)


class CloudassetExportAssetsRequest(_messages.Message):
  r"""A CloudassetExportAssetsRequest object.

  Fields:
    exportAssetsRequest: A ExportAssetsRequest resource to be passed as the
      request body.
    parent: Required. The relative name of the root asset. This can only be an
      organization number (such as "organizations/123"), a project ID (such as
      "projects/my-project-id"), or a project number (such as
      "projects/12345"), or a folder number (such as "folders/123").
  """

  exportAssetsRequest = _messages.MessageField('ExportAssetsRequest', 1)
  parent = _messages.StringField(2, required=True)


class ExportAssetsRequest(_messages.Message):
  r"""Export asset request.

  Enums:
    ContentTypeValueValuesEnum: Asset content type. If not specified, no
      content but the asset name will be returned.

  Fields:
    assetTypes: A list of asset types to take a snapshot for. For example:
      "compute.googleapis.com/Disk". Regular expressions are also supported.
      For example: * "compute.googleapis.com.*" snapshots resources whose
      asset type starts with "compute.googleapis.com". * ".*Instance"
      snapshots resources whose asset type ends with "Instance". *
      ".*Instance.*" snapshots resources whose asset type contains "Instance".
      See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
      regular expression syntax. If the regular expression does not match any
      supported asset type, an INVALID_ARGUMENT error will be returned. If
      specified, only matching assets will be returned, otherwise, it will
      snapshot all asset types. See [Introduction to Cloud Asset
      Inventory](https://cloud.google.com/asset-inventory/docs/overview) for
      all supported asset types.
    contentType: Asset content type. If not specified, no content but the
      asset name will be returned.
    outputConfig: Required. Output configuration indicating where the results
      will be output to.
    readTime: Timestamp to take an asset snapshot. This can only be set to a
      timestamp between the current time and the current time minus 35 days
      (inclusive). If not specified, the current time will be used. Due to
      delays in resource data collection and indexing, there is a volatile
      window during which running the same query may get different results.
    relationshipTypes: A list of relationship types to export, for example:
      `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
      content_type=RELATIONSHIP. If specified, it will snapshot [asset_types]'
      specified relationships, or give errors if any relationship_types'
      supported types are not in [asset_types]. If not specified, it will
      snapshot all [asset_types]' supported relationships. An unspecified
      [asset_types] field means all supported asset_types. See [Introduction
      to Cloud Asset Inventory](https://cloud.google.com/asset-
      inventory/docs/overview) for all supported asset types and relationship
      types.
  """

  class ContentTypeValueValuesEnum(_messages.Enum):
    r"""Asset content type. If not specified, no content but the asset name
    will be returned.

    Values:
      CONTENT_TYPE_UNSPECIFIED: Unspecified content type.
      RESOURCE: Resource metadata.
      IAM_POLICY: The actual IAM policy set on a resource.
      ORG_POLICY: The Cloud Organization Policy set on an asset.
      ACCESS_POLICY: The Cloud Access context manager Policy set on an asset.
      RELATIONSHIP: The related resources.
    """
    CONTENT_TYPE_UNSPECIFIED = 0
    RESOURCE = 1
    IAM_POLICY = 2
    ORG_POLICY = 3
    ACCESS_POLICY = 4
    RELATIONSHIP = 5

  assetTypes = _messages.StringField(1, repeated=True)
  contentType = _messages.EnumField('ContentTypeValueValuesEnum', 2)
  outputConfig = _messages.MessageField('OutputConfig', 3)
  readTime = _messages.StringField(4)
  relationshipTypes = _messages.StringField(5, repeated=True)


class GcsDestination(_messages.Message):
  r"""A Cloud Storage location.

  Fields:
    uri: The uri of the Cloud Storage object. It's the same uri that is used
      by gsutil. Example: "gs://bucket_name/object_name". See [Viewing and
      Editing Object Metadata](https://cloud.google.com/storage/docs/viewing-
      editing-metadata) for more information.
    uriPrefix: The uri prefix of all generated Cloud Storage objects. Example:
      "gs://bucket_name/object_name_prefix". Each object uri is in format:
      "gs://bucket_name/object_name_prefix/{ASSET_TYPE}/{SHARD_NUMBER} and
      only contains assets for that type. starts from 0. Example:
      "gs://bucket_name/object_name_prefix/compute.googleapis.com/Disk/0" is
      the first shard of output objects containing all
      compute.googleapis.com/Disk assets. An INVALID_ARGUMENT error will be
      returned if file with the same name
      "gs://bucket_name/object_name_prefix" already exists.
  """

  uri = _messages.StringField(1)
  uriPrefix = _messages.StringField(2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OutputConfig(_messages.Message):
  r"""Output configuration for export assets destination.

  Fields:
    bigqueryDestination: Destination on BigQuery. The output table stores the
      fields in asset proto as columns in BigQuery.
    gcsDestination: Destination on Cloud Storage.
  """

  bigqueryDestination = _messages.MessageField('BigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GcsDestination', 2)


class PartitionSpec(_messages.Message):
  r"""Specifications of BigQuery partitioned table as export destination.

  Enums:
    PartitionKeyValueValuesEnum: The partition key for BigQuery partitioned
      table.

  Fields:
    partitionKey: The partition key for BigQuery partitioned table.
  """

  class PartitionKeyValueValuesEnum(_messages.Enum):
    r"""The partition key for BigQuery partitioned table.

    Values:
      PARTITION_KEY_UNSPECIFIED: Unspecified partition key. If used, it means
        using non-partitioned table.
      READ_TIME: The time when the snapshot is taken. If specified as
        partition key, the result table(s) is partitoned by the additional
        timestamp column, readTime. If [read_time] in ExportAssetsRequest is
        specified, the readTime column's value will be the same as it.
        Otherwise, its value will be the current time that is used to take the
        snapshot.
      REQUEST_TIME: The time when the request is received and started to be
        processed. If specified as partition key, the result table(s) is
        partitoned by the requestTime column, an additional timestamp column
        representing when the request was received.
    """
    PARTITION_KEY_UNSPECIFIED = 0
    READ_TIME = 1
    REQUEST_TIME = 2

  partitionKey = _messages.EnumField('PartitionKeyValueValuesEnum', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
