/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSupport;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.TypeTemplate;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DelegatedTypeSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerState;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerImpl;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020!J\"\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020!H\u0002JL\u0010+\u001a\u00020\u00172\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030,26\u0010-\u001a2\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00170.H\u0002J\u001c\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030,H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;)V", "getArgumentTypeResolver", "()Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "<set-?>", "Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "callCompleter", "getCallCompleter", "()Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "setCallCompleter", "(Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;)V", "getExpressionTypingServices", "()Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "analyzeBuilderInferenceCall", "", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunction;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "lambdaExpectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "checkBuilderInferenceCalls", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "tracingStrategy", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "overloadResults", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "checkExpectedTypeForArgument", "", "expectedType", "forceInferenceForArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "argument", "argumentType", "getArgumentTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "BuilderInferenceTypeCheckerState", "frontend"})
@SourceDebugExtension(value={"SMAP\nBuilderInferenceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuilderInferenceUtil.kt\norg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1549#2:361\n1620#2,3:362\n1#3:365\n*S KotlinDebug\n*F\n+ 1 BuilderInferenceUtil.kt\norg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport\n*L\n181#1:361\n181#1:362,3\n*E\n"})
public final class BuilderInferenceSupport {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    public CallCompleter callCompleter;

    public BuilderInferenceSupport(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        this.argumentTypeResolver = argumentTypeResolver;
        this.expressionTypingServices = expressionTypingServices;
    }

    @NotNull
    public final ArgumentTypeResolver getArgumentTypeResolver() {
        return this.argumentTypeResolver;
    }

    @NotNull
    public final ExpressionTypingServices getExpressionTypingServices() {
        return this.expressionTypingServices;
    }

    @NotNull
    public final CallCompleter getCallCompleter() {
        CallCompleter callCompleter = this.callCompleter;
        if (callCompleter != null) {
            return callCompleter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"callCompleter");
        return null;
    }

    @Inject
    public final void setCallCompleter(@NotNull CallCompleter callCompleter) {
        Intrinsics.checkNotNullParameter((Object)callCompleter, (String)"<set-?>");
        this.callCompleter = callCompleter;
    }

    private final LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings2 = this.expressionTypingServices.getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings2, (String)"expressionTypingServices.languageVersionSettings");
        return languageVersionSettings2;
    }

    /*
     * WARNING - void declaration
     */
    public final void analyzeBuilderInferenceCall(@NotNull KtFunction functionLiteral, @NotNull ValueArgument valueArgument, @NotNull ConstraintSystem.Builder csBuilder, @NotNull CallCandidateResolutionContext<?> context, @NotNull KotlinType lambdaExpectedType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)functionLiteral, (String)"functionLiteral");
        Intrinsics.checkNotNullParameter((Object)valueArgument, (String)"valueArgument");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lambdaExpectedType, (String)"lambdaExpectedType");
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        if (!this.checkExpectedTypeForArgument(lambdaExpectedType)) {
            return;
        }
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(lambdaExpectedType);
        if (kotlinType == null) {
            return;
        }
        KotlinType lambdaReceiverType = kotlinType;
        BuilderInferenceData inferenceData = new BuilderInferenceData();
        ConstraintSystem constraintSystem = csBuilder.build();
        TypeSubstitution typeSubstitution = constraintSystem.getCurrentSubstitutor().getSubstitution();
        DelegatedTypeSubstitution newSubstitution2 = new DelegatedTypeSubstitution(constraintSystem, inferenceData, typeSubstitution){
            final /* synthetic */ ConstraintSystem $constraintSystem;
            final /* synthetic */ BuilderInferenceData $inferenceData;
            {
                this.$constraintSystem = $constraintSystem;
                this.$inferenceData = $inferenceData;
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$1, (String)"substitution");
                super($super_call_param$1);
            }

            @Nullable
            public TypeProjection get(@NotNull KotlinType key) {
                Object v1;
                TypeProjection substitutedType;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    TypeProjection typeProjection = substitutedType = super.get(key);
                    if (!Intrinsics.areEqual((Object)(typeProjection != null ? typeProjection.getType() : null), (Object)TypeUtils.DONT_CARE)) {
                        return substitutedType;
                    }
                    Iterable $this$firstOrNull$iv = this.$constraintSystem.getTypeVariables();
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        TypeVariable it = (TypeVariable)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getOriginalTypeParameter().getDefaultType(), (Object)key)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                TypeVariable typeVariable = v1;
                if (typeVariable == null) {
                    return substitutedType;
                }
                TypeVariable typeVariable2 = typeVariable;
                return TypeUtilsKt.asTypeProjection(this.$inferenceData.getTypeTemplate(typeVariable2));
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        };
        KotlinType kotlinType2 = newSubstitution2.buildSubstitutor().substitute(lambdaReceiverType, Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType newReceiverType = kotlinType2;
        TypeSubstitution typeSubstitution2 = constraintSystem.getCurrentSubstitutor().getSubstitution();
        DelegatedTypeSubstitution approximationSubstitutor2 = new DelegatedTypeSubstitution(typeSubstitution2){
            {
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$1, (String)"substitution");
                super($super_call_param$1);
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        };
        KotlinType kotlinType3 = approximationSubstitutor2.buildSubstitutor().substitute(lambdaExpectedType, Variance.IN_VARIANCE);
        if (kotlinType3 == null) {
            return;
        }
        KotlinType approximatedLambdaType = kotlinType3;
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(approximatedLambdaType);
        List list2 = CollectionsKt.emptyList();
        KotlinType kotlinType4 = newReceiverType;
        Annotations annotations2 = approximatedLambdaType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(newReceiverType);
        boolean $i$f$map = false;
        void var17_21 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getType());
        }
        collection = (List)destination$iv$iv;
        SimpleType newExpectedType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType4, list2, (List<? extends KotlinType>)collection, null, FunctionTypesKt.getReturnTypeFromFunctionType(approximatedLambdaType), true);
        if (CallResolverUtilKt.hasUnknownFunctionParameter(newExpectedType)) {
            return;
        }
        inferenceData.initSystem();
        TemporaryTraceAndCache temporaryForBuilderInference = TemporaryTraceAndCache.create(context, "trace to infer a type argument using the builder inference", functionLiteral);
        Object Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceExpectedType(newExpectedType)).replaceDataFlowInfo(context.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument))).replaceContextDependency(ContextDependency.INDEPENDENT)).replaceTraceAndCache(temporaryForBuilderInference);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceExpectedT\u2026oraryForBuilderInference)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, true);
        inferenceData.reportInferenceResult(csBuilder);
    }

    private final boolean checkExpectedTypeForArgument(KotlinType expectedType) {
        return this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType) : FunctionTypesKt.isSuspendFunctionType(expectedType);
    }

    public final void checkBuilderInferenceCalls(@NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracingStrategy, @NotNull OverloadResolutionResultsImpl<?> overloadResults) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)tracingStrategy, (String)"tracingStrategy");
            Intrinsics.checkNotNullParameter(overloadResults, (String)"overloadResults");
            BuilderInferenceData builderInferenceData = BuilderInferenceUtilKt.access$getBuilderInferenceData(overloadResults);
            if (builderInferenceData == null) {
                return;
            }
            BuilderInferenceData inferenceData = builderInferenceData;
            ResolvedCall resolvedCall2 = overloadResults.getResultingCall();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"overloadResults.resultingCall");
            ResolvedCall resultingCall = resolvedCall2;
            this.forceInferenceForArguments(context, (Function2<? super ValueArgument, ? super KotlinType, Unit>)((Function2)checkBuilderInferenceCalls.1.INSTANCE));
            this.getCallCompleter().completeCall(context, overloadResults, tracingStrategy);
            if (!ArgumentMappingKt.isReallySuccess(resultingCall)) {
                return;
            }
            Object resultingDescriptor = resultingCall.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(resultingDescriptor, (String)"resultingDescriptor");
            if (!BuilderInferenceUtilKt.isApplicableCallForBuilderInference(resultingDescriptor, this.getLanguageVersionSettings())) {
                inferenceData.badCallHappened();
            }
            this.forceInferenceForArguments(context, (Function2<? super ValueArgument, ? super KotlinType, Unit>)((Function2)new Function2<ValueArgument, KotlinType, Unit>((MutableResolvedCall<? extends CallableDescriptor>)resultingCall, context){
                final /* synthetic */ MutableResolvedCall<? extends CallableDescriptor> $resultingCall;
                final /* synthetic */ BasicCallResolutionContext $context;
                {
                    this.$resultingCall = $resultingCall;
                    this.$context = $context;
                    super(2);
                }

                public final void invoke(@NotNull ValueArgument valueArgument, @NotNull KotlinType kotlinType) {
                    Intrinsics.checkNotNullParameter((Object)valueArgument, (String)"valueArgument");
                    Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
                    Object object = this.$resultingCall.getArgumentMapping(valueArgument);
                    ArgumentMatch argumentMatch = object instanceof ArgumentMatch ? (ArgumentMatch)object : null;
                    if (argumentMatch == null) {
                        return;
                    }
                    ArgumentMatch argumentMatch2 = argumentMatch;
                    NewKotlinTypeCheckerImpl newKotlinTypeCheckerImpl = NewKotlinTypeChecker.Companion.getDefault();
                    object = this.$context;
                    NewKotlinTypeCheckerImpl $this$invoke_u24lambda_u240 = newKotlinTypeCheckerImpl;
                    boolean bl = false;
                    KotlinType parameterType = CallResolverUtilKt.getEffectiveExpectedType(argumentMatch2.getValueParameter(), valueArgument, (ResolutionContext)object);
                    $this$invoke_u24lambda_u240.isSubtypeOf(new BuilderInferenceTypeCheckerState(false), kotlinType.unwrap(), parameterType.unwrap());
                }
            }));
            ReceiverParameterDescriptor receiverParameterDescriptor = resultingDescriptor.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                return;
            }
            ReceiverParameterDescriptor extensionReceiver = receiverParameterDescriptor;
            boolean allowOnlyTrivialConstraintsForReceiver = this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? !AnnotationsForResolveUtilsKt.hasBuilderInferenceAnnotation(resultingDescriptor) : false;
            ReceiverValue receiverValue = resultingCall.getExtensionReceiver();
            if (receiverValue == null) break block4;
            ReceiverValue actualReceiver = receiverValue;
            boolean bl = false;
            NewKotlinTypeCheckerImpl $this$checkBuilderInferenceCalls_u24lambda_u241_u24lambda_u240 = NewKotlinTypeChecker.Companion.getDefault();
            boolean bl2 = false;
            $this$checkBuilderInferenceCalls_u24lambda_u241_u24lambda_u240.isSubtypeOf(new BuilderInferenceTypeCheckerState(allowOnlyTrivialConstraintsForReceiver), actualReceiver.getType().unwrap(), extensionReceiver.getValue().getType().unwrap());
        }
    }

    private final void forceInferenceForArguments(CallResolutionContext<?> context, Function2<? super ValueArgument, ? super KotlinType, Unit> callback) {
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = context.dataFlowInfoForArguments;
        Intrinsics.checkNotNullExpressionValue((Object)mutableDataFlowInfoForArguments, (String)"context.dataFlowInfoForArguments");
        MutableDataFlowInfoForArguments infoForArguments = mutableDataFlowInfoForArguments;
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"context.call");
        Call call3 = call2;
        CallResolutionContext baseContext = (CallResolutionContext)((CallResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        for (ValueArgument valueArgument : call3.getValueArguments()) {
            KotlinType it;
            KtExpression expression2;
            if (valueArgument.getArgumentExpression() == null) continue;
            Object Context2 = baseContext.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            Intrinsics.checkNotNullExpressionValue(Context2, (String)"baseContext.replaceDataF\u2026uments.getInfo(argument))");
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression2, (CallResolutionContext)Context2);
            if (typeInfoForCall.getType() == null) continue;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"argument");
            callback.invoke((Object)valueArgument, (Object)it);
        }
    }

    private final KotlinTypeInfo getArgumentTypeInfo(KtExpression expression2, CallResolutionContext<?> context) {
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (ktFunction != null) {
            KtFunction it = ktFunction;
            boolean bl = false;
            KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression2, it, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, false);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"argumentTypeResolver.get\u2026UNCTION_ARGUMENTS, false)");
            return kotlinTypeInfo;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context);
        if (ktCallableReferenceExpression != null) {
            KtCallableReferenceExpression it = ktCallableReferenceExpression;
            boolean bl = false;
            KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getCallableReferenceTypeInfo(expression2, it, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"argumentTypeResolver.get\u2026SOLVE_FUNCTION_ARGUMENTS)");
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, context);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"expressionTypingServices\u2026Info(expression, context)");
        return kotlinTypeInfo;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport$BuilderInferenceTypeCheckerState;", "Lorg/jetbrains/kotlin/types/checker/ClassicTypeCheckerState;", "allowOnlyTrivialConstraints", "", "(Z)V", "addSubtypeConstraint", "subType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "superType", "isFromNullabilityConstraint", "(Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Z)Ljava/lang/Boolean;", "frontend"})
    private static final class BuilderInferenceTypeCheckerState
    extends ClassicTypeCheckerState {
        private final boolean allowOnlyTrivialConstraints;

        public BuilderInferenceTypeCheckerState(boolean allowOnlyTrivialConstraints) {
            super(true, false, null, null, null, 30, null);
            this.allowOnlyTrivialConstraints = allowOnlyTrivialConstraints;
        }

        @Override
        @Nullable
        public Boolean addSubtypeConstraint(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType2, boolean isFromNullabilityConstraint) {
            block3: {
                TypeTemplate typeTemplate;
                Object object;
                Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
                Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
                if (!(subType instanceof UnwrappedType)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (!(superType2 instanceof UnwrappedType)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                TypeTemplate typeTemplate2 = subType instanceof TypeTemplate ? (TypeTemplate)subType : null;
                if (typeTemplate2 == null) {
                    typeTemplate2 = superType2 instanceof TypeTemplate ? (TypeTemplate)superType2 : null;
                }
                if ((object = (typeTemplate = typeTemplate2)) == null || (object = ((TypeTemplate)object).getBuilderInferenceData()) == null) break block3;
                ((BuilderInferenceData)object).addConstraint$frontend((KotlinType)subType, (KotlinType)superType2, this.allowOnlyTrivialConstraints);
            }
            return null;
        }
    }
}

