/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayArgumentValidator;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayAndElementArgumentValidator
extends ArrayArgumentValidator {
    public static final ArgumentsValidator DEFAULT_INSTANCE = new ArrayAndElementArgumentValidator(0, 1);
    private final int[] elementIndexes;

    public ArrayAndElementArgumentValidator(int arrayIndex, int ... elementIndexes) {
        super(arrayIndex);
        this.elementIndexes = elementIndexes;
    }

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        BasicType<?> expectedElementType = this.getElementType(arguments, functionName, typeConfiguration);
        for (int elementIndex : this.elementIndexes) {
            if (elementIndex >= arguments.size()) continue;
            SqmTypedNode<?> elementArgument = arguments.get(elementIndex);
            DomainType<?> elementType = elementArgument.getExpressible().getSqmType();
            if (expectedElementType == null || elementType == null || expectedElementType == elementType) continue;
            throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' has type %s, but argument is of type '%s'", elementIndex, functionName, expectedElementType.getJavaTypeDescriptor().getTypeName(), elementType.getTypeName()));
        }
    }
}

