/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.system.applicationtemplates;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.applicationtemplates.SystemTemplate;
import org.opensearch.cluster.applicationtemplates.SystemTemplateMetadata;
import org.opensearch.cluster.applicationtemplates.SystemTemplateRepository;
import org.opensearch.cluster.applicationtemplates.TemplateRepositoryMetadata;
import org.opensearch.common.util.io.Streams;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;

public class LocalSystemTemplateRepository
implements SystemTemplateRepository {
    private static final Logger logger = LogManager.getLogger(LocalSystemTemplateRepository.class);
    static final String REPOSITORY_ID = "__core__";
    static final long CURRENT_REPO_VERSION = 1L;

    public TemplateRepositoryMetadata metadata() {
        return new TemplateRepositoryMetadata(REPOSITORY_ID, 1L);
    }

    public Iterable<SystemTemplateMetadata> listTemplates() throws IOException {
        ArrayList<SystemTemplateMetadata> templateMetadataList = new ArrayList<SystemTemplateMetadata>();
        try (InputStream is = this.getResourceAsStream("templates.json");
             XContentParser listParser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, is);){
            while (listParser.currentToken() != XContentParser.Token.START_ARRAY) {
                listParser.nextToken();
            }
            if (!"templates".equals(listParser.currentName())) {
                throw new IllegalArgumentException("Format of template metadata file does not match expected format");
            }
            while (listParser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (listParser.currentToken() != XContentParser.Token.START_OBJECT) {
                    throw new IllegalArgumentException("Format of template metadata file does not match expected format" + String.valueOf(listParser.currentToken()));
                }
                String templateName = null;
                String templateType = null;
                long templateVersion = 0L;
                String name = null;
                while (listParser.nextToken() != XContentParser.Token.END_OBJECT) {
                    XContentParser.Token currentToken = listParser.currentToken();
                    if (currentToken == XContentParser.Token.FIELD_NAME) {
                        name = listParser.currentName();
                        continue;
                    }
                    if (currentToken == XContentParser.Token.VALUE_STRING) {
                        if ("name".equals(name)) {
                            templateName = listParser.text();
                            continue;
                        }
                        if ("type".equals(name)) {
                            templateType = listParser.text();
                            continue;
                        }
                        throw new IllegalArgumentException("Unexpected token " + String.valueOf(currentToken));
                    }
                    if (currentToken == XContentParser.Token.VALUE_NUMBER) {
                        if ("version".equals(name)) {
                            templateVersion = listParser.longValue();
                            continue;
                        }
                        throw new IllegalArgumentException("Unexpected token " + String.valueOf(currentToken));
                    }
                    throw new IllegalArgumentException("Unexpected token " + String.valueOf(currentToken));
                }
                if (templateName == null || templateType == null || templateVersion == 0L) {
                    throw new IllegalArgumentException("Could not read template metadata: [name: " + templateName + " , type: " + templateType + " , version: " + templateVersion);
                }
                templateMetadataList.add(new SystemTemplateMetadata(templateVersion, templateType, templateName));
            }
        }
        catch (Exception ex) {
            throw new IOException("Could not load system templates: ", ex);
        }
        return templateMetadataList;
    }

    public SystemTemplate getTemplate(SystemTemplateMetadata templateMetadata) throws IOException {
        String fileName = LocalSystemTemplateRepository.buildFileName(templateMetadata);
        logger.debug("Loading {} from file: {}", (Object)templateMetadata, (Object)fileName);
        try (InputStream is = this.getResourceAsStream(fileName);){
            if (is != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy((InputStream)is, (OutputStream)out);
                BytesArray templateContent = new BytesArray(out.toByteArray());
                SystemTemplate systemTemplate = new SystemTemplate((BytesReference)templateContent, templateMetadata, this.metadata());
                return systemTemplate;
            }
            throw new IOException("Unable to read: " + String.valueOf(templateMetadata) + " from repository: " + String.valueOf(this.metadata()));
        }
    }

    static String buildFileName(SystemTemplateMetadata templateMetadata) {
        return "v" + templateMetadata.version() + "/" + templateMetadata.name() + ".json";
    }

    protected InputStream getResourceAsStream(String name) throws IOException {
        return LocalSystemTemplateRepository.class.getResourceAsStream(name);
    }

    public void close() throws IOException {
    }
}

