/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.QueryGroup;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.monitor.jvm.JvmStats;
import org.opensearch.monitor.process.ProcessProbe;
import org.opensearch.search.backpressure.trackers.NodeDuressTrackers;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskResourceTrackingService;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.wlm.MutableQueryGroupFragment;
import org.opensearch.wlm.QueryGroupTask;
import org.opensearch.wlm.QueryGroupsStateAccessor;
import org.opensearch.wlm.ResourceType;
import org.opensearch.wlm.WlmMode;
import org.opensearch.wlm.WorkloadManagementSettings;
import org.opensearch.wlm.cancellation.QueryGroupTaskCancellationService;
import org.opensearch.wlm.stats.QueryGroupState;
import org.opensearch.wlm.stats.QueryGroupStats;
import org.opensearch.wlm.tracker.QueryGroupResourceUsageTrackerService;

public class QueryGroupService
extends AbstractLifecycleComponent
implements ClusterStateListener,
TaskResourceTrackingService.TaskCompletionListener {
    private static final Logger logger = LogManager.getLogger(QueryGroupService.class);
    private final QueryGroupTaskCancellationService taskCancellationService;
    private volatile Scheduler.Cancellable scheduledFuture;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final WorkloadManagementSettings workloadManagementSettings;
    private Set<QueryGroup> activeQueryGroups;
    private final Set<QueryGroup> deletedQueryGroups;
    private final NodeDuressTrackers nodeDuressTrackers;
    private final QueryGroupsStateAccessor queryGroupsStateAccessor;

    public QueryGroupService(QueryGroupTaskCancellationService taskCancellationService, ClusterService clusterService, ThreadPool threadPool, WorkloadManagementSettings workloadManagementSettings, QueryGroupsStateAccessor queryGroupsStateAccessor) {
        this(taskCancellationService, clusterService, threadPool, workloadManagementSettings, new NodeDuressTrackers(Map.of(ResourceType.CPU, new NodeDuressTrackers.NodeDuressTracker(() -> workloadManagementSettings.getNodeLevelCpuCancellationThreshold() < (double)ProcessProbe.getInstance().getProcessCpuPercent() / 100.0, workloadManagementSettings::getDuressStreak), ResourceType.MEMORY, new NodeDuressTrackers.NodeDuressTracker(() -> workloadManagementSettings.getNodeLevelMemoryCancellationThreshold() <= (double)JvmStats.jvmStats().getMem().getHeapUsedPercent() / 100.0, workloadManagementSettings::getDuressStreak))), queryGroupsStateAccessor, new HashSet<QueryGroup>(), new HashSet<QueryGroup>());
    }

    public QueryGroupService(QueryGroupTaskCancellationService taskCancellationService, ClusterService clusterService, ThreadPool threadPool, WorkloadManagementSettings workloadManagementSettings, NodeDuressTrackers nodeDuressTrackers, QueryGroupsStateAccessor queryGroupsStateAccessor, Set<QueryGroup> activeQueryGroups, Set<QueryGroup> deletedQueryGroups) {
        this.taskCancellationService = taskCancellationService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.workloadManagementSettings = workloadManagementSettings;
        this.nodeDuressTrackers = nodeDuressTrackers;
        this.activeQueryGroups = activeQueryGroups;
        this.deletedQueryGroups = deletedQueryGroups;
        this.queryGroupsStateAccessor = queryGroupsStateAccessor;
        activeQueryGroups.forEach(queryGroup -> this.queryGroupsStateAccessor.addNewQueryGroup(queryGroup.get_id()));
        this.queryGroupsStateAccessor.addNewQueryGroup(QueryGroupTask.DEFAULT_QUERY_GROUP_ID_SUPPLIER.get());
        this.clusterService.addListener(this);
    }

    void doRun() {
        if (this.workloadManagementSettings.getWlmMode() == WlmMode.DISABLED) {
            return;
        }
        this.taskCancellationService.cancelTasks(this.nodeDuressTrackers::isNodeInDuress, this.activeQueryGroups, this.deletedQueryGroups);
        this.taskCancellationService.pruneDeletedQueryGroups(this.deletedQueryGroups);
    }

    protected void doStart() {
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(() -> {
            try {
                this.doRun();
            }
            catch (Exception e) {
                logger.debug("Exception occurred in Query Sandbox service", (Throwable)e);
            }
        }, this.workloadManagementSettings.getQueryGroupServiceRunInterval(), "generic");
    }

    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel();
        }
    }

    protected void doClose() throws IOException {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        Metadata previousMetadata = event.previousState().metadata();
        Metadata currentMetadata = event.state().metadata();
        Map<String, QueryGroup> previousQueryGroups = previousMetadata.queryGroups();
        Map<String, QueryGroup> currentQueryGroups = currentMetadata.queryGroups();
        for (String queryGroupName : currentQueryGroups.keySet()) {
            if (previousQueryGroups.containsKey(queryGroupName)) continue;
            QueryGroup newQueryGroup = currentQueryGroups.get(queryGroupName);
            this.queryGroupsStateAccessor.addNewQueryGroup(newQueryGroup.get_id());
        }
        for (String queryGroupName : previousQueryGroups.keySet()) {
            if (currentQueryGroups.containsKey(queryGroupName)) continue;
            QueryGroup deletedQueryGroup = previousQueryGroups.get(queryGroupName);
            this.deletedQueryGroups.add(deletedQueryGroup);
            this.queryGroupsStateAccessor.removeQueryGroup(deletedQueryGroup.get_id());
        }
        this.activeQueryGroups = new HashSet<QueryGroup>(currentMetadata.queryGroups().values());
    }

    public void incrementFailuresFor(String queryGroupId) {
        QueryGroupState queryGroupState = this.queryGroupsStateAccessor.getQueryGroupState(queryGroupId);
        if (queryGroupState == null) {
            return;
        }
        queryGroupState.failures.inc();
    }

    public QueryGroupStats nodeStats(Set<String> queryGroupIds, Boolean requestedBreached) {
        HashMap<String, QueryGroupStats.QueryGroupStatsHolder> statsHolderMap = new HashMap<String, QueryGroupStats.QueryGroupStatsHolder>();
        Map<String, QueryGroupState> existingStateMap = this.queryGroupsStateAccessor.getQueryGroupStateMap();
        if (!queryGroupIds.contains("_all")) {
            for (String id : queryGroupIds) {
                if (existingStateMap.containsKey(id)) continue;
                throw new ResourceNotFoundException("QueryGroup with id " + id + " does not exist", new Object[0]);
            }
        }
        if (existingStateMap != null) {
            existingStateMap.forEach((queryGroupId, currentState) -> {
                boolean shouldInclude;
                boolean bl = shouldInclude = queryGroupIds.contains("_all") || queryGroupIds.contains(queryGroupId);
                if (shouldInclude && (requestedBreached == null || requestedBreached.booleanValue() == this.resourceLimitBreached((String)queryGroupId, (QueryGroupState)currentState))) {
                    statsHolderMap.put((String)queryGroupId, QueryGroupStats.QueryGroupStatsHolder.from(currentState));
                }
            });
        }
        return new QueryGroupStats(statsHolderMap);
    }

    public boolean resourceLimitBreached(String id, QueryGroupState currentState) {
        QueryGroup queryGroup = this.clusterService.state().metadata().queryGroups().get(id);
        if (queryGroup == null) {
            throw new ResourceNotFoundException("QueryGroup with id " + id + " does not exist", new Object[0]);
        }
        for (ResourceType resourceType : QueryGroupResourceUsageTrackerService.TRACKED_RESOURCES) {
            double lastRecordedUsage;
            double threshold;
            if (!queryGroup.getResourceLimits().containsKey((Object)resourceType) || !((threshold = this.getNormalisedRejectionThreshold(queryGroup.getResourceLimits().get((Object)resourceType), resourceType)) < (lastRecordedUsage = currentState.getResourceState().get((Object)resourceType).getLastRecordedUsage()))) continue;
            return true;
        }
        return false;
    }

    public void rejectIfNeeded(String queryGroupId) {
        if (this.workloadManagementSettings.getWlmMode() != WlmMode.ENABLED) {
            return;
        }
        if (queryGroupId == null || queryGroupId.equals(QueryGroupTask.DEFAULT_QUERY_GROUP_ID_SUPPLIER.get())) {
            return;
        }
        QueryGroupState queryGroupState = this.queryGroupsStateAccessor.getQueryGroupState(queryGroupId);
        if (queryGroupState == null) {
            return;
        }
        Optional<QueryGroup> optionalQueryGroup = this.activeQueryGroups.stream().filter(x -> x.get_id().equals(queryGroupId)).findFirst();
        if (optionalQueryGroup.isPresent() && optionalQueryGroup.get().getResiliencyMode() == MutableQueryGroupFragment.ResiliencyMode.SOFT && !this.nodeDuressTrackers.isNodeInDuress()) {
            return;
        }
        optionalQueryGroup.ifPresent(queryGroup -> {
            boolean reject = false;
            StringBuilder reason = new StringBuilder();
            for (ResourceType resourceType : QueryGroupResourceUsageTrackerService.TRACKED_RESOURCES) {
                double lastRecordedUsage;
                double threshold;
                if (!queryGroup.getResourceLimits().containsKey((Object)resourceType) || !((threshold = this.getNormalisedRejectionThreshold(queryGroup.getResourceLimits().get((Object)resourceType), resourceType)) < (lastRecordedUsage = queryGroupState.getResourceState().get((Object)resourceType).getLastRecordedUsage()))) continue;
                reject = true;
                reason.append((Object)resourceType).append(" limit is breaching for ENFORCED type QueryGroup: (").append(threshold).append(" < ").append(lastRecordedUsage).append("). ");
                queryGroupState.getResourceState().get((Object)((Object)((Object)resourceType))).rejections.inc();
                break;
            }
            if (reject) {
                queryGroupState.totalRejections.inc();
                throw new OpenSearchRejectedExecutionException("QueryGroup " + queryGroupId + " is already contended. " + reason.toString());
            }
        });
    }

    private double getNormalisedRejectionThreshold(double limit, ResourceType resourceType) {
        if (resourceType == ResourceType.CPU) {
            return limit * this.workloadManagementSettings.getNodeLevelCpuRejectionThreshold();
        }
        if (resourceType == ResourceType.MEMORY) {
            return limit * this.workloadManagementSettings.getNodeLevelMemoryRejectionThreshold();
        }
        throw new IllegalArgumentException(String.valueOf((Object)resourceType) + " is not supported in WLM yet");
    }

    public Set<QueryGroup> getActiveQueryGroups() {
        return this.activeQueryGroups;
    }

    public Set<QueryGroup> getDeletedQueryGroups() {
        return this.deletedQueryGroups;
    }

    public boolean shouldSBPHandle(Task t) {
        QueryGroupTask task = (QueryGroupTask)t;
        boolean isInvalidQueryGroupTask = true;
        if (!task.getQueryGroupId().equals(QueryGroupTask.DEFAULT_QUERY_GROUP_ID_SUPPLIER.get())) {
            isInvalidQueryGroupTask = this.activeQueryGroups.stream().noneMatch(queryGroup -> queryGroup.get_id().equals(task.getQueryGroupId()));
        }
        return this.workloadManagementSettings.getWlmMode() != WlmMode.ENABLED || isInvalidQueryGroupTask;
    }

    @Override
    public void onTaskCompleted(Task task) {
        String queryGroupId;
        if (!(task instanceof QueryGroupTask)) {
            return;
        }
        QueryGroupTask queryGroupTask = (QueryGroupTask)task;
        String finalQueryGroupId = queryGroupId = queryGroupTask.getQueryGroupId();
        boolean exists = this.activeQueryGroups.stream().anyMatch(queryGroup -> queryGroup.get_id().equals(finalQueryGroupId));
        if (!exists) {
            queryGroupId = QueryGroupTask.DEFAULT_QUERY_GROUP_ID_SUPPLIER.get();
        }
        this.queryGroupsStateAccessor.getQueryGroupState((String)queryGroupId).totalCompletions.inc();
    }
}

