/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import java.net.URL;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.securityanalytics.threatIntel.model.Source;

public class UrlDownloadSource
extends Source
implements Writeable,
ToXContent {
    public static final String URL_FIELD = "url";
    public static final String FEED_FORMAT_FIELD = "feed_format";
    public static final String HAS_CSV_HEADER_FIELD = "has_csv_header_field";
    public static final String CSV_IOC_VALUE_COLUMN_NUM_FIELD = "csv_ioc_value_colum_num";
    public static final String SOURCE_NAME = "URL_DOWNLOAD";
    private final URL url;
    private final String feedFormat;
    private final Boolean hasCsvHeader;
    private final Integer csvIocValueColumnNo;

    public UrlDownloadSource(URL url, String feedFormat, Boolean hasCsvHeader, Integer csvIocValueColumnNo) {
        this.url = url;
        this.feedFormat = feedFormat;
        this.hasCsvHeader = hasCsvHeader;
        this.csvIocValueColumnNo = csvIocValueColumnNo;
    }

    public UrlDownloadSource(StreamInput sin) throws IOException {
        this(new URL(sin.readString()), sin.readString(), sin.readOptionalBoolean(), sin.readOptionalInt());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.url.toString());
        out.writeString(this.feedFormat);
        out.writeOptionalBoolean(this.hasCsvHeader);
        out.writeOptionalInt(this.csvIocValueColumnNo);
    }

    @Override
    String name() {
        return SOURCE_NAME;
    }

    public URL getUrl() {
        return this.url;
    }

    public static UrlDownloadSource parse(XContentParser xcp) throws IOException {
        URL url = null;
        String feedFormat = null;
        Boolean hasCsvHeader = false;
        Integer csvIocValueColumnNo = null;
        block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "url": {
                    String urlString = xcp.text();
                    url = new URL(urlString);
                    continue block12;
                }
                case "feed_format": {
                    feedFormat = xcp.text();
                    continue block12;
                }
                case "has_csv_header_field": {
                    hasCsvHeader = xcp.booleanValue();
                    continue block12;
                }
                case "csv_ioc_value_colum_num": {
                    if (xcp.currentToken() == null) {
                        xcp.skipChildren();
                        continue block12;
                    }
                    csvIocValueColumnNo = xcp.intValue();
                    continue block12;
                }
            }
            xcp.skipChildren();
        }
        return new UrlDownloadSource(url, feedFormat, hasCsvHeader, csvIocValueColumnNo);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().startObject("url_download").field(URL_FIELD, this.url.toString()).field(FEED_FORMAT_FIELD, this.feedFormat).field(HAS_CSV_HEADER_FIELD, this.hasCsvHeader).field(CSV_IOC_VALUE_COLUMN_NUM_FIELD, this.csvIocValueColumnNo).endObject().endObject();
    }

    public String getFeedFormat() {
        return this.feedFormat;
    }

    public boolean hasCsvHeader() {
        return this.hasCsvHeader;
    }

    public Integer getCsvIocValueColumnNo() {
        return this.csvIocValueColumnNo;
    }
}

