/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Job;

public class SecurityUtil {
    private static User getAdjustedUserBWC(User userObj, Settings settings) {
        if (userObj == null) {
            String user = "";
            List roles = settings.getAsList("", (List)ImmutableList.of((Object)"all_access", (Object)"AmazonES_all_access"));
            return new User(user, Collections.emptyList(), roles, Collections.emptyList());
        }
        return userObj;
    }

    public static User getUserFromConfig(Config config, Settings settings) {
        return SecurityUtil.getAdjustedUserBWC(config.getUser(), settings);
    }

    public static User getUserFromJob(Job detectorJob, Settings settings) {
        return SecurityUtil.getAdjustedUserBWC(detectorJob.getUser(), settings);
    }
}

