/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.logging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.opensearch.common.Nullable;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.SearchExtBuilder;

public class LoggingSearchExtBuilder
extends SearchExtBuilder {
    public static final String NAME = "ltr_log";
    private static final ObjectParser<LoggingSearchExtBuilder, Void> PARSER;
    private static final ParseField LOG_SPECS;
    private List<LogSpec> logSpecs;

    public LoggingSearchExtBuilder() {
    }

    public LoggingSearchExtBuilder(StreamInput input) throws IOException {
        this.logSpecs = input.readList(x$0 -> new LogSpec(x$0));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.logSpecs);
    }

    public String getWriteableName() {
        return NAME;
    }

    public static LoggingSearchExtBuilder parse(XContentParser parser) throws IOException {
        try {
            LoggingSearchExtBuilder ext = (LoggingSearchExtBuilder)((Object)PARSER.parse(parser, null));
            if (ext.logSpecs == null || ext.logSpecs.isEmpty()) {
                throw new ParsingException(parser.getTokenLocation(), "[ltr_log] should define at least one [" + String.valueOf(LOG_SPECS) + "]", new Object[0]);
            }
            return ext;
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException(parser.getTokenLocation(), iae.getMessage(), (Throwable)iae, new Object[0]);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LOG_SPECS.getPreferredName(), this.logSpecs);
        return builder.endObject();
    }

    public Stream<LogSpec> logSpecsStream() {
        return this.logSpecs.stream();
    }

    private void setLogSpecs(List<LogSpec> logSpecs) {
        this.logSpecs = logSpecs;
    }

    public LoggingSearchExtBuilder addQueryLogging(String name, String namedQuery, boolean missingAsZero) {
        this.addLogSpec(new LogSpec(name, Objects.requireNonNull(namedQuery), missingAsZero));
        return this;
    }

    public LoggingSearchExtBuilder addRescoreLogging(String name, int rescoreIndex, boolean missingAsZero) {
        this.addLogSpec(new LogSpec(name, rescoreIndex, missingAsZero));
        return this;
    }

    private void addLogSpec(LogSpec spec) {
        if (this.logSpecs == null) {
            this.logSpecs = new ArrayList<LogSpec>();
        }
        this.logSpecs.add(spec);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.logSpecs);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingSearchExtBuilder)) {
            return false;
        }
        LoggingSearchExtBuilder o = (LoggingSearchExtBuilder)((Object)obj);
        return Objects.equals(this.logSpecs, o.logSpecs);
    }

    static {
        LOG_SPECS = new ParseField("log_specs", new String[0]);
        PARSER = new ObjectParser(NAME, LoggingSearchExtBuilder::new);
        PARSER.declareObjectArray(LoggingSearchExtBuilder::setLogSpecs, (x$0, x$1) -> LogSpec.parse(x$0, x$1), LOG_SPECS);
    }

    public static class LogSpec
    implements Writeable,
    ToXContentObject {
        private static final ParseField LOGGER_NAME = new ParseField("name", new String[0]);
        private static final ParseField NAMED_QUERY = new ParseField("named_query", new String[0]);
        private static final ParseField RESCORE_INDEX = new ParseField("rescore_index", new String[0]);
        private static final ParseField MISSING_AS_ZERO = new ParseField("missing_as_zero", new String[0]);
        private static final ObjectParser<LogSpec, Void> PARSER = new ObjectParser("spec", LogSpec::new);
        private String loggerName;
        private String namedQuery;
        private Integer rescoreIndex;
        private boolean missingAsZero;

        private LogSpec() {
        }

        LogSpec(@Nullable String loggerName, String namedQuery, boolean missingAsZero) {
            this.loggerName = loggerName;
            this.namedQuery = Objects.requireNonNull(namedQuery);
            this.missingAsZero = missingAsZero;
        }

        LogSpec(@Nullable String loggerName, int rescoreIndex, boolean missingAsZero) {
            this.loggerName = loggerName;
            this.rescoreIndex = rescoreIndex;
            this.missingAsZero = missingAsZero;
        }

        private LogSpec(StreamInput input) throws IOException {
            this.loggerName = input.readOptionalString();
            this.namedQuery = input.readOptionalString();
            this.rescoreIndex = input.readOptionalVInt();
            this.missingAsZero = input.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.loggerName);
            out.writeOptionalString(this.namedQuery);
            out.writeOptionalVInt(this.rescoreIndex);
            out.writeBoolean(this.missingAsZero);
        }

        private static LogSpec parse(XContentParser parser, Void context) throws IOException {
            try {
                LogSpec spec = (LogSpec)PARSER.parse(parser, null);
                if (spec.namedQuery == null && spec.rescoreIndex == null) {
                    throw new ParsingException(parser.getTokenLocation(), "Either [" + String.valueOf(NAMED_QUERY) + "] or [" + String.valueOf(RESCORE_INDEX) + "] must be set.", new Object[0]);
                }
                if (spec.rescoreIndex != null && spec.rescoreIndex < 0) {
                    throw new ParsingException(parser.getTokenLocation(), "[" + String.valueOf(RESCORE_INDEX) + "] must be a non-negative integer.", new Object[0]);
                }
                return spec;
            }
            catch (IllegalArgumentException iae) {
                throw new ParsingException(parser.getTokenLocation(), iae.getMessage(), (Throwable)iae, new Object[0]);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.loggerName != null) {
                builder.field(LOGGER_NAME.getPreferredName(), this.loggerName);
            }
            if (this.namedQuery != null) {
                builder.field(NAMED_QUERY.getPreferredName(), this.namedQuery);
            } else if (this.rescoreIndex != null) {
                builder.field(RESCORE_INDEX.getPreferredName(), this.rescoreIndex);
            }
            if (this.missingAsZero) {
                builder.field(MISSING_AS_ZERO.getPreferredName(), this.missingAsZero);
            }
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogSpec logSpec = (LogSpec)o;
            if (this.missingAsZero != logSpec.missingAsZero) {
                return false;
            }
            if (this.loggerName != null ? !this.loggerName.equals(logSpec.loggerName) : logSpec.loggerName != null) {
                return false;
            }
            if (this.namedQuery != null ? !this.namedQuery.equals(logSpec.namedQuery) : logSpec.namedQuery != null) {
                return false;
            }
            return this.rescoreIndex != null ? this.rescoreIndex.equals(logSpec.rescoreIndex) : logSpec.rescoreIndex == null;
        }

        public int hashCode() {
            int result = this.loggerName != null ? this.loggerName.hashCode() : 0;
            result = 31 * result + (this.namedQuery != null ? this.namedQuery.hashCode() : 0);
            result = 31 * result + (this.rescoreIndex != null ? this.rescoreIndex.hashCode() : 0);
            result = 31 * result + (this.missingAsZero ? 1 : 0);
            return result;
        }

        public String getNamedQuery() {
            return this.namedQuery;
        }

        private void setNamedQuery(String namedQuery) {
            this.namedQuery = namedQuery;
        }

        public Integer getRescoreIndex() {
            return this.rescoreIndex;
        }

        private void setRescoreIndex(Integer rescoreIndex) {
            this.rescoreIndex = rescoreIndex;
        }

        public String getLoggerName() {
            if (this.loggerName != null) {
                return this.loggerName;
            }
            return this.namedQuery != null ? this.namedQuery : "rescore[" + this.rescoreIndex + "]";
        }

        private void setLoggerName(String loggerName) {
            this.loggerName = loggerName;
        }

        public boolean isMissingAsZero() {
            return this.missingAsZero;
        }

        private void setMissingAsZero(boolean missingAsZero) {
            this.missingAsZero = missingAsZero;
        }

        static {
            PARSER.declareString(LogSpec::setLoggerName, LOGGER_NAME);
            PARSER.declareString(LogSpec::setNamedQuery, NAMED_QUERY);
            PARSER.declareInt(LogSpec::setRescoreIndex, RESCORE_INDEX);
            PARSER.declareBoolean(LogSpec::setMissingAsZero, MISSING_AS_ZERO);
        }
    }
}

