/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.flow_units;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.grpc.HotNodeSummaryMessage;
import org.opensearch.performanceanalyzer.grpc.Resource;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class NodeConfigFlowUnit
extends ResourceFlowUnit<HotNodeSummary> {
    private final HashMap<Resource, HotResourceSummary> configMap;

    public NodeConfigFlowUnit(long timeStamp) {
        super(timeStamp);
        this.configMap = new HashMap();
    }

    public NodeConfigFlowUnit(long timeStamp, NodeKey nodeKey) {
        super(timeStamp, new ResourceContext(Resources.State.HEALTHY), null, false);
        this.setSummary(new HotNodeSummary(nodeKey.getNodeId(), nodeKey.getHostAddress()));
        this.configMap = new HashMap();
    }

    public void addConfig(Resource resource, double value) {
        HotResourceSummary configSummary = new HotResourceSummary(resource, Double.NaN, value, 0);
        this.configMap.put(resource, configSummary);
    }

    public void addConfig(HotResourceSummary configSummary) {
        this.configMap.put(configSummary.getResource(), configSummary);
    }

    public boolean hasConfig(Resource resource) {
        return this.configMap.containsKey(resource);
    }

    public double readConfig(Resource resource) {
        HotResourceSummary configSummary = this.configMap.getOrDefault(resource, null);
        if (configSummary == null) {
            return Double.NaN;
        }
        return configSummary.getValue();
    }

    public List<Resource> getConfigList() {
        return new ArrayList<Resource>(this.configMap.keySet());
    }

    @Override
    public boolean isEmpty() {
        return this.configMap.isEmpty();
    }

    @Override
    public FlowUnitMessage buildFlowUnitMessage(String graphNode, InstanceDetails.Id node) {
        this.configMap.values().forEach(resourceSummary -> ((HotNodeSummary)this.getSummary()).appendNestedSummary((HotResourceSummary)resourceSummary));
        return super.buildFlowUnitMessage(graphNode, node);
    }

    public static NodeConfigFlowUnit buildFlowUnitFromWrapper(FlowUnitMessage message) {
        NodeConfigFlowUnit nodeConfigFlowUnit;
        if (message.getSummaryOneofCase() == FlowUnitMessage.SummaryOneofCase.HOTNODESUMMARY) {
            HotNodeSummaryMessage nodeSummaryMessage = message.getHotNodeSummary();
            NodeKey nodeKey = new NodeKey(new InstanceDetails.Id(nodeSummaryMessage.getNodeID()), new InstanceDetails.Ip(nodeSummaryMessage.getHostAddress()));
            nodeConfigFlowUnit = new NodeConfigFlowUnit(message.getTimeStamp(), nodeKey);
            if (nodeSummaryMessage.hasHotResourceSummaryList()) {
                for (int i = 0; i < nodeSummaryMessage.getHotResourceSummaryList().getHotResourceSummaryCount(); ++i) {
                    nodeConfigFlowUnit.addConfig(HotResourceSummary.buildHotResourceSummaryFromMessage(nodeSummaryMessage.getHotResourceSummaryList().getHotResourceSummary(i)));
                }
            }
        } else {
            nodeConfigFlowUnit = new NodeConfigFlowUnit(message.getTimeStamp());
        }
        return nodeConfigFlowUnit;
    }
}

