/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECDHCurveSpec;

public class ValidatePublicKeyInput {
    private final ECDHCurveSpec eccCurve;
    private final ByteBuffer publicKey;

    protected ValidatePublicKeyInput(BuilderImpl builder) {
        this.eccCurve = builder.eccCurve();
        this.publicKey = builder.publicKey();
    }

    public ECDHCurveSpec eccCurve() {
        return this.eccCurve;
    }

    public ByteBuffer publicKey() {
        return this.publicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECDHCurveSpec eccCurve;
        protected ByteBuffer publicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ValidatePublicKeyInput model) {
            this.eccCurve = model.eccCurve();
            this.publicKey = model.publicKey();
        }

        @Override
        public Builder eccCurve(ECDHCurveSpec eccCurve) {
            this.eccCurve = eccCurve;
            return this;
        }

        @Override
        public ECDHCurveSpec eccCurve() {
            return this.eccCurve;
        }

        @Override
        public Builder publicKey(ByteBuffer publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public ByteBuffer publicKey() {
            return this.publicKey;
        }

        @Override
        public ValidatePublicKeyInput build() {
            if (Objects.isNull((Object)this.eccCurve())) {
                throw new IllegalArgumentException("Missing value for required field `eccCurve`");
            }
            if (Objects.isNull(this.publicKey())) {
                throw new IllegalArgumentException("Missing value for required field `publicKey`");
            }
            return new ValidatePublicKeyInput(this);
        }
    }

    public static interface Builder {
        public Builder eccCurve(ECDHCurveSpec var1);

        public ECDHCurveSpec eccCurve();

        public Builder publicKey(ByteBuffer var1);

        public ByteBuffer publicKey();

        public ValidatePublicKeyInput build();
    }
}

