/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.services.kms.internaldafny.types;

import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.services.kms.internaldafny.types.AttestationDocumentType;
import software.amazon.cryptography.services.kms.internaldafny.types.KeyEncryptionMechanism;

public class RecipientInfo {
    public Option<KeyEncryptionMechanism> _KeyEncryptionAlgorithm;
    public Option<DafnySequence<? extends Byte>> _AttestationDocument;
    private static final TypeDescriptor<RecipientInfo> _TYPE = TypeDescriptor.referenceWithInitializer(RecipientInfo.class, () -> RecipientInfo.Default());
    private static final RecipientInfo theDefault = RecipientInfo.create(Option.Default(KeyEncryptionMechanism._typeDescriptor()), Option.Default(AttestationDocumentType._typeDescriptor()));

    public RecipientInfo(Option<KeyEncryptionMechanism> KeyEncryptionAlgorithm, Option<DafnySequence<? extends Byte>> AttestationDocument) {
        this._KeyEncryptionAlgorithm = KeyEncryptionAlgorithm;
        this._AttestationDocument = AttestationDocument;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        RecipientInfo o = (RecipientInfo)other;
        return Objects.equals(this._KeyEncryptionAlgorithm, o._KeyEncryptionAlgorithm) && Objects.equals(this._AttestationDocument, o._AttestationDocument);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._KeyEncryptionAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._AttestationDocument);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("ComAmazonawsKmsTypes.RecipientInfo.RecipientInfo");
        s.append("(");
        s.append(Helpers.toString(this._KeyEncryptionAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._AttestationDocument));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<RecipientInfo> _typeDescriptor() {
        return _TYPE;
    }

    public static RecipientInfo Default() {
        return theDefault;
    }

    public static RecipientInfo create(Option<KeyEncryptionMechanism> KeyEncryptionAlgorithm, Option<DafnySequence<? extends Byte>> AttestationDocument) {
        return new RecipientInfo(KeyEncryptionAlgorithm, AttestationDocument);
    }

    public static RecipientInfo create_RecipientInfo(Option<KeyEncryptionMechanism> KeyEncryptionAlgorithm, Option<DafnySequence<? extends Byte>> AttestationDocument) {
        return RecipientInfo.create(KeyEncryptionAlgorithm, AttestationDocument);
    }

    public boolean is_RecipientInfo() {
        return true;
    }

    public Option<KeyEncryptionMechanism> dtor_KeyEncryptionAlgorithm() {
        return this._KeyEncryptionAlgorithm;
    }

    public Option<DafnySequence<? extends Byte>> dtor_AttestationDocument() {
        return this._AttestationDocument;
    }
}

