/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public enum MetricType implements Comparator<Number>
{
    LATENCY,
    CPU,
    MEMORY;


    public static MetricType readFromStream(StreamInput in) throws IOException {
        return MetricType.fromString(in.readString());
    }

    public static MetricType fromString(String metricType) {
        return MetricType.valueOf(metricType.toUpperCase(Locale.ROOT));
    }

    public static void writeTo(StreamOutput out, MetricType metricType) throws IOException {
        out.writeString(metricType.toString());
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static Set<MetricType> allMetricTypes() {
        return Arrays.stream(MetricType.values()).collect(Collectors.toSet());
    }

    @Override
    public int compare(Number a, Number b) {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return Long.compare(a.longValue(), b.longValue());
            }
        }
        return -1;
    }

    Number parseValue(Object o) {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return (Long)o;
            }
        }
        return (Number)o;
    }
}

