/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.agent.tools.AbstractRetrieverTool;
import org.opensearch.client.Client;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.spi.tools.WithModelTool;

@ToolAnnotation(value="VectorDBTool")
public class VectorDBTool
extends AbstractRetrieverTool
implements WithModelTool {
    @Generated
    private static final Logger log = LogManager.getLogger(VectorDBTool.class);
    public static final String TYPE = "VectorDBTool";
    public static String DEFAULT_DESCRIPTION = "Use this tool to performs knn-based dense retrieval. It takes 1 argument named input which is a string query for dense retrieval. The tool returns the dense retrieval results for the query.";
    public static final String EMBEDDING_FIELD = "embedding_field";
    public static final String K_FIELD = "k";
    public static final Integer DEFAULT_K = 10;
    public static final String NESTED_PATH_FIELD = "nested_path";
    private String name = "VectorDBTool";
    private String modelId;
    private String embeddingField;
    private Integer k;
    private String nestedPath;

    public VectorDBTool(Client client, NamedXContentRegistry xContentRegistry, String index, String embeddingField, String[] sourceFields, Integer docSize, String modelId, Integer k, String nestedPath) {
        super(client, xContentRegistry, index, sourceFields, docSize);
        this.modelId = modelId;
        this.embeddingField = embeddingField;
        this.k = k;
        this.nestedPath = nestedPath;
    }

    @Override
    protected String getQueryBody(String queryText) {
        if (StringUtils.isBlank((CharSequence)this.embeddingField) || StringUtils.isBlank((CharSequence)this.modelId)) {
            throw new IllegalArgumentException("Parameter [embedding_field] and [model_id] can not be null or empty.");
        }
        Map<String, Map<String, Map<String, Map<String, Object>>>> queryBody = StringUtils.isBlank((CharSequence)this.nestedPath) ? Map.of("query", Map.of("neural", Map.of(this.embeddingField, Map.of("query_text", queryText, "model_id", this.modelId, K_FIELD, this.k)))) : Map.of("query", Map.of("nested", Map.of("path", this.nestedPath, "score_mode", "max", "query", Map.of("neural", Map.of(this.embeddingField, Map.of("query_text", queryText, "model_id", this.modelId, K_FIELD, this.k))))));
        try {
            return AccessController.doPrivileged(() -> org.opensearch.ml.common.utils.StringUtils.gson.toJson((Object)queryBody));
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public static VectorDBToolBuilder builder() {
        return new VectorDBToolBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getEmbeddingField() {
        return this.embeddingField;
    }

    @Generated
    public Integer getK() {
        return this.k;
    }

    @Generated
    public String getNestedPath() {
        return this.nestedPath;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setEmbeddingField(String embeddingField) {
        this.embeddingField = embeddingField;
    }

    @Generated
    public void setK(Integer k) {
        this.k = k;
    }

    @Generated
    public void setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
    }

    @Generated
    public static class VectorDBToolBuilder {
        @Generated
        private Client client;
        @Generated
        private NamedXContentRegistry xContentRegistry;
        @Generated
        private String index;
        @Generated
        private String embeddingField;
        @Generated
        private String[] sourceFields;
        @Generated
        private Integer docSize;
        @Generated
        private String modelId;
        @Generated
        private Integer k;
        @Generated
        private String nestedPath;

        @Generated
        VectorDBToolBuilder() {
        }

        @Generated
        public VectorDBToolBuilder client(Client client) {
            this.client = client;
            return this;
        }

        @Generated
        public VectorDBToolBuilder xContentRegistry(NamedXContentRegistry xContentRegistry) {
            this.xContentRegistry = xContentRegistry;
            return this;
        }

        @Generated
        public VectorDBToolBuilder index(String index) {
            this.index = index;
            return this;
        }

        @Generated
        public VectorDBToolBuilder embeddingField(String embeddingField) {
            this.embeddingField = embeddingField;
            return this;
        }

        @Generated
        public VectorDBToolBuilder sourceFields(String[] sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        @Generated
        public VectorDBToolBuilder docSize(Integer docSize) {
            this.docSize = docSize;
            return this;
        }

        @Generated
        public VectorDBToolBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public VectorDBToolBuilder k(Integer k) {
            this.k = k;
            return this;
        }

        @Generated
        public VectorDBToolBuilder nestedPath(String nestedPath) {
            this.nestedPath = nestedPath;
            return this;
        }

        @Generated
        public VectorDBTool build() {
            return new VectorDBTool(this.client, this.xContentRegistry, this.index, this.embeddingField, this.sourceFields, this.docSize, this.modelId, this.k, this.nestedPath);
        }

        @Generated
        public String toString() {
            return "VectorDBTool.VectorDBToolBuilder(client=" + String.valueOf(this.client) + ", xContentRegistry=" + String.valueOf(this.xContentRegistry) + ", index=" + this.index + ", embeddingField=" + this.embeddingField + ", sourceFields=" + Arrays.deepToString(this.sourceFields) + ", docSize=" + this.docSize + ", modelId=" + this.modelId + ", k=" + this.k + ", nestedPath=" + this.nestedPath + ")";
        }
    }

    public static class Factory
    extends AbstractRetrieverTool.Factory<VectorDBTool>
    implements WithModelTool.Factory<VectorDBTool> {
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<VectorDBTool> clazz = VectorDBTool.class;
            synchronized (VectorDBTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public VectorDBTool create(Map<String, Object> params) {
            String index = (String)params.get("index");
            String embeddingField = (String)params.get(VectorDBTool.EMBEDDING_FIELD);
            String[] sourceFields = (String[])org.opensearch.ml.common.utils.StringUtils.gson.fromJson((String)params.get("source_field"), String[].class);
            String modelId = (String)params.get("model_id");
            Integer docSize = params.containsKey("doc_size") ? Integer.parseInt((String)params.get("doc_size")) : 2;
            Integer k = params.containsKey(VectorDBTool.K_FIELD) ? Integer.parseInt((String)params.get(VectorDBTool.K_FIELD)) : DEFAULT_K;
            String nestedPath = (String)params.get(VectorDBTool.NESTED_PATH_FIELD);
            return VectorDBTool.builder().client(this.client).xContentRegistry(this.xContentRegistry).index(index).embeddingField(embeddingField).sourceFields(sourceFields).modelId(modelId).docSize(docSize).k(k).nestedPath(nestedPath).build();
        }

        public String getDefaultType() {
            return VectorDBTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        @Override
        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public List<String> getAllModelKeys() {
            return List.of("model_id");
        }
    }
}

