/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.flowframework.common.CommonValue;

public class GetWorkflowStateRequest
extends ActionRequest {
    @Nullable
    private String workflowId;
    private boolean all;
    private String tenantId;

    public GetWorkflowStateRequest(@Nullable String workflowId, boolean all, String tenantId) {
        this.workflowId = workflowId;
        this.all = all;
        this.tenantId = tenantId;
    }

    public GetWorkflowStateRequest(StreamInput in) throws IOException {
        super(in);
        this.workflowId = in.readString();
        this.all = in.readBoolean();
        if (in.getVersion().onOrAfter(CommonValue.VERSION_2_19_0)) {
            this.tenantId = in.readOptionalString();
        }
    }

    @Nullable
    public String getWorkflowId() {
        return this.workflowId;
    }

    public boolean getAll() {
        return this.all;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.workflowId);
        out.writeBoolean(this.all);
        if (out.getVersion().onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

