/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.transport.GetWorkflowResponse;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.util.EncryptorUtils;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.util.TenantAwareHelper;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetWorkflowTransportAction
extends HandledTransportAction<WorkflowRequest, GetWorkflowResponse> {
    private final Logger logger = LogManager.getLogger(GetWorkflowTransportAction.class);
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final FlowFrameworkSettings flowFrameworkSettings;
    private final Client client;
    private final SdkClient sdkClient;
    private final EncryptorUtils encryptorUtils;
    private volatile Boolean filterByEnabled;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public GetWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings, Client client, SdkClient sdkClient, EncryptorUtils encryptorUtils, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Settings settings) {
        super("cluster:admin/opensearch/flow_framework/workflow/get", transportService, actionFilters, WorkflowRequest::new);
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.flowFrameworkSettings = flowFrameworkSettings;
        this.client = client;
        this.sdkClient = sdkClient;
        this.encryptorUtils = encryptorUtils;
        this.filterByEnabled = (Boolean)FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<GetWorkflowResponse> listener) {
        if (this.flowFrameworkIndicesHandler.doesIndexExist(".plugins-flow-framework-templates")) {
            String tenantId;
            String string = tenantId = request.getTemplate() == null ? null : request.getTemplate().getTenantId();
            if (!TenantAwareHelper.validateTenantId(this.flowFrameworkSettings.isMultiTenancyEnabled(), tenantId, listener)) {
                return;
            }
            String workflowId = request.getWorkflowId();
            User user = ParseUtils.getUserContext(this.client);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                ParseUtils.resolveUserAndExecute(user, workflowId, tenantId, this.filterByEnabled, false, this.flowFrameworkSettings.isMultiTenancyEnabled(), listener, () -> this.executeGetRequest(request, tenantId, listener, context), this.client, this.sdkClient, this.clusterService, this.xContentRegistry);
            }
            catch (Exception e) {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve template ({}) from global context.", (Object)workflowId).getFormattedMessage();
                this.logger.error(errorMessage, (Throwable)e);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }
        } else {
            String errorMessage = "There are no templates in the global_context";
            this.logger.error(errorMessage);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
        }
    }

    private void executeGetRequest(WorkflowRequest request, String tenantId, ActionListener<GetWorkflowResponse> listener, ThreadContext.StoredContext context) {
        String workflowId = request.getWorkflowId();
        this.logger.info("Querying workflow from global context: {}", (Object)workflowId);
        this.flowFrameworkIndicesHandler.getTemplate(workflowId, tenantId, (ActionListener<GetResponse>)ActionListener.wrap(response -> {
            if (!response.isExists()) {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve template ({}) from global context.", (Object)workflowId).getFormattedMessage();
                this.logger.error(errorMessage);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
            } else {
                User user = ParseUtils.getUserContext(this.client);
                Template template = this.encryptorUtils.redactTemplateSecuredFields(user, Template.parse(response.getSourceAsString()));
                listener.onResponse((Object)new GetWorkflowResponse(template));
            }
        }, exception -> {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve template ({}) from global context.", (Object)workflowId).getFormattedMessage();
            this.logger.error(errorMessage, (Throwable)exception);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
        }), context);
    }
}

