/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.common.agent.MLToolSpec;

public class ToolStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(ToolStep.class);
    PlainActionFuture<WorkflowData> toolFuture = PlainActionFuture.newFuture();
    public static final String NAME = "create_tool";
    public static final Set<String> REQUIRED_INPUTS = Set.of("type");
    public static final Set<String> OPTIONAL_INPUTS = Set.of("name", "description", "parameters", "config", "include_output_in_agent_response");
    public static final Set<String> PROVIDED_OUTPUTS = Set.of("tools");

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params, String tenantId) {
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(REQUIRED_INPUTS, OPTIONAL_INPUTS, currentNodeInputs, outputs, previousNodeInputs, params);
            String type = (String)inputs.get("type");
            String name = (String)inputs.get("name");
            String description = (String)inputs.get("description");
            Boolean includeOutputInAgentResponse = ParseUtils.parseIfExists(inputs, "include_output_in_agent_response", Boolean.class);
            Set<String> toolParameterKeys = Set.of("connector_id", "model_id", "agent_id");
            Map<String, String> parameters = this.getToolsParametersMap(inputs.getOrDefault("parameters", new HashMap()), previousNodeInputs, outputs, toolParameterKeys);
            Map config = inputs.getOrDefault("config", Collections.emptyMap());
            MLToolSpec.MLToolSpecBuilder builder = MLToolSpec.builder();
            builder.type(type);
            if (name != null) {
                builder.name(name);
            }
            if (description != null) {
                builder.description(description);
            }
            if (parameters != null) {
                builder.parameters(parameters);
            }
            if (includeOutputInAgentResponse != null) {
                builder.includeOutputInAgentResponse(includeOutputInAgentResponse.booleanValue());
            }
            builder.configMap(config);
            MLToolSpec mlToolSpec = builder.build();
            this.toolFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry("tools", mlToolSpec)), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
            logger.info("Tool registered successfully {}", (Object)type);
        }
        catch (IllegalArgumentException iae) {
            this.toolFuture.onFailure((Exception)((Object)new WorkflowStepException(iae.getMessage(), RestStatus.BAD_REQUEST)));
        }
        catch (FlowFrameworkException e) {
            this.toolFuture.onFailure((Exception)((Object)e));
        }
        return this.toolFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Map<String, String> getToolsParametersMap(Object parameters, Map<String, String> previousNodeInputs, Map<String, WorkflowData> outputs, Set<String> toolParameterKeys) {
        Map parametersMap = (Map)parameters;
        for (String toolParameterKey : toolParameterKeys) {
            WorkflowData previousNodeOutput;
            Optional<String> previousNodeParameter = previousNodeInputs.entrySet().stream().filter(e -> toolParameterKey.equals(e.getValue())).map(Map.Entry::getKey).findFirst();
            if (!previousNodeParameter.isPresent() || parametersMap.containsKey(toolParameterKey) || (previousNodeOutput = outputs.get(previousNodeParameter.get())) == null || !previousNodeOutput.getContent().containsKey(toolParameterKey)) continue;
            parametersMap.put(toolParameterKey, previousNodeOutput.getContent().get(toolParameterKey).toString());
        }
        return parametersMap;
    }
}

