"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const zigbee_herdsman_1 = require("zigbee-herdsman");
const m = __importStar(require("../lib/modernExtend"));
const defaultReporting = { min: 0, max: 300, change: 0 };
const normalReporting = { min: 0, max: 3600, change: 0 };
const rareReporting = { min: 0, max: 21600, change: 0 };
const rarestReporting = { min: 0, max: 64800, change: 0 };
const threeReporting = { min: 30, max: 1800, change: 1 };
const fourReporting = { min: 30, max: 1800, change: 10 };
const sixReporting = { min: 3600, max: 21600, change: 1 };
const co2Reporting = { min: 10, max: 600, change: 0.000001 };
const pmReporting = { min: 10, max: 600, change: 0.1 };
const pm2Reporting = { min: 10, max: 600, change: 0.01 };
exports.definitions = [
    {
        zigbeeModel: ["EFEKTA_iAQ3"],
        model: "EFEKTA_iAQ3",
        vendor: "EFEKTA",
        description: "CO2 Monitor with IPS TFT Display, outdoor temperature and humidity, date and time",
        extend: [
            m.deviceEndpoints({ endpoints: { "1": 1, "2": 2 } }),
            m.co2({ reporting: co2Reporting }),
            m.temperature({
                endpointNames: ["1"],
                description: "Measured value of the built-in temperature sensor",
                reporting: fourReporting,
            }),
            m.temperature({
                endpointNames: ["2"],
                description: "Measured value of the external temperature sensor",
                reporting: fourReporting,
            }),
            m.humidity({
                endpointNames: ["1"],
                description: "Measured value of the built-in humidity sensor",
                reporting: fourReporting,
            }),
            m.humidity({
                endpointNames: ["2"],
                description: "Measured value of the external humidity sensor",
                reporting: fourReporting,
            }),
            m.numeric({
                name: "voc_index",
                unit: "VOC Index points",
                cluster: "genAnalogInput",
                attribute: "presentValue",
                description: "VOC index",
                access: "STATE",
                reporting: defaultReporting,
            }),
            m.illuminance({
                access: "STATE",
                reporting: defaultReporting,
            }),
            m.binary({
                name: "auto_brightness",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0203, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable or Disable Auto Brightness of the Display",
            }),
            m.binary({
                name: "night_onoff_backlight",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0401, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Complete shutdown of the backlight at night mode",
            }),
            m.numeric({
                name: "night_on_backlight",
                unit: "Hr",
                valueMin: 0,
                valueMax: 23,
                cluster: "msCO2",
                attribute: { ID: 0x0405, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Night mode activation time",
            }),
            m.numeric({
                name: "night_off_backlight",
                unit: "Hr",
                valueMin: 0,
                valueMax: 23,
                cluster: "msCO2",
                attribute: { ID: 0x0406, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Night mode deactivation time",
            }),
            m.enumLookup({
                name: "rotate",
                lookup: { "0": 0, "90": 90, "180": 180, "270": 270 },
                cluster: "msCO2",
                attribute: { ID: 0x0285, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Display rotation angle",
            }),
            m.binary({
                name: "long_chart_period",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0204, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "The period of plotting the CO2 level(OFF - 1H | ON - 24H)",
            }),
            m.binary({
                name: "long_chart_period2",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0404, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "The period of plotting the VOC Index points(OFF - 1H | ON - 24H)",
            }),
            m.numeric({
                name: "set_altitude",
                unit: "meters",
                valueMin: 0,
                valueMax: 3000,
                cluster: "msCO2",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the altitude above sea level (for high accuracy of the CO2 sensor)",
            }),
            m.numeric({
                name: "temperature_offset",
                unit: "°C",
                valueMin: -50,
                valueMax: 50,
                valueStep: 0.1,
                scale: 10,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust temperature",
            }),
            m.numeric({
                name: "humidity_offset",
                unit: "%",
                valueMin: -50,
                valueMax: 50,
                valueStep: 1,
                cluster: "msRelativeHumidity",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust humidity",
            }),
            m.binary({
                name: "internal_or_external",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0288, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Display data from internal or external TH sensor",
            }),
            m.binary({
                name: "automatic_scal",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0402, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Automatic self calibration",
            }),
            m.binary({
                name: "forced_recalibration",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0202, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Start FRC (Perform Forced Recalibration of the CO2 Sensor)",
            }),
            m.binary({
                name: "factory_reset_co2",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0206, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Factory Reset CO2 sensor",
            }),
            m.numeric({
                name: "manual_forced_recalibration",
                unit: "ppm",
                valueMin: 0,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0207, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Start Manual FRC (Perform Forced Recalibration of the CO2 Sensor)",
            }),
            m.binary({
                name: "enable_gas",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0220, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable CO2 Gas Control",
            }),
            m.binary({
                name: "invert_logic_gas",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0225, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable invert logic CO2 Gas Control",
            }),
            m.numeric({
                name: "high_gas",
                unit: "ppm",
                valueMin: 400,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0221, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting High CO2 Gas Border",
            }),
            m.numeric({
                name: "low_gas",
                unit: "ppm",
                valueMin: 400,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0222, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting Low CO2 Gas Border",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PWS"],
        model: "EFEKTA_PWS",
        vendor: "EFEKTA",
        description: "[Plant Wattering Sensor, CR2450, CR2477 batteries, temperature ]",
        extend: [
            m.soilMoisture({ reporting: rareReporting }),
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.temperature({ reporting: rareReporting }),
            m.numeric({
                name: "report_delay",
                unit: "min",
                valueMin: 1,
                valueMax: 240,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Adjust Report Delay. Setting the time in minutes, by default 15 minutes",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_THP_LR"],
        model: "EFEKTA_THP_LR",
        vendor: "EFEKTA",
        description: "DIY outdoor long-range sensor for temperature, humidity and atmospheric pressure",
        extend: [
            m.battery({
                voltage: true,
                voltageReportingConfig: rarestReporting,
                percentageReportingConfig: rarestReporting,
            }),
            m.temperature({ reporting: rarestReporting }),
            m.humidity({ reporting: rarestReporting }),
            m.pressure({ reporting: rarestReporting }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_ePWS"],
        model: "EFEKTA_ePWS",
        vendor: "EFEKTA",
        description: "Plant wattering sensor with e-ink display",
        extend: [
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.soilMoisture({ reporting: rareReporting }),
            m.temperature({ reporting: rareReporting }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_eON213z"],
        model: "EFEKTA_eON213z",
        vendor: "EFEKTA",
        description: "Temperature and humidity sensor with e-ink2.13",
        extend: [
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.temperature({ reporting: rareReporting }),
            m.humidity({ reporting: rareReporting }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_miniPWS"],
        model: "EFEKTA_miniPWS",
        vendor: "EFEKTA",
        description: "Mini plant wattering sensor",
        extend: [
            m.soilMoisture({ reporting: rareReporting }),
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.numeric({
                name: "report_delay",
                unit: "min",
                valueMin: 1,
                valueMax: 180,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Adjust Report Delay, by default 60 minutes",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_eON213wz"],
        model: "EFEKTA_eON213wz",
        vendor: "EFEKTA",
        description: "Mini weather station, digital barometer, forecast, charts, temperature, humidity",
        extend: [
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.temperature({ reporting: rareReporting }),
            m.humidity({ reporting: rareReporting }),
            m.pressure({ reporting: rareReporting }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_THP"],
        model: "EFEKTA_THP",
        vendor: "EFEKTA",
        description: "DIY temperature, humidity and atmospheric pressure sensor, long battery life",
        extend: [
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.temperature({ reporting: rareReporting }),
            m.humidity({ reporting: rareReporting }),
            m.pressure({ reporting: rareReporting }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PWS_Max"],
        model: "EFEKTA_PWS_Max",
        vendor: "EFEKTA",
        description: "Plant watering sensor EFEKTA PWS max",
        extend: [
            m.soilMoisture({ reporting: rareReporting }),
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.illuminance({ reporting: rareReporting }),
            m.temperature({ reporting: rareReporting }),
            m.humidity({ reporting: rareReporting }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PWS_MaxPro"],
        model: "EFEKTA_PWS_MaxPro",
        vendor: "EFEKTA",
        description: "Plant watering sensor EFEKTA PWS Max Pro,  long battery life",
        extend: [
            m.soilMoisture({ reporting: rareReporting }),
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.illuminance({ reporting: rareReporting }),
            m.temperature({ reporting: rareReporting }),
            m.humidity({ reporting: rareReporting }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_eON29wz"],
        model: "EFEKTA_eON29wz",
        vendor: "EFEKTA",
        description: "Mini weather station, barometer, forecast, charts, temperature, humidity, light",
        extend: [
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.illuminance({ reporting: rareReporting }),
            m.temperature({ reporting: rareReporting }),
            m.humidity({ reporting: rareReporting }),
            m.pressure({ reporting: rareReporting }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_eFlower_Pro"],
        model: "EFEKTA_eFlower_Pro",
        vendor: "EFEKTA",
        description: "Plant Wattering Sensor with e-ink display 2.13",
        extend: [
            m.soilMoisture({ reporting: rareReporting }),
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.illuminance({ reporting: rareReporting }),
            m.temperature({ reporting: rareReporting }),
            m.humidity({ reporting: rareReporting }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_eTH102"],
        model: "EFEKTA_eTH102",
        vendor: "EFEKTA",
        description: "Mini digital thermometer & hygrometer with e-ink1.02",
        extend: [
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.temperature({ reporting: rareReporting }),
            m.humidity({ reporting: rareReporting }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_iAQ"],
        model: "EFEKTA_iAQ",
        vendor: "EFEKTA",
        description: "CO2 Monitor with IPS TFT Display, outdoor temperature and humidity, date and time",
        extend: [
            m.deviceEndpoints({ endpoints: { "1": 1, "2": 2 } }),
            m.co2({ reporting: co2Reporting }),
            m.temperature({
                endpointNames: ["1"],
                description: "Measured value of the built-in temperature sensor",
                reporting: fourReporting,
            }),
            m.temperature({
                endpointNames: ["2"],
                description: "Measured value of the external temperature sensor",
                reporting: fourReporting,
            }),
            m.humidity({
                endpointNames: ["1"],
                description: "Measured value of the built-in humidity sensor",
                reporting: fourReporting,
            }),
            m.humidity({
                endpointNames: ["2"],
                description: "Measured value of the external humidity sensor",
                reporting: fourReporting,
            }),
            m.illuminance({ reporting: fourReporting }),
            m.numeric({
                name: "reading_interval",
                unit: "seconds",
                valueMin: 15,
                valueMax: 300,
                cluster: "msCO2",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval.",
            }),
            m.binary({
                name: "auto_brightness",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0203, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable or Disable Auto Brightness of the Display",
            }),
            m.binary({
                name: "night_onoff_backlight",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0401, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Complete shutdown of the backlight at night mode",
            }),
            m.numeric({
                name: "night_on_backlight",
                unit: "Hr",
                valueMin: 0,
                valueMax: 23,
                cluster: "msCO2",
                attribute: { ID: 0x0405, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Night mode activation time",
            }),
            m.numeric({
                name: "night_off_backlight",
                unit: "Hr",
                valueMin: 0,
                valueMax: 23,
                cluster: "msCO2",
                attribute: { ID: 0x0406, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Night mode deactivation time",
            }),
            m.enumLookup({
                name: "rotate",
                lookup: { "0": 0, "90": 90, "180": 180, "270": 270 },
                cluster: "msCO2",
                attribute: { ID: 0x0285, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Display rotation angle",
            }),
            m.binary({
                name: "long_chart_period",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0204, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "The period of plotting the CO2 level(OFF - 1H | ON - 24H)",
            }),
            m.numeric({
                name: "set_altitude",
                unit: "meters",
                valueMin: 0,
                valueMax: 3000,
                cluster: "msCO2",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the altitude above sea level (for high accuracy of the CO2 sensor)",
            }),
            m.numeric({
                name: "temperature_offset",
                unit: "°C",
                valueMin: -50,
                valueMax: 50,
                valueStep: 0.1,
                scale: 10,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust temperature",
            }),
            m.numeric({
                name: "humidity_offset",
                unit: "%",
                valueMin: -50,
                valueMax: 50,
                valueStep: 1,
                cluster: "msRelativeHumidity",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust humidity",
            }),
            m.binary({
                name: "automatic_calibrations",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0402, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Automatic calibration of the CO2 sensor",
            }),
            m.binary({
                name: "forced_recalibration",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0202, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Start FRC (Perform Forced Recalibration of the CO2 Sensor)",
            }),
            m.binary({
                name: "factory_reset_co2",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0206, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Factory Reset CO2 sensor",
            }),
            m.numeric({
                name: "manual_forced_recalibration",
                unit: "ppm",
                valueMin: 0,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0207, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Start Manual FRC (Perform Forced Recalibration of the CO2 Sensor)",
            }),
            m.binary({
                name: "enable_gas",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0220, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable CO2 Gas Control",
            }),
            m.binary({
                name: "invert_logic_gas",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0225, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable invert logic CO2 Gas Control",
            }),
            m.numeric({
                name: "high_gas",
                unit: "ppm",
                valueMin: 400,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0221, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting High CO2 Gas Border",
            }),
            m.numeric({
                name: "low_gas",
                unit: "ppm",
                valueMin: 400,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0222, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting Low CO2 Gas Border",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_CO2_Smart_Monitor"],
        model: "EFEKTA_CO2_Smart_Monitor",
        vendor: "EFEKTA",
        description: "EFEKTA CO2 Smart Monitor, rgb indicator, can control the relay, binding",
        extend: [
            m.co2({ reporting: co2Reporting }),
            m.temperature({ reporting: fourReporting }),
            m.humidity({ reporting: fourReporting }),
            m.numeric({
                name: "reading_interval",
                unit: "seconds",
                valueMin: 15,
                valueMax: 300,
                cluster: "msCO2",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval.",
            }),
            m.binary({
                name: "light_indicator",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0211, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable or Disable light indicator",
            }),
            m.numeric({
                name: "light_indicator_level",
                unit: "%",
                valueMin: 0,
                valueMax: 100,
                cluster: "msCO2",
                attribute: { ID: 0x0209, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Light indicator level",
            }),
            m.numeric({
                name: "set_altitude",
                unit: "meters",
                valueMin: 0,
                valueMax: 3000,
                cluster: "msCO2",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the altitude above sea level (for high accuracy of the CO2 sensor)",
            }),
            m.numeric({
                name: "temperature_offset",
                unit: "°C",
                valueMin: -50,
                valueMax: 50,
                valueStep: 0.1,
                scale: 10,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0410, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust temperature",
            }),
            m.numeric({
                name: "humidity_offset",
                unit: "%",
                valueMin: -50,
                valueMax: 50,
                valueStep: 1,
                cluster: "msRelativeHumidity",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust humidity",
            }),
            m.binary({
                name: "automatic_calibrations",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0402, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Automatic calibration of the CO2 sensor",
            }),
            m.binary({
                name: "forced_recalibration",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0202, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Start FRC (Perform Forced Recalibration of the CO2 Sensor)",
            }),
            m.binary({
                name: "factory_reset_co2",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0206, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Factory Reset CO2 sensor",
            }),
            m.numeric({
                name: "manual_forced_recalibration",
                unit: "ppm",
                valueMin: 0,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0207, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Start Manual FRC (Perform Forced Recalibration of the CO2 Sensor)",
            }),
            m.binary({
                name: "enable_gas",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0220, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable CO2 Gas Control",
            }),
            m.binary({
                name: "invert_logic_gas",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0225, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable invert logic CO2 Gas Control",
            }),
            m.numeric({
                name: "high_gas",
                unit: "ppm",
                valueMin: 400,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0221, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting High CO2 Gas Border",
            }),
            m.numeric({
                name: "low_gas",
                unit: "ppm",
                valueMin: 400,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0222, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting Low CO2 Gas Border",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_AQ_Smart_Monitor"],
        model: "EFEKTA_AQ_Smart_Monitor",
        vendor: "EFEKTA",
        description: "EFEKTA CO2 & VOC Index Smart Monitor, rgb indicator, can control the relay, binding",
        extend: [
            m.co2({ reporting: co2Reporting }),
            m.temperature({ reporting: fourReporting }),
            m.humidity({ reporting: fourReporting }),
            m.numeric({
                name: "voc_index",
                unit: "VOC Index points",
                cluster: "genAnalogInput",
                attribute: "presentValue",
                description: "VOC index",
                access: "STATE",
                reporting: defaultReporting,
            }),
            m.numeric({
                name: "reading_interval",
                unit: "seconds",
                valueMin: 15,
                valueMax: 300,
                cluster: "msCO2",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval.",
            }),
            m.binary({
                name: "light_indicator",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0211, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable or Disable light indicator",
            }),
            m.numeric({
                name: "light_indicator_level",
                unit: "%",
                valueMin: 0,
                valueMax: 100,
                cluster: "msCO2",
                attribute: { ID: 0x0209, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Light indicator level",
            }),
            m.numeric({
                name: "set_altitude",
                unit: "meters",
                valueMin: 0,
                valueMax: 3000,
                cluster: "msCO2",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the altitude above sea level (for high accuracy of the CO2 sensor)",
            }),
            m.numeric({
                name: "temperature_offset",
                unit: "°C",
                valueMin: -50,
                valueMax: 50,
                valueStep: 0.1,
                scale: 10,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0410, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust temperature",
            }),
            m.numeric({
                name: "humidity_offset",
                unit: "%",
                valueMin: -50,
                valueMax: 50,
                valueStep: 1,
                cluster: "msRelativeHumidity",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust humidity",
            }),
            m.binary({
                name: "automatic_calibrations",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0402, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Automatic calibration of the CO2 sensor",
            }),
            m.binary({
                name: "forced_recalibration",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0202, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Start FRC (Perform Forced Recalibration of the CO2 Sensor)",
            }),
            m.binary({
                name: "factory_reset_co2",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0206, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Factory Reset CO2 sensor",
            }),
            m.numeric({
                name: "manual_forced_recalibration",
                unit: "ppm",
                valueMin: 0,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0207, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Start Manual FRC (Perform Forced Recalibration of the CO2 Sensor)",
            }),
            m.binary({
                name: "enable_co2_gas",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0220, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable CO2 Gas Control",
            }),
            m.binary({
                name: "invert_logic_co2_gas",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0225, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable invert logic CO2 Gas Control",
            }),
            m.numeric({
                name: "high_co2_gas",
                unit: "ppm",
                valueMin: 400,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0221, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting High CO2 Gas Border",
            }),
            m.numeric({
                name: "low_co2_gas",
                unit: "ppm",
                valueMin: 400,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0222, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting Low CO2 Gas Border",
            }),
            m.binary({
                name: "enable_voc",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genAnalogInput",
                attribute: { ID: 0x0220, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable VOC Control",
            }),
            m.binary({
                name: "invert_logic_voc",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genAnalogInput",
                attribute: { ID: 0x0225, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable invert logic VOC Control",
            }),
            m.numeric({
                name: "high_voc",
                unit: "VOC Index points",
                valueMin: 0,
                valueMax: 500,
                cluster: "genAnalogInput",
                attribute: { ID: 0x0221, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting High VOC Border",
            }),
            m.numeric({
                name: "low_voc",
                unit: "VOC Index points",
                valueMin: 0,
                valueMax: 500,
                cluster: "genAnalogInput",
                attribute: { ID: 0x0222, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting Low VOC Border",
            }),
        ],
    },
    {
        zigbeeModel: ["SNZB-02_EFEKTA"],
        model: "SNZB-02_EFEKTA",
        vendor: "EFEKTA",
        description: "Alternative firmware for the SONOFF SNZB-02 sensor from EfektaLab, DIY",
        extend: [
            m.battery({
                voltage: true,
                voltageReportingConfig: rareReporting,
                percentageReportingConfig: rareReporting,
            }),
            m.temperature({ reporting: rareReporting }),
            m.humidity({ reporting: rareReporting }),
            m.numeric({
                name: "report_delay",
                unit: "min",
                valueMin: 1,
                valueMax: 60,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Adjust Report Delay. Setting the time in minutes, by default 5 minutes",
            }),
            m.binary({
                name: "enable_temperature",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0220, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Temperature Control",
            }),
            m.numeric({
                name: "high_temperature",
                unit: "°C",
                valueMin: -5,
                valueMax: 50,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0221, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Setting High Temperature Border",
            }),
            m.numeric({
                name: "low_temperature",
                unit: "°C",
                valueMin: -5,
                valueMax: 50,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0222, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Setting Low Temperature Border",
            }),
            m.binary({
                name: "enable_humidity",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msRelativeHumidity",
                attribute: { ID: 0x0220, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Humidity Control",
            }),
            m.numeric({
                name: "high_humidity",
                unit: "%",
                valueMin: 0,
                valueMax: 99,
                cluster: "msRelativeHumidity",
                attribute: { ID: 0x0221, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting High Humidity Border",
            }),
            m.numeric({
                name: "low_humidity",
                unit: "%",
                valueMin: 0,
                valueMax: 99,
                cluster: "msRelativeHumidity",
                attribute: { ID: 0x0222, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting Low Humidity Border",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_Air_Quality_Station"],
        model: "EFEKTA_Air_Quality_Station",
        vendor: "EFEKTA",
        description: "Air quality station",
        extend: [
            m.co2({
                reporting: false,
                access: "STATE",
            }),
            m.numeric({
                name: "pm1",
                unit: "µg/m³",
                cluster: "pm25Measurement",
                attribute: { ID: 0x0601, type: zigbee_herdsman_1.Zcl.DataType.SINGLE_PREC },
                description: "Measured PM1.0 (particulate matter) concentration",
                access: "STATE",
                reporting: false,
                precision: 1,
            }),
            m.pm25({
                reporting: false,
                access: "STATE",
                description: "Measured PM2.5 (particulate matter) concentration",
                precision: 1,
            }),
            m.numeric({
                name: "pm4",
                unit: "µg/m³",
                cluster: "pm25Measurement",
                attribute: { ID: 0x0605, type: zigbee_herdsman_1.Zcl.DataType.SINGLE_PREC },
                description: "Measured PM4.0 (particulate matter) concentration",
                access: "STATE",
                reporting: false,
                precision: 1,
            }),
            m.numeric({
                name: "pm10",
                unit: "µg/m³",
                cluster: "pm25Measurement",
                attribute: { ID: 0x0602, type: zigbee_herdsman_1.Zcl.DataType.SINGLE_PREC },
                description: "Measured PM10.0 (particulate matter) concentration",
                access: "STATE",
                reporting: false,
                precision: 1,
            }),
            m.numeric({
                name: "pm_size",
                unit: "µm",
                cluster: "pm25Measurement",
                attribute: { ID: 0x0603, type: zigbee_herdsman_1.Zcl.DataType.SINGLE_PREC },
                description: "Typical Particle Size",
                access: "STATE",
                reporting: false,
                precision: 2,
            }),
            m.numeric({
                name: "aqi_25_index",
                unit: "PM2.5 Index",
                cluster: "pm25Measurement",
                attribute: { ID: 0x0604, type: zigbee_herdsman_1.Zcl.DataType.SINGLE_PREC },
                description: "PM 2.5 INDEX",
                access: "STATE",
                reporting: false,
            }),
            m.numeric({
                name: "voc_index",
                unit: "VOC Index points",
                cluster: "genAnalogInput",
                attribute: "presentValue",
                description: "VOC index",
                access: "STATE",
                reporting: false,
            }),
            m.temperature({
                description: "Measured value of the built-in temperature sensor",
                reporting: false,
                access: "STATE",
            }),
            m.humidity({
                description: "Measured value of the built-in humidity sensor",
                reporting: false,
                access: "STATE",
            }),
            m.illuminance({
                access: "STATE",
                reporting: false,
            }),
            m.numeric({
                name: "report_delay",
                unit: "sec",
                valueMin: 6,
                valueMax: 600,
                cluster: "pm25Measurement",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor report delay. Setting the time in seconds (6-600), by default 15 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "auto_brightness",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msIlluminanceMeasurement",
                attribute: { ID: 0x0203, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable or Disable Auto Brightness of the Display",
                access: "STATE_SET",
            }),
            m.binary({
                name: "night_onoff_backlight",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msIlluminanceMeasurement",
                attribute: { ID: 0x0401, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Complete shutdown of the backlight at night mode",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "night_on_backlight",
                unit: "Hr",
                valueMin: 0,
                valueMax: 23,
                cluster: "msIlluminanceMeasurement",
                attribute: { ID: 0x0405, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Night mode activation time",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "night_off_backlight",
                unit: "Hr",
                valueMin: 0,
                valueMax: 23,
                cluster: "msIlluminanceMeasurement",
                attribute: { ID: 0x0406, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Night mode activation time",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "temperature_offset",
                unit: "°C",
                valueMin: -50,
                valueMax: 50,
                valueStep: 0.1,
                scale: 10,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust temperature",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "humidity_offset",
                unit: "%",
                valueMin: -50,
                valueMax: 50,
                valueStep: 1,
                cluster: "msRelativeHumidity",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust humidity",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "auto_clean_interval",
                unit: "day",
                valueMin: 0,
                valueMax: 10,
                valueStep: 1,
                cluster: "pm25Measurement",
                attribute: { ID: 0x0330, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Auto clean interval PM2.5 sensor",
                access: "STATE_SET",
            }),
            m.binary({
                name: "manual_clean",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "pm25Measurement",
                attribute: { ID: 0x0331, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Manual clean PM2.5 sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "set_altitude",
                unit: "meters",
                valueMin: 0,
                valueMax: 3000,
                cluster: "msCO2",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the altitude above sea level (for high accuracy of the CO2 sensor)",
                access: "STATE_SET",
            }),
            m.binary({
                name: "forced_recalibration",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0202, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Start FRC (Perform Forced Recalibration of the CO2 Sensor)",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "manual_forced_recalibration",
                unit: "ppm",
                valueMin: 0,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0207, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Start Manual FRC (Perform Forced Recalibration of the CO2 Sensor)",
                access: "STATE_SET",
            }),
            m.binary({
                name: "automatic_self_calibration",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0402, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Automatic self calibration",
                access: "STATE_SET",
            }),
            m.binary({
                name: "factory_reset_co2",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0206, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Factory Reset CO2 sensor",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_ePST_POW_E_LR"],
        model: "EFEKTA_ePST_POW_E_LR",
        vendor: "EFEKTA",
        description: "Water, gas smart pressure monitor with e-ink display",
        extend: [
            m.pressure({
                unit: "kPa",
                description: "Pressure in kPa",
                scale: 10,
                reporting: false,
                access: "STATE",
            }),
            m.numeric({
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Pressure in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Pressure in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                reporting: false,
                access: "STATE",
            }),
            m.numeric({
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust temperature sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "mains_voltage",
                unit: "V",
                cluster: "genPowerCfg",
                attribute: "mainsVoltage",
                description: "Mains voltage",
                scale: 10,
                precision: 1,
                access: "STATE",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: false,
                percentageReporting: false,
                voltageReporting: false,
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 10,
                valueMax: 300,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval in seconds, by default 20 seconds",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "tx_radio_power",
                lookup: { "4dbm": 4, "19dbm": 19 },
                cluster: "genPowerCfg",
                attribute: { ID: 0x0236, type: zigbee_herdsman_1.Zcl.DataType.INT8 },
                description: "Set TX Radio Power, dbm",
                access: "STATE_SET",
            }),
            m.binary({
                name: "comparison_previous_data",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable сontrol of comparison with previous data",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "invert",
                lookup: { BW: 0, WB: 1 },
                cluster: "genPowerCfg",
                attribute: { ID: 0xf004, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Invert display color",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "fastmode",
                lookup: { Fast: 0, "Ultra Fast": 1 },
                cluster: "genPowerCfg",
                attribute: { ID: 0xf005, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Display refresh mode",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_eTH_POW_E_LR"],
        model: "EFEKTA_eTH_POW_E_LR",
        vendor: "EFEKTA",
        description: "Temperature and humidity smart sensor with with e-ink display",
        extend: [
            m.temperature({
                reporting: false,
                access: "STATE",
            }),
            m.humidity({
                reporting: false,
                access: "STATE",
            }),
            m.numeric({
                name: "mains_voltage",
                unit: "V",
                cluster: "genPowerCfg",
                attribute: "mainsVoltage",
                description: "Mains voltage",
                scale: 10,
                precision: 1,
                access: "STATE",
            }),
            m.battery({
                percentage: true,
                percentageReporting: false,
                lowStatus: true,
                voltage: false,
                voltageReporting: false,
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 10,
                valueMax: 300,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval in seconds, by default 40 seconds",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "tx_radio_power",
                lookup: { "4dbm": 4, "19dbm": 19 },
                cluster: "genPowerCfg",
                attribute: { ID: 0x0236, type: zigbee_herdsman_1.Zcl.DataType.INT8 },
                description: "Set TX Radio Power, dbm",
                access: "STATE_SET",
            }),
            m.binary({
                name: "comparison_previous_data",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable сontrol of comparison with previous data",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "invert",
                lookup: { BW: 0, WB: 1 },
                cluster: "genPowerCfg",
                attribute: { ID: 0xf004, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Invert display color",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "fastmode",
                lookup: { Fast: 0, "Ultra Fast": 1 },
                cluster: "genPowerCfg",
                attribute: { ID: 0xf005, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Display refresh mode",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_T1_Y_LR"],
        model: "EFEKTA_T1_Y_LR",
        vendor: "EFEKTA",
        description: "Temperature sensor DS18B20, AAA bsttery, signal amplifier, works in Tuya",
        extend: [
            m.temperature({
                reporting: false,
                access: "STATE",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: true,
                percentageReporting: false,
                voltageReporting: false,
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_T8_POW"],
        model: "EFEKTA_T8_POW",
        vendor: "EfektaLab",
        description: "Temperature sensor with a signal amplifier, support up to 8 DS18B20",
        extend: [
            m.deviceEndpoints({
                endpoints: {
                    "1": 1,
                    "2": 2,
                    "3": 3,
                    "4": 4,
                    "5": 5,
                    "6": 6,
                    "7": 7,
                    "8": 8,
                },
            }),
            m.temperature({
                endpointNames: ["1"],
                description: "Measured value of the 1 temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["2"],
                description: "Measured value of the 2 temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["3"],
                description: "Measured value of the 3 temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["4"],
                description: "Measured value of the 4 temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["5"],
                description: "Measured value of the 5 temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["6"],
                description: "Measured value of the 6 temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["7"],
                description: "Measured value of the 7 temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["8"],
                description: "Measured value of the 8 temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: false,
                percentageReporting: true,
                percentageReportingConfig: sixReporting,
            }),
            m.numeric({
                name: "number_of_sensors",
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0xa199, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Number of ds18b20 sensors per data bus",
                access: "STATE",
            }),
            m.numeric({
                name: "uptime",
                unit: "Hours",
                cluster: "genTime",
                attribute: "localTime",
                description: "Uptime",
                access: "STATE",
            }),
            m.numeric({
                name: "mains_voltage",
                unit: "V",
                cluster: "genPowerCfg",
                attribute: "mainsVoltage",
                description: "Mains voltage",
                scale: 10,
                precision: 1,
                access: "STATE_GET",
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 3,
                valueMax: 360,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval in seconds, by default 15 seconds",
            }),
            m.enumLookup({
                name: "tx_radio_power",
                lookup: { "4dbm": 4, "19dbm": 19 },
                cluster: "genPowerCfg",
                attribute: { ID: 0x0236, type: zigbee_herdsman_1.Zcl.DataType.INT8 },
                description: "Set TX Radio Power, dbm",
                access: "STATE_SET",
            }),
            m.binary({
                name: "smart_sleep",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0216, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Smart Sleep, short wakeup every 2-7 seconds",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PST_V1_LR"],
        model: "EFEKTA_PST_V1_LR",
        vendor: "EFEKTA",
        description: "Water, gas smart pressure monitor with signal amplifier",
        extend: [
            m.pressure({
                unit: "kPa",
                description: "Measured pressure value in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first temperature sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "raw_temperature",
                unit: "raw unit",
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0007, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Sensor raw temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "raw_temperature_recalibrated",
                unit: "raw unit",
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0009, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Recalibrated sensor raw temperature",
                access: "STATE",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: true,
                percentageReporting: true,
                voltageReporting: false,
                percentageReportingConfig: sixReporting,
            }),
            m.numeric({
                name: "uptime",
                unit: "Hours",
                cluster: "genTime",
                attribute: "localTime",
                description: "Uptime",
                access: "STATE",
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 10,
                valueMax: 300,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval in seconds, by default 15 seconds",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "tx_radio_power",
                lookup: { "4dbm": 4, "19dbm": 19 },
                cluster: "genPowerCfg",
                attribute: { ID: 0x0236, type: zigbee_herdsman_1.Zcl.DataType.INT8 },
                description: "Set TX Radio Power, dbm",
                access: "STATE_SET",
            }),
            m.binary({
                name: "smart_sleep",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0216, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Smart Sleep, short wakeup every 7 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "config_report_enable",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0275, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable reporting based on reporting configuration",
                access: "STATE_SET",
            }),
            m.binary({
                name: "comparison_previous_data",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable сontrol of comparison with previous data",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PST_POW_V1_LR"],
        model: "EFEKTA_PST_POW_V1_LR",
        vendor: "EFEKTA",
        description: "Water, gas smart pressure monitor with two types of power supply",
        extend: [
            m.pressure({
                unit: "kPa",
                description: "Measured pressure value in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first temperature sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "mains_voltage",
                unit: "V",
                cluster: "genPowerCfg",
                attribute: "mainsVoltage",
                description: "Mains voltage",
                scale: 10,
                precision: 1,
                access: "STATE_GET",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: false,
                percentageReporting: true,
                percentageReportingConfig: sixReporting,
            }),
            m.numeric({
                name: "uptime",
                unit: "Hours",
                cluster: "genTime",
                attribute: "localTime",
                description: "Uptime",
                access: "STATE",
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 10,
                valueMax: 360,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval in seconds, by default 10 seconds",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "tx_radio_power",
                lookup: { "4dbm": 4, "19dbm": 19 },
                cluster: "genPowerCfg",
                attribute: { ID: 0x0236, type: zigbee_herdsman_1.Zcl.DataType.INT8 },
                description: "Set TX Radio Power, dbm",
                access: "STATE_SET",
            }),
            m.binary({
                name: "smart_sleep",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0216, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Smart Sleep, short wakeup every 2-7 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "config_report_enable",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0275, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable reporting based on reporting configuration",
                access: "STATE_SET",
            }),
            m.binary({
                name: "comparison_previous_data",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable сontrol of comparison with previous data",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PST_POW_V2_LR"],
        model: "EFEKTA_PST_POW_V2_LR",
        vendor: "EFEKTA",
        description: "Water, gas smart pressure monitor with two types of power supply V2",
        extend: [
            m.pressure({
                unit: "kPa",
                description: "Measured pressure value in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first temperature sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "mains_voltage",
                unit: "V",
                cluster: "genPowerCfg",
                attribute: "mainsVoltage",
                description: "Mains voltage",
                scale: 10,
                precision: 1,
                access: "STATE_GET",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: false,
                percentageReporting: true,
                percentageReportingConfig: sixReporting,
            }),
            m.numeric({
                name: "uptime",
                unit: "Hours",
                cluster: "genTime",
                attribute: "localTime",
                description: "Uptime",
                access: "STATE",
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 10,
                valueMax: 360,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval in seconds, by default 10 seconds",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "tx_radio_power",
                lookup: { "4dbm": 4, "19dbm": 19 },
                cluster: "genPowerCfg",
                attribute: { ID: 0x0236, type: zigbee_herdsman_1.Zcl.DataType.INT8 },
                description: "Set TX Radio Power, dbm",
                access: "STATE_SET",
            }),
            m.binary({
                name: "smart_sleep",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0216, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Smart Sleep, short wakeup every 2-7 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "config_report_enable",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0275, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable reporting based on reporting configuration",
                access: "STATE_SET",
            }),
            m.binary({
                name: "comparison_previous_data",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable сontrol of comparison with previous data",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PST_V1"],
        model: "EFEKTA_PST_V1",
        vendor: "EFEKTA",
        description: "Water, gas smart pressure monitor",
        extend: [
            m.pressure({
                unit: "kPa",
                description: "Measured pressure value in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first temperature sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "raw_temperature",
                unit: "raw unit",
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0007, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Sensor raw temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "raw_temperature_recalibrated",
                unit: "raw unit",
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0009, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Recalibrated sensor raw temperature",
                access: "STATE",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: true,
                percentageReporting: true,
                voltageReporting: false,
                percentageReportingConfig: sixReporting,
            }),
            m.numeric({
                name: "uptime",
                unit: "Hours",
                cluster: "genTime",
                attribute: "localTime",
                description: "Uptime",
                access: "STATE",
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 10,
                valueMax: 300,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.INT8 },
                description: "Setting the sensor reading interval in seconds, by default 15 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "smart_sleep",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0216, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Smart Sleep, short wakeup every 7 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "config_report_enable",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0275, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable reporting based on reporting configuration",
                access: "STATE_SET",
            }),
            m.binary({
                name: "comparison_previous_data",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable сontrol of comparison with previous data",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PST_DUO_V1"],
        model: "EFEKTA_PST_DUO_V1",
        vendor: "EFEKTA",
        description: "Water, gas smart pressure monitor with two sensors",
        extend: [
            m.deviceEndpoints({ endpoints: { "1": 1, "2": 2 } }),
            m.pressure({
                endpointNames: ["1"],
                unit: "kPa",
                description: "Measured pressure value оf the first sensor in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the first sensor in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the first sensor in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["1"],
                description: "Measured value of the first temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first temperature sensor",
                access: "STATE_SET",
            }),
            m.pressure({
                endpointNames: ["2"],
                unit: "kPa",
                description: "Measured pressure value оf the second sensor in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the second sensor in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "pressure in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["2"],
                description: "Measured value of the second temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust second pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "raw_temperature_cal",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust second temperature sensor",
                access: "STATE_SET",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: true,
                percentageReporting: true,
                voltageReporting: false,
                percentageReportingConfig: sixReporting,
            }),
            m.numeric({
                name: "uptime",
                unit: "Hours",
                cluster: "genTime",
                attribute: "localTime",
                description: "Uptime",
                access: "STATE",
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 10,
                valueMax: 360,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting sensor reading interval in seconds, by default 20 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "smart_sleep",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0216, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Smart Sleep, short wakeup every 7 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "config_report_enable",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0275, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable reporting based on reporting configuration",
                access: "STATE_SET",
            }),
            m.binary({
                name: "comparison_previous_data",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable сontrol of comparison with previous data",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PST_DUO_V1_LR"],
        model: "EFEKTA_PST_DUO_V1_LR",
        vendor: "EFEKTA",
        description: "Water, gas smart pressure monitor with two sensors and signal amplifier",
        extend: [
            m.deviceEndpoints({ endpoints: { "1": 1, "2": 2 } }),
            m.pressure({
                endpointNames: ["1"],
                unit: "kPa",
                description: "Measured pressure value оf the first sensor in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the first sensor in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the first sensor in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["1"],
                description: "Measured value of the first temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "raw_temperature_cal",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first temperature sensor",
                access: "STATE_SET",
            }),
            m.pressure({
                endpointNames: ["2"],
                unit: "kPa",
                description: "Measured pressure value оf the second sensor in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the second sensor in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the second sensor in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["2"],
                description: "Measured value of the second temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust second pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust second temperature sensor",
                access: "STATE_SET",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: true,
                percentageReporting: true,
                voltageReporting: false,
                percentageReportingConfig: sixReporting,
            }),
            m.numeric({
                name: "uptime",
                unit: "Hours",
                cluster: "genTime",
                attribute: "localTime",
                description: "Uptime",
                access: "STATE",
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 10,
                valueMax: 360,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval in seconds, by default 40 seconds",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "tx_radio_power",
                lookup: { "4dbm": 4, "19dbm": 19 },
                cluster: "genPowerCfg",
                attribute: { ID: 0x0236, type: zigbee_herdsman_1.Zcl.DataType.INT8 },
                description: "Set TX Radio Power, dbm",
                access: "STATE_SET",
            }),
            m.binary({
                name: "smart_sleep",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0216, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Smart Sleep, short wakeup every 7 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "config_report_enable",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0275, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable reporting based on reporting configuration",
                access: "STATE_SET",
            }),
            m.binary({
                name: "comparison_previous_data",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable сontrol of comparison with previous data",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PST_POW_DUO_V1_LR"],
        model: "EFEKTA_PST_POW_DUO_V1_LR",
        vendor: "EFEKTA",
        description: "Water, gas smart pressure monitor with two sensors, two power supply",
        extend: [
            m.deviceEndpoints({ endpoints: { "1": 1, "2": 2 } }),
            m.pressure({
                endpointNames: ["1"],
                unit: "kPa",
                description: "Measured pressure value оf the first sensor in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the first sensor in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the first sensor in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["1"],
                description: "Measured value of the first temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first temperature sensor",
                access: "STATE_SET",
            }),
            m.pressure({
                endpointNames: ["2"],
                unit: "kPa",
                description: "Measured pressure value оf the second sensor in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the second sensor in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the second sensor in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["2"],
                description: "Measured value of the second temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust second pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust second temperature sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "mains_voltage",
                unit: "V",
                cluster: "genPowerCfg",
                attribute: "mainsVoltage",
                description: "Mains voltage",
                scale: 10,
                precision: 1,
                access: "STATE_GET",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: false,
                percentageReporting: true,
                percentageReportingConfig: sixReporting,
            }),
            m.numeric({
                name: "uptime",
                unit: "Hours",
                cluster: "genTime",
                attribute: "localTime",
                description: "Uptime",
                access: "STATE",
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 10,
                valueMax: 360,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval in seconds, by default 10 seconds",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "tx_radio_power",
                lookup: { "4dbm": 4, "19dbm": 19 },
                cluster: "genPowerCfg",
                attribute: { ID: 0x0236, type: zigbee_herdsman_1.Zcl.DataType.INT8 },
                description: "Set TX Radio Power, dbm",
                access: "STATE_SET",
            }),
            m.binary({
                name: "smart_sleep",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0216, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Smart Sleep, short wakeup every 2-7 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "config_report_enable",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0275, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable reporting based on reporting configuration",
                access: "STATE_SET",
            }),
            m.binary({
                name: "comparison_previous_data",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable сontrol of comparison with previous data",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_PST_POW_DUO_V2_LR"],
        model: "EFEKTA_PST_POW_DUO_V2_LR",
        vendor: "EFEKTA",
        description: "Water, gas smart pressure monitor with two sensors, power supply, V2",
        extend: [
            m.deviceEndpoints({ endpoints: { "1": 1, "2": 2 } }),
            m.pressure({
                endpointNames: ["1"],
                unit: "kPa",
                description: "Measured pressure value оf the first sensor in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the first sensor in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the first sensor in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["1"],
                description: "Measured value of the first temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                endpointNames: ["1"],
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust first temperature sensor",
                access: "STATE_SET",
            }),
            m.pressure({
                endpointNames: ["2"],
                unit: "kPa",
                description: "Measured pressure value оf the second sensor in kPa",
                scale: 10,
                reporting: threeReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "bar",
                unit: "bar",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the second sensor in bar",
                scale: 1000,
                precision: 2,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "psi",
                unit: "psi",
                cluster: "msPressureMeasurement",
                attribute: "measuredValue",
                description: "Measured pressure value оf the second sensor in psi",
                scale: 68.94757,
                precision: 2,
                access: "STATE",
            }),
            m.temperature({
                endpointNames: ["2"],
                description: "Measured value of the second temperature sensor",
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "pressure_offset",
                unit: "kPa",
                valueMin: -100.0,
                valueMax: 100.0,
                cluster: "msPressureMeasurement",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust second pressure sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                endpointNames: ["2"],
                name: "raw_temperature_calibration",
                unit: "raw unit",
                valueMin: -8192,
                valueMax: 8192,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0008, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust second temperature sensor",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "mains_voltage",
                unit: "V",
                cluster: "genPowerCfg",
                attribute: "mainsVoltage",
                description: "Mains voltage",
                scale: 10,
                precision: 1,
                access: "STATE_GET",
            }),
            m.battery({
                percentage: true,
                lowStatus: true,
                voltage: false,
                percentageReporting: true,
                percentageReportingConfig: sixReporting,
            }),
            m.numeric({
                name: "uptime",
                unit: "Hours",
                cluster: "genTime",
                attribute: "localTime",
                description: "Uptime",
                access: "STATE",
            }),
            m.numeric({
                name: "reading_interval",
                unit: "sec",
                valueMin: 10,
                valueMax: 360,
                cluster: "genPowerCfg",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading interval in seconds, by default 10 seconds",
                access: "STATE_SET",
            }),
            m.enumLookup({
                name: "tx_radio_power",
                lookup: { "4dbm": 4, "19dbm": 19 },
                cluster: "genPowerCfg",
                attribute: { ID: 0x0236, type: zigbee_herdsman_1.Zcl.DataType.INT8 },
                description: "Set TX Radio Power, dbm",
                access: "STATE_SET",
            }),
            m.binary({
                name: "smart_sleep",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0216, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable Smart Sleep, short wakeup every 2-7 seconds",
                access: "STATE_SET",
            }),
            m.binary({
                name: "config_report_enable",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0275, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable reporting based on reporting configuration",
                access: "STATE_SET",
            }),
            m.binary({
                name: "comparison_previous_data",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genPowerCfg",
                attribute: { ID: 0x0205, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable сontrol of comparison with previous data",
                access: "STATE_SET",
            }),
        ],
    },
    {
        zigbeeModel: ["EFEKTA_Smart_AQ_Box_R3"],
        model: "EFEKTA_Smart_AQ_Box_R3",
        vendor: "EFEKTA",
        description: "EFEKTA Smart Air Quality Box, can control the relay, binding on some other devices",
        extend: [
            m.numeric({
                name: "pm1",
                unit: "µg/m³",
                cluster: "pm25Measurement",
                attribute: { ID: 0x0601, type: zigbee_herdsman_1.Zcl.DataType.SINGLE_PREC },
                description: "Measured PM1.0 (particulate matter) concentration",
                access: "STATE",
                reporting: pmReporting,
                precision: 1,
            }),
            m.pm25({
                reporting: pmReporting,
                access: "STATE",
                description: "Measured PM2.5 (particulate matter) concentration",
                precision: 1,
            }),
            m.numeric({
                name: "pm4",
                unit: "µg/m³",
                cluster: "pm25Measurement",
                attribute: { ID: 0x0605, type: zigbee_herdsman_1.Zcl.DataType.SINGLE_PREC },
                description: "Measured PM4.0 (particulate matter) concentration",
                access: "STATE",
                reporting: pmReporting,
                precision: 1,
            }),
            m.numeric({
                name: "pm10",
                unit: "µg/m³",
                cluster: "pm25Measurement",
                attribute: { ID: 0x0602, type: zigbee_herdsman_1.Zcl.DataType.SINGLE_PREC },
                description: "Measured PM10.0 (particulate matter) concentration",
                access: "STATE",
                reporting: pmReporting,
                precision: 1,
            }),
            m.numeric({
                name: "pm_size",
                unit: "µm",
                cluster: "pm25Measurement",
                attribute: { ID: 0x0603, type: zigbee_herdsman_1.Zcl.DataType.SINGLE_PREC },
                description: "Typical Particle Size",
                access: "STATE",
                reporting: pm2Reporting,
                precision: 2,
            }),
            m.numeric({
                name: "aqi_25_index",
                unit: "PM2.5 Index",
                cluster: "pm25Measurement",
                attribute: { ID: 0x0604, type: zigbee_herdsman_1.Zcl.DataType.SINGLE_PREC },
                description: "PM 2.5 INDEX",
                access: "STATE",
                reporting: pmReporting,
            }),
            m.co2({
                reporting: co2Reporting,
                access: "STATE",
            }),
            m.numeric({
                name: "voc_index",
                unit: "VOC Index points",
                cluster: "genAnalogInput",
                attribute: "presentValue",
                description: "VOC index",
                access: "STATE",
                reporting: threeReporting,
            }),
            m.pressure({
                reporting: threeReporting,
                access: "STATE",
            }),
            m.temperature({
                reporting: fourReporting,
                access: "STATE",
            }),
            m.humidity({
                reporting: fourReporting,
                access: "STATE",
            }),
            m.numeric({
                name: "reading_delay",
                unit: "sec",
                valueMin: 6,
                valueMax: 600,
                cluster: "msCO2",
                attribute: { ID: 0x0201, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting the sensor reading delay.",
                access: "STATE_SET",
            }),
            m.binary({
                name: "alarm",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0240, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Alarm",
                access: "STATE_SET",
            }),
            m.binary({
                name: "light_indicator",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0211, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable or Disable light indicator",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "light_indicator_level",
                unit: "%",
                valueMin: 0,
                valueMax: 100,
                cluster: "msCO2",
                attribute: { ID: 0x0209, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Light indicator level",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "temperature_offset",
                unit: "°C",
                valueMin: -50,
                valueMax: 50,
                valueStep: 0.1,
                scale: 10,
                cluster: "msTemperatureMeasurement",
                attribute: { ID: 0x0410, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust temperature",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "humidity_offset",
                unit: "%",
                valueMin: -50,
                valueMax: 50,
                valueStep: 1,
                cluster: "msRelativeHumidity",
                attribute: { ID: 0x0210, type: zigbee_herdsman_1.Zcl.DataType.INT16 },
                description: "Adjust humidity",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "auto_clean_interval",
                unit: "day",
                valueMin: 0,
                valueMax: 10,
                valueStep: 1,
                cluster: "pm25Measurement",
                attribute: { ID: 0x0330, type: zigbee_herdsman_1.Zcl.DataType.UINT8 },
                description: "Auto clean interval PM2.5 sensor",
                access: "STATE_SET",
            }),
            m.binary({
                name: "manual_clean",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "pm25Measurement",
                attribute: { ID: 0x0331, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Manual clean PM2.5 sensor",
                access: "STATE_SET",
            }),
            m.binary({
                name: "forced_recalibration",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0202, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Start FRC (Perform Forced Recalibration of the CO2 Sensor)",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "manual_forced_recalibration",
                unit: "ppm",
                valueMin: 0,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0207, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Start Manual FRC (Perform Forced Recalibration of the CO2 Sensor)",
                access: "STATE_SET",
            }),
            m.binary({
                name: "automatic_self_calibration",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0402, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Automatic self calibration",
                access: "STATE_SET",
            }),
            m.binary({
                name: "factory_reset_co2",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0206, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Factory Reset CO2 sensor",
                access: "STATE_SET",
            }),
            m.binary({
                name: "enable_pm25",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "pm25Measurement",
                attribute: { ID: 0x0220, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable PM2.5 Control",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "high_pm25",
                unit: "µg/m³",
                valueMin: 0,
                valueMax: 1000,
                cluster: "pm25Measurement",
                attribute: { ID: 0x0221, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting High PM2.5 Border",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "low_pm25",
                unit: "µg/m³",
                valueMin: 0,
                valueMax: 1000,
                cluster: "pm25Measurement",
                attribute: { ID: 0x0222, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting Low PM2.5 Border",
                access: "STATE_SET",
            }),
            m.binary({
                name: "enable_co2_gas",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "msCO2",
                attribute: { ID: 0x0220, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable CO2 Gas Control",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "high_co2_gas",
                unit: "ppm",
                valueMin: 400,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0221, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Setting High CO2 Gas Border",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "low_co2_gas",
                unit: "ppm",
                valueMin: 400,
                valueMax: 5000,
                cluster: "msCO2",
                attribute: { ID: 0x0222, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting Low CO2 Gas Border",
                access: "STATE_SET",
            }),
            m.binary({
                name: "enable_voc",
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                cluster: "genAnalogInput",
                attribute: { ID: 0x0220, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                description: "Enable VOC Control",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "high_voc",
                unit: "VOC Index points",
                valueMin: 0,
                valueMax: 500,
                cluster: "genAnalogInput",
                attribute: { ID: 0x0221, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting High VOC Border",
                access: "STATE_SET",
            }),
            m.numeric({
                name: "low_voc",
                unit: "VOC Index points",
                valueMin: 0,
                valueMax: 500,
                cluster: "genAnalogInput",
                attribute: { ID: 0x0222, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                description: "Setting Low VOC Border",
                access: "STATE_SET",
            }),
        ],
    },
];
//# sourceMappingURL=efekta.js.map