/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.rrd4j.core.ByteBufferBackend;
import org.rrd4j.core.RrdBackendException;

public abstract class RrdByteArrayBackend
extends ByteBufferBackend {
    private byte[] buffer;

    protected RrdByteArrayBackend(String path) {
        super(path);
    }

    protected void setBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.setByteBuffer(ByteBuffer.wrap(buffer));
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    protected synchronized void read(long offset, byte[] bytes) throws IOException {
        if (offset < 0L || offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal offset: " + offset);
        }
        if (offset + (long)bytes.length > (long)this.buffer.length) {
            throw new RrdBackendException("Not enough bytes available in RRD buffer; RRD " + this.getPath());
        }
        System.arraycopy(this.buffer, (int)offset, bytes, 0, bytes.length);
    }

    @Override
    public long getLength() {
        return this.buffer.length;
    }

    @Override
    protected void setLength(long length) {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal length: " + length);
        }
        this.buffer = new byte[(int)length];
        this.setByteBuffer(ByteBuffer.wrap(this.buffer));
    }
}

