/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class MeasurementValue
implements JsonUnknown,
JsonSerializable {
    public static final String KEY_APP_START_COLD = "app_start_cold";
    public static final String KEY_APP_START_WARM = "app_start_warm";
    public static final String KEY_FRAMES_TOTAL = "frames_total";
    public static final String KEY_FRAMES_SLOW = "frames_slow";
    public static final String KEY_FRAMES_FROZEN = "frames_frozen";
    public static final String KEY_FRAMES_DELAY = "frames_delay";
    public static final String KEY_TIME_TO_INITIAL_DISPLAY = "time_to_initial_display";
    public static final String KEY_TIME_TO_FULL_DISPLAY = "time_to_full_display";
    @NotNull
    private final Number value;
    @Nullable
    private final String unit;
    @Nullable
    private Map<String, Object> unknown;

    public MeasurementValue(@NotNull Number value2, @Nullable String unit) {
        this.value = value2;
        this.unit = unit;
    }

    @TestOnly
    public MeasurementValue(@NotNull Number value2, @Nullable String unit, @Nullable Map<String, Object> unknown) {
        this.value = value2;
        this.unit = unit;
        this.unknown = unknown;
    }

    @TestOnly
    @NotNull
    public Number getValue() {
        return this.value;
    }

    @Nullable
    public String getUnit() {
        return this.unit;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("value").value(this.value);
        if (this.unit != null) {
            writer.name("unit").value(this.unit);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value2);
            }
        }
        writer.endObject();
    }

    public static final class JsonKeys {
        public static final String VALUE = "value";
        public static final String UNIT = "unit";
    }

    public static final class Deserializer
    implements JsonDeserializer<MeasurementValue> {
        @Override
        @NotNull
        public MeasurementValue deserialize(@NotNull ObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            String unit = null;
            Number value2 = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block8: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "value": {
                        value2 = (Number)reader.nextObjectOrNull();
                        continue block8;
                    }
                    case "unit": {
                        unit = reader.nextStringOrNull();
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            reader.endObject();
            if (value2 == null) {
                String message = "Missing required field \"value\"";
                IllegalStateException ex = new IllegalStateException("Missing required field \"value\"");
                logger.log(SentryLevel.ERROR, "Missing required field \"value\"", ex);
                throw ex;
            }
            MeasurementValue measurement = new MeasurementValue(value2, unit);
            measurement.setUnknown(unknown);
            return measurement;
        }
    }
}

