/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, -3.0lf), bvec2(true, false)) => dvec2(-3.0lf, -2.0lf)
 * mix(dvec2(-2.0lf, -2.0lf), dvec2(3.0lf, 3.0lf), bvec2(true, false)) => dvec2(3.0lf, -2.0lf)
 * mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, -3.0lf), bvec2(true, false)) => dvec2(-3.0lf, 2.0lf)
 * mix(dvec2(2.0lf, 2.0lf), dvec2(3.0lf, 3.0lf), bvec2(true, false)) => dvec2(3.0lf, 2.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, -3.0lf), bvec2(true, false)), dvec2(-3.0lf, -2.0lf)) <= 3.6055512754639895e-05lf ? 1 : -1] array0;
  double[distance(mix(dvec2(-2.0lf, -2.0lf), dvec2(3.0lf, 3.0lf), bvec2(true, false)), dvec2(3.0lf, -2.0lf)) <= 3.6055512754639895e-05lf ? 1 : -1] array1;
  double[distance(mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, -3.0lf), bvec2(true, false)), dvec2(-3.0lf, 2.0lf)) <= 3.6055512754639895e-05lf ? 1 : -1] array2;
  double[distance(mix(dvec2(2.0lf, 2.0lf), dvec2(3.0lf, 3.0lf), bvec2(true, false)), dvec2(3.0lf, 2.0lf)) <= 3.6055512754639895e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
